/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration.model.support.oidc;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apereo.cas.configuration.support.RequiredProperty;
import org.apereo.cas.configuration.support.RequiresModule;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

@RequiresModule(name="cas-server-support-oidc")
public class OidcProperties
implements Serializable {
    private static final long serialVersionUID = 813028615694269276L;
    private int jwksCacheInMinutes = 60;
    @RequiredProperty
    private String issuer = "http://localhost:8080/cas/oidc";
    private int skew = 5;
    @RequiredProperty
    private transient Resource jwksFile = new FileSystemResource("/etc/cas/keystore.jwks");
    private String dynamicClientRegistrationMode;
    private List<String> scopes = Stream.of("openid", "profile", "email", "address", "phone", "offline_access").collect(Collectors.toList());
    private List<String> claims = Stream.of("sub", "name", "preferred_username", "family_name", "given_name", "middle_name", "given_name", "profile", "picture", "nickname", "website", "zoneinfo", "locale", "updated_at", "birthdate", "email", "email_verified", "phone_number", "phone_number_verified", "address", "gender").collect(Collectors.toList());
    private List<String> subjectTypes = Stream.of("public", "pairwise").collect(Collectors.toList());
    private Map<String, String> userDefinedScopes = new HashMap<String, String>();
    private Map<String, String> claimsMap = new HashMap<String, String>();

    @Generated
    public int getJwksCacheInMinutes() {
        return this.jwksCacheInMinutes;
    }

    @Generated
    public String getIssuer() {
        return this.issuer;
    }

    @Generated
    public int getSkew() {
        return this.skew;
    }

    @Generated
    public Resource getJwksFile() {
        return this.jwksFile;
    }

    @Generated
    public String getDynamicClientRegistrationMode() {
        return this.dynamicClientRegistrationMode;
    }

    @Generated
    public List<String> getScopes() {
        return this.scopes;
    }

    @Generated
    public List<String> getClaims() {
        return this.claims;
    }

    @Generated
    public List<String> getSubjectTypes() {
        return this.subjectTypes;
    }

    @Generated
    public Map<String, String> getUserDefinedScopes() {
        return this.userDefinedScopes;
    }

    @Generated
    public Map<String, String> getClaimsMap() {
        return this.claimsMap;
    }

    @Generated
    public void setJwksCacheInMinutes(int jwksCacheInMinutes) {
        this.jwksCacheInMinutes = jwksCacheInMinutes;
    }

    @Generated
    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    @Generated
    public void setSkew(int skew) {
        this.skew = skew;
    }

    @Generated
    public void setJwksFile(Resource jwksFile) {
        this.jwksFile = jwksFile;
    }

    @Generated
    public void setDynamicClientRegistrationMode(String dynamicClientRegistrationMode) {
        this.dynamicClientRegistrationMode = dynamicClientRegistrationMode;
    }

    @Generated
    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    @Generated
    public void setClaims(List<String> claims) {
        this.claims = claims;
    }

    @Generated
    public void setSubjectTypes(List<String> subjectTypes) {
        this.subjectTypes = subjectTypes;
    }

    @Generated
    public void setUserDefinedScopes(Map<String, String> userDefinedScopes) {
        this.userDefinedScopes = userDefinedScopes;
    }

    @Generated
    public void setClaimsMap(Map<String, String> claimsMap) {
        this.claimsMap = claimsMap;
    }
}

