/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.spark.structure.io;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.rdd.RDD;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import org.apache.tinkerpop.gremlin.process.computer.KeyValue;
import org.apache.tinkerpop.gremlin.spark.structure.Spark;
import org.apache.tinkerpop.gremlin.spark.structure.io.InputFormatRDD;
import org.apache.tinkerpop.gremlin.spark.structure.io.InputRDD;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.io.Storage;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public final class SparkContextStorage
implements Storage {
    private SparkContextStorage() {
    }

    public static SparkContextStorage open() {
        return new SparkContextStorage();
    }

    public static SparkContextStorage open(String master) {
        Spark.create(master);
        return new SparkContextStorage();
    }

    public static SparkContextStorage open(Configuration configuration) {
        Spark.create(configuration);
        return new SparkContextStorage();
    }

    public static SparkContextStorage open(SparkContext sparkContext) {
        Spark.create(sparkContext);
        return new SparkContextStorage();
    }

    public List<String> ls() {
        return this.ls("*");
    }

    public List<String> ls(String location) {
        ArrayList<String> rdds = new ArrayList<String>();
        String wildCardLocation = (location.endsWith("*") ? location : location + "*").replace('\\', '/').replace(".", "\\.").replace("*", ".*");
        for (RDD<?> rdd : Spark.getRDDs()) {
            if (!rdd.name().replace('\\', '/').matches(wildCardLocation)) continue;
            rdds.add(rdd.name() + " [" + rdd.getStorageLevel().description() + "]");
        }
        return rdds;
    }

    public boolean cp(String sourceLocation, String targetLocation) {
        List rdds = Spark.getRDDs().stream().filter(r -> r.name().startsWith(sourceLocation)).map(RDD::name).collect(Collectors.toList());
        if (rdds.size() == 0) {
            return false;
        }
        for (String rdd : rdds) {
            Spark.getRDD(rdd).toJavaRDD().filter((Function & Serializable)a -> true).setName(rdd.equals(sourceLocation) ? targetLocation : rdd.replace(sourceLocation, targetLocation)).cache().count();
        }
        return true;
    }

    public boolean exists(String location) {
        return this.ls(location).size() > 0;
    }

    public boolean rm(String location) {
        ArrayList<String> rdds = new ArrayList<String>();
        String wildCardLocation = (location.endsWith("*") ? location : location + "*").replace('\\', '/').replace(".", "\\.").replace("*", ".*");
        for (RDD<?> rdd : Spark.getRDDs()) {
            if (!rdd.name().replace('\\', '/').matches(wildCardLocation)) continue;
            rdds.add(rdd.name());
        }
        rdds.forEach(Spark::removeRDD);
        return rdds.size() > 0;
    }

    public Iterator<Vertex> head(String location, Class readerClass, int totalLines) {
        BaseConfiguration configuration = new BaseConfiguration();
        configuration.setProperty("gremlin.hadoop.inputLocation", (Object)location);
        configuration.setProperty("gremlin.hadoop.graphReader", (Object)readerClass.getCanonicalName());
        try {
            if (InputRDD.class.isAssignableFrom(readerClass)) {
                return IteratorUtils.map(((InputRDD)readerClass.getConstructor(new Class[0]).newInstance(new Object[0])).readGraphRDD((Configuration)configuration, new JavaSparkContext(Spark.getContext())).take(totalLines).iterator(), tuple -> ((VertexWritable)tuple._2()).get());
            }
            if (InputFormat.class.isAssignableFrom(readerClass)) {
                return IteratorUtils.map(new InputFormatRDD().readGraphRDD((Configuration)configuration, new JavaSparkContext(Spark.getContext())).take(totalLines).iterator(), tuple -> ((VertexWritable)tuple._2()).get());
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        throw new IllegalArgumentException("The provided parserClass must be an " + InputFormat.class.getCanonicalName() + " or an " + InputRDD.class.getCanonicalName() + ": " + readerClass.getCanonicalName());
    }

    public <K, V> Iterator<KeyValue<K, V>> head(String location, String memoryKey, Class readerClass, int totalLines) {
        BaseConfiguration configuration = new BaseConfiguration();
        configuration.setProperty("gremlin.hadoop.inputLocation", (Object)location);
        configuration.setProperty("gremlin.hadoop.graphReader", (Object)readerClass.getCanonicalName());
        try {
            if (InputRDD.class.isAssignableFrom(readerClass)) {
                return IteratorUtils.map(((InputRDD)readerClass.getConstructor(new Class[0]).newInstance(new Object[0])).readMemoryRDD((Configuration)configuration, memoryKey, new JavaSparkContext(Spark.getContext())).take(totalLines).iterator(), tuple -> new KeyValue(tuple._1(), tuple._2()));
            }
            if (InputFormat.class.isAssignableFrom(readerClass)) {
                return IteratorUtils.map(new InputFormatRDD().readMemoryRDD((Configuration)configuration, memoryKey, new JavaSparkContext(Spark.getContext())).take(totalLines).iterator(), tuple -> new KeyValue(tuple._1(), tuple._2()));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        throw new IllegalArgumentException("The provided parserClass must be an " + InputFormat.class.getCanonicalName() + " or an " + InputRDD.class.getCanonicalName() + ": " + readerClass.getCanonicalName());
    }

    public Iterator<String> head(String location, int totalLines) {
        return IteratorUtils.map(Spark.getRDD(location).toJavaRDD().take(totalLines).iterator(), Object::toString);
    }

    public String describe(String location) {
        return Spark.getRDD(location).toDebugString();
    }

    public String toString() {
        return StringFactory.storageString((String)(null == Spark.getContext() ? "spark:none" : Spark.getContext().master()));
    }
}

