/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.spark.process.computer.traversal.strategy.optimization;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.map.TraversalVertexProgramStep;
import org.apache.tinkerpop.gremlin.process.computer.util.EmptyMemory;
import org.apache.tinkerpop.gremlin.process.traversal.Scope;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.EdgeVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.LambdaFlatMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.LambdaMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.util.empty.EmptyGraph;

public final class SparkSingleIterationStrategy
extends AbstractTraversalStrategy<TraversalStrategy.ProviderOptimizationStrategy>
implements TraversalStrategy.ProviderOptimizationStrategy {
    private static final SparkSingleIterationStrategy INSTANCE = new SparkSingleIterationStrategy();
    private static final Set<Class> MULTI_ITERATION_CLASSES = new HashSet<Class>(Arrays.asList(EdgeVertexStep.class, LambdaMapStep.class, LambdaFlatMapStep.class));

    private SparkSingleIterationStrategy() {
    }

    public void apply(Traversal.Admin<?, ?> traversal) {
        Graph graph = traversal.getGraph().orElse(EmptyGraph.instance());
        for (TraversalVertexProgramStep step : TraversalHelper.getStepsOfClass(TraversalVertexProgramStep.class, traversal)) {
            boolean doesMessagePass;
            Traversal.Admin computerTraversal = step.generateProgram(graph, (Memory)EmptyMemory.instance()).getTraversal().get().clone();
            if (!computerTraversal.isLocked()) {
                computerTraversal.applyStrategies();
            }
            if (!(doesMessagePass = TraversalHelper.hasStepOfAssignableClassRecursively((Scope)Scope.global, MULTI_ITERATION_CLASSES, (Traversal.Admin)computerTraversal))) {
                for (VertexStep vertexStep : TraversalHelper.getStepsOfAssignableClassRecursively((Scope)Scope.global, VertexStep.class, (Traversal.Admin)computerTraversal)) {
                    if (!vertexStep.returnsVertex() && vertexStep.getDirection().equals((Object)Direction.OUT)) continue;
                    doesMessagePass = true;
                    break;
                }
            }
            if (doesMessagePass) continue;
            step.setComputer(step.getComputer().configure("gremlin.spark.skipPartitioner", (Object)true).configure("gremlin.spark.skipGraphCache", (Object)true));
        }
    }

    public static SparkSingleIterationStrategy instance() {
        return INSTANCE;
    }
}

