/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.hadoop.structure.io.script;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.tinkerpop.gremlin.groovy.CompilerCustomizerProvider;
import org.apache.tinkerpop.gremlin.groovy.DefaultImportCustomizerProvider;
import org.apache.tinkerpop.gremlin.groovy.jsr223.GremlinGroovyScriptEngine;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;

public final class ScriptRecordWriter
extends RecordWriter<NullWritable, VertexWritable> {
    protected static final String SCRIPT_FILE = "gremlin.hadoop.scriptOutputFormat.script";
    protected static final String SCRIPT_ENGINE = "gremlin.hadoop.scriptOutputFormat.scriptEngine";
    private static final String VERTEX = "vertex";
    private static final String WRITE_CALL = "stringify(vertex)";
    private static final String UTF8 = "UTF-8";
    private static final byte[] NEWLINE;
    private final DataOutputStream out;
    private final ScriptEngine engine;

    public ScriptRecordWriter(DataOutputStream out, TaskAttemptContext context) throws IOException {
        this.out = out;
        Configuration configuration = context.getConfiguration();
        this.engine = new GremlinGroovyScriptEngine(new CompilerCustomizerProvider[]{new DefaultImportCustomizerProvider()});
        FileSystem fs = FileSystem.get((Configuration)configuration);
        try {
            this.engine.eval(new InputStreamReader((InputStream)fs.open(new Path(configuration.get(SCRIPT_FILE)))));
        }
        catch (ScriptException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public void write(NullWritable key, VertexWritable vertex) throws IOException {
        if (null != vertex) {
            try {
                Bindings bindings = this.engine.createBindings();
                bindings.put(VERTEX, (Object)vertex.get());
                String line = (String)this.engine.eval(WRITE_CALL, bindings);
                if (line != null) {
                    this.out.write(line.getBytes(UTF8));
                    this.out.write(NEWLINE);
                }
            }
            catch (ScriptException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
    }

    public synchronized void close(TaskAttemptContext context) throws IOException {
        this.out.close();
    }

    static {
        try {
            NEWLINE = "\n".getBytes(UTF8);
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalArgumentException("Can not find UTF-8 encoding");
        }
    }
}

