/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.hadoop.groovy.plugin;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.tinkerpop.gremlin.groovy.plugin.AbstractGremlinPlugin;
import org.apache.tinkerpop.gremlin.groovy.plugin.IllegalEnvironmentException;
import org.apache.tinkerpop.gremlin.groovy.plugin.PluginAcceptor;
import org.apache.tinkerpop.gremlin.groovy.plugin.PluginInitializationException;
import org.apache.tinkerpop.gremlin.groovy.plugin.RemoteAcceptor;
import org.apache.tinkerpop.gremlin.hadoop.Constants;
import org.apache.tinkerpop.gremlin.hadoop.groovy.plugin.HadoopRemoteAcceptor;
import org.apache.tinkerpop.gremlin.hadoop.process.computer.mapreduce.MapReduceGraphComputer;
import org.apache.tinkerpop.gremlin.hadoop.structure.HadoopConfiguration;
import org.apache.tinkerpop.gremlin.hadoop.structure.HadoopGraph;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.FileSystemStorage;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.graphson.GraphSONInputFormat;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.gryo.GryoInputFormat;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.script.ScriptInputFormat;
import org.apache.tinkerpop.gremlin.hadoop.structure.util.ConfUtil;

public final class HadoopGremlinPlugin
extends AbstractGremlinPlugin {
    protected static String NAME = "tinkerpop.hadoop";
    protected static final Set<String> IMPORTS = new HashSet<String>(){
        {
            this.add("import org.apache.hadoop.hdfs.*");
            this.add("import org.apache.hadoop.conf.*");
            this.add("import org.apache.hadoop.fs.*");
            this.add("import org.apache.hadoop.util.*");
            this.add("import org.apache.hadoop.io.*");
            this.add("import org.apache.hadoop.io.compress.*");
            this.add("import org.apache.hadoop.mapreduce.lib.input.*");
            this.add("import org.apache.hadoop.mapreduce.lib.output.*");
            this.add("import org.apache.log4j.*");
            this.add("import " + Constants.class.getPackage().getName() + ".*");
            this.add("import " + HadoopConfiguration.class.getPackage().getName() + ".*");
            this.add("import " + ConfUtil.class.getPackage().getName() + ".*");
            this.add("import " + VertexWritable.class.getPackage().getName() + ".*");
            this.add("import " + GryoInputFormat.class.getPackage().getName() + ".*");
            this.add("import " + GraphSONInputFormat.class.getPackage().getName() + ".*");
            this.add("import " + ScriptInputFormat.class.getPackage().getName() + ".*");
            this.add("import " + SequenceFileInputFormat.class.getCanonicalName());
            this.add("import " + MapReduceGraphComputer.class.getPackage().getName() + ".*");
        }
    };

    public String getName() {
        return NAME;
    }

    public void afterPluginTo(PluginAcceptor pluginAcceptor) throws PluginInitializationException, IllegalEnvironmentException {
        pluginAcceptor.addImports(IMPORTS);
        try {
            pluginAcceptor.addBinding("hdfs", (Object)FileSystemStorage.open(FileSystem.get((Configuration)new Configuration())));
            pluginAcceptor.addBinding("fs", (Object)FileSystemStorage.open((FileSystem)FileSystem.getLocal((Configuration)new Configuration())));
            if (null == System.getenv("HADOOP_GREMLIN_LIBS")) {
                HadoopGraph.LOGGER.warn("Be sure to set the environmental variable: HADOOP_GREMLIN_LIBS");
            } else {
                HadoopGraph.LOGGER.info("HADOOP_GREMLIN_LIBS is set to: " + System.getenv("HADOOP_GREMLIN_LIBS"));
            }
        }
        catch (Exception e) {
            throw new PluginInitializationException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean requireRestart() {
        return true;
    }

    public Optional<RemoteAcceptor> remoteAcceptor() {
        return Optional.of(new HadoopRemoteAcceptor(this.shell));
    }
}

