/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.groovy.jsr223.customizer;

import groovy.transform.TimedInterrupt;
import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.tinkerpop.gremlin.groovy.CompilerCustomizerProvider;
import org.apache.tinkerpop.gremlin.groovy.jsr223.customizer.TimedInterruptTimeoutException;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.control.customizers.ASTTransformationCustomizer;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;

public class TimedInterruptCustomizerProvider
implements CompilerCustomizerProvider {
    public static final long DEFAULT_INTERRUPTION_TIMEOUT = 60000L;
    private final long interruptionTimeout;

    public TimedInterruptCustomizerProvider() {
        this(60000L);
    }

    public TimedInterruptCustomizerProvider(Long interruptionTimeout) {
        this.interruptionTimeout = interruptionTimeout;
    }

    public TimedInterruptCustomizerProvider(Integer interruptionTimeout) {
        this.interruptionTimeout = interruptionTimeout.longValue();
    }

    @Override
    public CompilationCustomizer create() {
        HashMap<String, Constable> timedInterruptAnnotationParams = new HashMap<String, Constable>();
        timedInterruptAnnotationParams.put("value", Long.valueOf(this.interruptionTimeout));
        timedInterruptAnnotationParams.put("unit", (Constable)GeneralUtils.propX((Expression)GeneralUtils.classX(TimeUnit.class), (String)TimeUnit.MILLISECONDS.toString()));
        timedInterruptAnnotationParams.put("checkOnMethodStart", Boolean.valueOf(false));
        timedInterruptAnnotationParams.put("thrown", (Constable)GeneralUtils.classX(TimedInterruptTimeoutException.class));
        return new ASTTransformationCustomizer(timedInterruptAnnotationParams, TimedInterrupt.class);
    }
}

