/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.filter;

import java.util.Collections;
import java.util.Random;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.FilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class CoinStep<S>
extends FilterStep<S> {
    private static final Random RANDOM = new Random();
    private final double probability;

    public CoinStep(Traversal.Admin traversal, double probability) {
        super(traversal);
        this.probability = probability;
    }

    @Override
    protected boolean filter(Traverser.Admin<S> traverser) {
        long newBulk = 0L;
        if (traverser.bulk() < 100L) {
            int i = 0;
            while ((long)i < traverser.bulk()) {
                if (this.probability >= RANDOM.nextDouble()) {
                    ++newBulk;
                }
                ++i;
            }
        } else {
            newBulk = Math.round(this.probability * (double)traverser.bulk());
        }
        if (0L == newBulk) {
            return false;
        }
        traverser.setBulk(newBulk);
        return true;
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.probability);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Double.hashCode(this.probability);
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return Collections.singleton(TraverserRequirement.BULK);
    }

    private static double choose(long x, long y) {
        if (y < 0L || y > x) {
            return 0.0;
        }
        if (y > x / 2L) {
            y = x - y;
        }
        double denominator = 1.0;
        double numerator = 1.0;
        for (long i = 1L; i <= y; ++i) {
            denominator *= (double)i;
            numerator *= (double)(x + 1L - i);
        }
        return numerator / denominator;
    }
}

