/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.DefaultTraversalStrategies;
import org.javatuples.Pair;

public class TraversalExplanation
implements Serializable {
    private Traversal.Admin<?, ?> traversal;
    private List<Pair<TraversalStrategy, Traversal.Admin<?, ?>>> strategyTraversals = new ArrayList();

    private TraversalExplanation() {
    }

    public TraversalExplanation(Traversal.Admin<?, ?> traversal) {
        this.traversal = traversal.clone();
        DefaultTraversalStrategies mutatingStrategies = new DefaultTraversalStrategies();
        for (TraversalStrategy<?> strategy : this.traversal.getStrategies().toList()) {
            Traversal.Admin<?, ?> mutatingTraversal = this.traversal.clone();
            mutatingStrategies.addStrategies(strategy);
            mutatingTraversal.setStrategies(mutatingStrategies);
            mutatingTraversal.applyStrategies();
            this.strategyTraversals.add(Pair.with(strategy, mutatingTraversal));
        }
    }

    public List<Pair<TraversalStrategy, Traversal.Admin<?, ?>>> getStrategyTraversals() {
        return Collections.unmodifiableList(this.strategyTraversals);
    }

    public Traversal.Admin<?, ?> getOriginalTraversal() {
        return this.traversal;
    }

    public String toString() {
        return this.prettyPrint(Integer.MAX_VALUE);
    }

    public String prettyPrint() {
        return this.prettyPrint(100);
    }

    public String prettyPrint(int maxLineLength) {
        int i;
        String originalTraversal = "Original Traversal";
        String finalTraversal = "Final Traversal";
        int maxStrategyColumnLength = this.strategyTraversals.stream().map(Pair::getValue0).map(Object::toString).map(String::length).max(Comparator.naturalOrder()).orElse(15);
        int newLineIndent = maxStrategyColumnLength + 10;
        int maxTraversalColumn = maxLineLength - newLineIndent;
        if (maxTraversalColumn < 1) {
            throw new IllegalArgumentException("The maximum line length is too small to present the " + TraversalExplanation.class.getSimpleName() + ": " + maxLineLength);
        }
        int largestTraversalColumn = Stream.concat(Stream.of(Pair.with(null, this.traversal)), this.strategyTraversals.stream()).map(Pair::getValue1).map(Object::toString).map(s -> this.wordWrap((String)s, maxTraversalColumn, newLineIndent)).flatMap(s -> Stream.of(s.split("\n"))).map(String::trim).map(s -> s.trim().startsWith("[") ? s : "   " + s).map(String::length).max(Comparator.naturalOrder()).get();
        StringBuilder builder = new StringBuilder("Traversal Explanation\n");
        for (i = 0; i < maxStrategyColumnLength + 7 + largestTraversalColumn; ++i) {
            builder.append("=");
        }
        builder.append("\n");
        builder.append("Original Traversal");
        for (i = 0; i < maxStrategyColumnLength - "Original Traversal".length() + 7; ++i) {
            builder.append(" ");
        }
        builder.append(this.wordWrap(this.traversal.toString(), maxTraversalColumn, newLineIndent));
        builder.append("\n\n");
        for (Pair<TraversalStrategy, Traversal.Admin<?, ?>> pairs : this.strategyTraversals) {
            int i2;
            builder.append(pairs.getValue0());
            int spacesToAdd = maxStrategyColumnLength - ((TraversalStrategy)pairs.getValue0()).toString().length() + 1;
            for (i2 = 0; i2 < spacesToAdd; ++i2) {
                builder.append(" ");
            }
            builder.append("[").append(((TraversalStrategy)pairs.getValue0()).getTraversalCategory().getSimpleName().substring(0, 1)).append("]");
            for (i2 = 0; i2 < 3; ++i2) {
                builder.append(" ");
            }
            builder.append(this.wordWrap(((Traversal.Admin)pairs.getValue1()).toString(), maxTraversalColumn, newLineIndent)).append("\n");
        }
        builder.append("\n");
        builder.append("Final Traversal");
        for (int i3 = 0; i3 < maxStrategyColumnLength - "Final Traversal".length() + 7; ++i3) {
            builder.append(" ");
        }
        builder.append(this.wordWrap(this.strategyTraversals.size() > 0 ? ((Traversal.Admin)this.strategyTraversals.get(this.strategyTraversals.size() - 1).getValue1()).toString() : this.traversal.toString(), maxTraversalColumn, newLineIndent));
        return builder.toString();
    }

    private String wordWrap(String longString, int maxLengthPerLine, int newLineIndent) {
        if (longString.length() <= maxLengthPerLine) {
            return longString;
        }
        StringBuilder builder = new StringBuilder();
        int counter = 0;
        for (int i = 0; i < longString.length(); ++i) {
            if (0 == counter) {
                builder.append(longString.charAt(i));
            } else if (counter < maxLengthPerLine) {
                builder.append(longString.charAt(i));
            } else {
                builder.append("\n");
                for (int j = 0; j < newLineIndent; ++j) {
                    builder.append(" ");
                }
                builder.append(longString.charAt(i));
                counter = 0;
            }
            ++counter;
        }
        return builder.toString();
    }
}

