/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.tinkerpop.gremlin.process.traversal.util.Metrics;

public class ImmutableMetrics
implements Metrics,
Serializable {
    static final TimeUnit SOURCE_UNIT = TimeUnit.NANOSECONDS;
    protected String id;
    protected String name;
    protected Map<String, AtomicLong> counts = new ConcurrentHashMap<String, AtomicLong>();
    protected long durationNs = 0L;
    protected final Map<String, Object> annotations = new ConcurrentHashMap<String, Object>();
    protected final Map<String, ImmutableMetrics> nested = new LinkedHashMap<String, ImmutableMetrics>();

    protected ImmutableMetrics() {
    }

    @Override
    public long getDuration(TimeUnit unit) {
        return unit.convert(this.durationNs, SOURCE_UNIT);
    }

    @Override
    public Long getCount(String key) {
        if (!this.counts.containsKey(key)) {
            return null;
        }
        return this.counts.get(key).get();
    }

    @Override
    public Map<String, Long> getCounts() {
        HashMap<String, Long> ret = new HashMap<String, Long>();
        for (Map.Entry<String, AtomicLong> count : this.counts.entrySet()) {
            ret.put(count.getKey(), count.getValue().get());
        }
        return ret;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Collection<ImmutableMetrics> getNested() {
        return this.nested.values();
    }

    @Override
    public ImmutableMetrics getNested(String metricsId) {
        return this.nested.get(metricsId);
    }

    @Override
    public Map<String, Object> getAnnotations() {
        return this.annotations;
    }

    @Override
    public Object getAnnotation(String key) {
        return this.annotations.get(key);
    }

    public String toString() {
        return "ImmutableMetrics{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", counts=" + this.counts + ", durationNs=" + this.durationNs + '}';
    }
}

