/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.Mutating;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.Event;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.EventCallback;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.MutationListener;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedFactory;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedProperty;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceFactory;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceProperty;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceVertexProperty;

public final class EventStrategy
extends AbstractTraversalStrategy<TraversalStrategy.DecorationStrategy>
implements TraversalStrategy.DecorationStrategy {
    private final EventQueue eventQueue;
    private final Class<?> detachmentFactory;

    private EventStrategy(Builder builder) {
        this.eventQueue = builder.eventQueue;
        this.eventQueue.setListeners(builder.listeners);
        this.detachmentFactory = builder.detachmentFactory;
    }

    public Class<?> getDetachmentFactory() {
        return this.detachmentFactory;
    }

    public <R> R detach(R attached) {
        if (null == this.detachmentFactory) {
            return attached;
        }
        if (this.detachmentFactory.equals(DetachedFactory.class)) {
            return (R)DetachedFactory.detach(attached, true);
        }
        if (this.detachmentFactory.equals(ReferenceFactory.class)) {
            return (R)ReferenceFactory.detach(attached);
        }
        throw new IllegalStateException("Unknown detachment option using " + this.detachmentFactory.getSimpleName());
    }

    public <R extends Property> R empty(Element element, String key) {
        if (null == this.detachmentFactory || this.detachmentFactory.equals(DetachedFactory.class)) {
            if (element instanceof Vertex) {
                return (R)new DetachedVertexProperty<Object>(null, key, null, null);
            }
            return (R)new DetachedProperty<Object>(key, null);
        }
        if (this.detachmentFactory.equals(ReferenceFactory.class)) {
            if (element instanceof Vertex) {
                return (R)new ReferenceVertexProperty<Object>(new DetachedVertexProperty<Object>(null, key, null, null));
            }
            return (R)new ReferenceProperty<Object>(new DetachedProperty<Object>(key, null));
        }
        throw new IllegalStateException("Unknown empty detachment option using " + this.detachmentFactory.getSimpleName());
    }

    @Override
    public void apply(Traversal.Admin<?, ?> traversal) {
        EventStrategyCallback callback = new EventStrategyCallback(this.eventQueue);
        TraversalHelper.getStepsOfAssignableClass(Mutating.class, traversal).forEach(s -> s.getMutatingCallbackRegistry().addCallback(callback));
    }

    public static Builder build() {
        return new Builder();
    }

    public static class TransactionalEventQueue
    implements EventQueue {
        private final ThreadLocal<Deque<Event>> eventQueue = new ThreadLocal<Deque<Event>>(){

            @Override
            protected Deque<Event> initialValue() {
                return new ArrayDeque<Event>();
            }
        };
        private List<MutationListener> listeners = Collections.emptyList();

        public TransactionalEventQueue(Graph graph) {
            if (!graph.features().graph().supportsTransactions()) {
                throw new IllegalStateException(String.format("%s requires the graph to support transactions", EventStrategy.class.getName()));
            }
            graph.tx().addTransactionListener(status -> {
                if (status == Transaction.Status.COMMIT) {
                    this.fireEventQueue();
                } else if (status == Transaction.Status.ROLLBACK) {
                    this.resetEventQueue();
                } else {
                    throw new RuntimeException(String.format("The %s is not aware of this status: %s", EventQueue.class.getName(), status));
                }
            });
        }

        @Override
        public void addEvent(Event evt) {
            this.eventQueue.get().add(evt);
        }

        @Override
        public void setListeners(List<MutationListener> listeners) {
            this.listeners = listeners;
        }

        private void resetEventQueue() {
            this.eventQueue.set(new ArrayDeque());
        }

        private void fireEventQueue() {
            Deque<Event> deque = this.eventQueue.get();
            Event event = deque.pollFirst();
            while (event != null) {
                event.fireEvent(this.listeners.iterator());
                event = deque.pollFirst();
            }
        }
    }

    public static class DefaultEventQueue
    implements EventQueue {
        private List<MutationListener> listeners = Collections.emptyList();

        @Override
        public void setListeners(List<MutationListener> listeners) {
            this.listeners = listeners;
        }

        @Override
        public void addEvent(Event evt) {
            evt.fireEvent(this.listeners.iterator());
        }
    }

    public static interface EventQueue {
        public void setListeners(List<MutationListener> var1);

        public void addEvent(Event var1);
    }

    public static final class Builder {
        private final List<MutationListener> listeners = new ArrayList<MutationListener>();
        private EventQueue eventQueue = new DefaultEventQueue();
        private Class<?> detachmentFactory = DetachedFactory.class;

        Builder() {
        }

        public Builder addListener(MutationListener listener) {
            this.listeners.add(listener);
            return this;
        }

        public Builder eventQueue(EventQueue eventQueue) {
            this.eventQueue = eventQueue;
            return this;
        }

        public Builder detach(Class<?> factoryClass) {
            this.detachmentFactory = factoryClass;
            return this;
        }

        public EventStrategy create() {
            return new EventStrategy(this);
        }
    }

    public class EventStrategyCallback
    implements EventCallback<Event>,
    Serializable {
        private final EventQueue eventQueue;

        public EventStrategyCallback(EventQueue eventQueue) {
            this.eventQueue = eventQueue;
        }

        @Override
        public void accept(Event event) {
            this.eventQueue.addEvent(event);
        }
    }
}

