/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal;

import java.util.function.BiPredicate;
import org.apache.tinkerpop.gremlin.util.NumberHelper;

public enum Compare implements BiPredicate<Object, Object>
{
    eq{

        @Override
        public boolean test(Object first, Object second) {
            return null == first ? null == second : (first instanceof Number && second instanceof Number ? NumberHelper.compare((Number)first, (Number)second) == 0 : first.equals(second));
        }

        @Override
        public Compare negate() {
            return neq;
        }
    }
    ,
    neq{

        @Override
        public boolean test(Object first, Object second) {
            return !eq.test(first, second);
        }

        @Override
        public Compare negate() {
            return eq;
        }
    }
    ,
    gt{

        @Override
        public boolean test(Object first, Object second) {
            return null != first && null != second && (first instanceof Number && second instanceof Number ? NumberHelper.compare((Number)first, (Number)second) > 0 : ((Comparable)first).compareTo(second) > 0);
        }

        @Override
        public Compare negate() {
            return lte;
        }
    }
    ,
    gte{

        @Override
        public boolean test(Object first, Object second) {
            return null == first ? null == second : null != second && !lt.test(first, second);
        }

        @Override
        public Compare negate() {
            return lt;
        }
    }
    ,
    lt{

        @Override
        public boolean test(Object first, Object second) {
            return null != first && null != second && (first instanceof Number && second instanceof Number ? NumberHelper.compare((Number)first, (Number)second) < 0 : ((Comparable)first).compareTo(second) < 0);
        }

        @Override
        public Compare negate() {
            return gte;
        }
    }
    ,
    lte{

        @Override
        public boolean test(Object first, Object second) {
            return null == first ? null == second : null != second && !gt.test(first, second);
        }

        @Override
        public Compare negate() {
            return gt;
        }
    };


    public abstract Compare negate();
}

