/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal;

import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.remote.RemoteConnection;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.util.empty.EmptyGraph;

public class AnonymousTraversalSource<T extends TraversalSource> {
    private final Class<T> traversalSourceClass;

    private AnonymousTraversalSource(Class<T> traversalSourceClass) {
        this.traversalSourceClass = traversalSourceClass;
    }

    public static AnonymousTraversalSource<GraphTraversalSource> traversal() {
        return AnonymousTraversalSource.traversal(GraphTraversalSource.class);
    }

    public static <T extends TraversalSource> AnonymousTraversalSource<T> traversal(Class<T> traversalSourceClass) {
        return new AnonymousTraversalSource<T>(traversalSourceClass);
    }

    public T withRemote(String configFile) throws Exception {
        return (T)this.withGraph(EmptyGraph.instance()).withRemote(configFile);
    }

    public T withRemote(Configuration conf) {
        return (T)this.withGraph(EmptyGraph.instance()).withRemote(conf);
    }

    public T withRemote(RemoteConnection remoteConnection) {
        return (T)this.withGraph(EmptyGraph.instance()).withRemote(remoteConnection);
    }

    public T withGraph(Graph graph) {
        try {
            return (T)((TraversalSource)this.traversalSourceClass.getConstructor(Graph.class).newInstance(graph));
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

