/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.result;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.util.ValueStack;
import java.io.InputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.result.StrutsResultSupport;

public class StreamResult
extends StrutsResultSupport {
    private static final long serialVersionUID = -1468409635999059850L;
    protected static final Logger LOG = LogManager.getLogger(StreamResult.class);
    public static final String DEFAULT_PARAM = "inputName";
    protected String contentType = "text/plain";
    protected String contentLength;
    protected String contentDisposition = "inline";
    protected String contentCharSet;
    protected String inputName = "inputStream";
    protected InputStream inputStream;
    protected int bufferSize = 1024;
    protected boolean allowCaching = true;

    public StreamResult() {
    }

    public StreamResult(InputStream in) {
        this.inputStream = in;
    }

    public boolean getAllowCaching() {
        return this.allowCaching;
    }

    public void setAllowCaching(boolean allowCaching) {
        this.allowCaching = allowCaching;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(String contentLength) {
        this.contentLength = contentLength;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public void setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
    }

    public String getContentCharSet() {
        return this.contentCharSet;
    }

    public void setContentCharSet(String contentCharSet) {
        this.contentCharSet = contentCharSet;
    }

    public String getInputName() {
        return this.inputName;
    }

    public void setInputName(String inputName) {
        this.inputName = inputName;
    }

    @Override
    protected void doExecute(String finalLocation, ActionInvocation invocation) throws Exception {
        this.resolveParamsFromStack(invocation.getStack(), invocation);
        HttpServletResponse oResponse = (HttpServletResponse)invocation.getInvocationContext().get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
        try (ServletOutputStream oOutput = oResponse.getOutputStream();){
            int iSize;
            if (this.inputStream == null) {
                this.inputStream = (InputStream)invocation.getStack().findValue(this.conditionalParse(this.inputName, invocation));
            }
            if (this.inputStream == null) {
                String msg = "Can not find a java.io.InputStream with the name [" + this.inputName + "] in the invocation stack. " + "Check the <param name=\"inputName\"> tag specified for this action.";
                LOG.error(msg);
                throw new IllegalArgumentException(msg);
            }
            if (this.contentCharSet != null && !this.contentCharSet.equals("")) {
                oResponse.setContentType(this.conditionalParse(this.contentType, invocation) + ";charset=" + this.contentCharSet);
            } else {
                oResponse.setContentType(this.conditionalParse(this.contentType, invocation));
            }
            if (this.contentLength != null) {
                String _contentLength = this.conditionalParse(this.contentLength, invocation);
                int _contentLengthAsInt = -1;
                try {
                    _contentLengthAsInt = Integer.parseInt(_contentLength);
                    if (_contentLengthAsInt >= 0) {
                        oResponse.setContentLength(_contentLengthAsInt);
                    }
                }
                catch (NumberFormatException e) {
                    LOG.warn("failed to recognize {} as a number, contentLength header will not be set", new Object[]{_contentLength, e});
                }
            }
            if (this.contentDisposition != null) {
                oResponse.addHeader("Content-Disposition", this.conditionalParse(this.contentDisposition, invocation));
            }
            if (!this.allowCaching) {
                oResponse.addHeader("Pragma", "no-cache");
                oResponse.addHeader("Cache-Control", "no-cache");
            }
            LOG.debug("Streaming result [{}] type=[{}] length=[{}] content-disposition=[{}] charset=[{}]", new Object[]{this.inputName, this.contentType, this.contentLength, this.contentDisposition, this.contentCharSet});
            LOG.debug("Streaming to output buffer +++ START +++");
            byte[] oBuff = new byte[this.bufferSize];
            while (-1 != (iSize = this.inputStream.read(oBuff))) {
                LOG.debug("Sending stream ... {}", new Object[]{iSize});
                oOutput.write(oBuff, 0, iSize);
            }
            LOG.debug("Streaming to output buffer +++ END +++");
            oOutput.flush();
        }
    }

    protected void resolveParamsFromStack(ValueStack stack, ActionInvocation invocation) {
        Integer bufferSize;
        String contentLength;
        String inputName;
        String contentType;
        String disposition = stack.findString("contentDisposition");
        if (disposition != null) {
            this.setContentDisposition(disposition);
        }
        if ((contentType = stack.findString("contentType")) != null) {
            this.setContentType(contentType);
        }
        if ((inputName = stack.findString(DEFAULT_PARAM)) != null) {
            this.setInputName(inputName);
        }
        if ((contentLength = stack.findString("contentLength")) != null) {
            this.setContentLength(contentLength);
        }
        if ((bufferSize = (Integer)stack.findValue("bufferSize", Integer.class)) != null) {
            this.setBufferSize(bufferSize);
        }
        this.contentCharSet = this.contentCharSet != null ? this.conditionalParse(this.contentCharSet, invocation) : stack.findString("contentCharSet");
    }
}

