/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.config.entities.ResultConfig;
import com.opensymphony.xwork2.interceptor.PreResultListener;
import com.opensymphony.xwork2.interceptor.ValidationAware;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.MessageStoreInterceptor;
import org.apache.struts2.result.ServletActionRedirectResult;
import org.apache.struts2.result.ServletRedirectResult;

class MessageStorePreResultListener
implements PreResultListener {
    private static final Logger LOG = LogManager.getLogger(MessageStorePreResultListener.class);
    private MessageStoreInterceptor interceptor;

    public MessageStorePreResultListener(MessageStoreInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    @Override
    public void beforeResult(ActionInvocation invocation, String resultCode) {
        boolean isInvalidated;
        boolean isCommitted = ServletActionContext.getResponse().isCommitted();
        if (isCommitted) {
            LOG.trace("Response was already committed, cannot store messages!");
            return;
        }
        boolean bl = isInvalidated = ServletActionContext.getRequest().getSession(false) == null;
        if (isInvalidated) {
            LOG.trace("Session was invalidated or never created, cannot store messages!");
            return;
        }
        Map<String, Object> session = invocation.getInvocationContext().getSession();
        if (session == null) {
            LOG.trace("Could not store action [{}] error/messages into session, because session hasn't been opened yet.", new Object[]{invocation.getAction()});
            return;
        }
        String reqOperationMode = this.interceptor.getRequestOperationMode(invocation);
        boolean isRedirect = false;
        try {
            ResultConfig resultConfig = invocation.getProxy().getConfig().getResults().get(resultCode);
            if (resultConfig != null) {
                isRedirect = ServletRedirectResult.class.getName().equals(resultConfig.getClassName()) || ServletActionRedirectResult.class.getName().equals(resultConfig.getClassName());
            }
        }
        catch (Exception e) {
            LOG.warn("Cannot read result!", (Throwable)e);
        }
        if ("STORE".equalsIgnoreCase(reqOperationMode) || "STORE".equalsIgnoreCase(this.interceptor.getOperationModel()) || "AUTOMATIC".equalsIgnoreCase(this.interceptor.getOperationModel()) && isRedirect) {
            Object action = invocation.getAction();
            if (action instanceof ValidationAware) {
                LOG.debug("Storing action [{}] error/messages into session ", new Object[]{action});
                ValidationAware validationAwareAction = (ValidationAware)action;
                session.put("__MessageStoreInterceptor_ActionErrors_SessionKey", validationAwareAction.getActionErrors());
                session.put("__MessageStoreInterceptor_ActionMessages_SessionKey", validationAwareAction.getActionMessages());
                session.put("__MessageStoreInterceptor_FieldErrors_SessionKey", validationAwareAction.getFieldErrors());
            } else {
                LOG.debug("Action [{}] is not ValidationAware, no message / error that are storeable", new Object[]{action});
            }
        }
    }
}

