/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.validator.validators;

import com.opensymphony.xwork2.validator.ValidationException;
import com.opensymphony.xwork2.validator.validators.FieldValidatorSupport;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class URLValidator
extends FieldValidatorSupport {
    private String urlRegex;
    private String urlRegexExpression;

    @Override
    public void validate(Object object) throws ValidationException {
        String fieldName = this.getFieldName();
        Object value = this.getFieldValue(fieldName, object);
        if (value == null || value.toString().length() == 0) {
            return;
        }
        if (!value.getClass().equals(String.class) || !Pattern.compile(this.getUrlRegex()).matcher((String)value).matches()) {
            this.addFieldError(fieldName, object);
        }
    }

    public String getUrlRegex() {
        if (StringUtils.isNotEmpty((CharSequence)this.urlRegexExpression)) {
            return (String)this.parse(this.urlRegexExpression, String.class);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.urlRegex)) {
            return this.urlRegex;
        }
        return "^(https?|ftp):\\/\\/(([a-z0-9$_\\.\\+!\\*\\'\\(\\),;\\?&=-]|%[0-9a-f]{2})+(:([a-z0-9$_\\.\\+!\\*\\'\\(\\),;\\?&=-]|%[0-9a-f]{2})+)?@)?(#?)((([a-z0-9]\\.|[a-z0-9][a-z0-9-]*[a-z0-9]\\.)*[a-z][a-z0-9-]*[a-z0-9]|((\\d|[1-9]\\d|1\\d{2}|2[0-4][0-9]|25[0-5])\\.){3}(\\d|[1-9]\\d|1\\d{2}|2[0-4][0-9]|25[0-5]))(:\\d+)?)(((\\/+([a-z0-9$_\\.\\+!\\*\\'\\(\\),;:@&=-]|%[0-9a-f]{2})*)*(\\?([a-z0-9$_\\.\\+!\\*\\'\\(\\),;:@&=-]|%[0-9a-f]{2})*)?)?)?(#([a-z0-9$_\\.\\+!\\*\\'\\(\\),;:@&=-]|%[0-9a-f]{2})*)?$";
    }

    public void setUrlRegex(String urlRegex) {
        this.urlRegex = urlRegex;
    }

    public void setUrlRegexExpression(String urlRegexExpression) {
        this.urlRegexExpression = urlRegexExpression;
    }
}

