/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.validator.validators;

import com.opensymphony.xwork2.validator.ValidationException;
import com.opensymphony.xwork2.validator.validators.FieldValidatorSupport;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RegexFieldValidator
extends FieldValidatorSupport {
    private static final Logger LOG = LogManager.getLogger(RegexFieldValidator.class);
    private String regex;
    private String regexExpression;
    private Boolean caseSensitive = true;
    private String caseSensitiveExpression = "";
    private Boolean trim = true;
    private String trimExpression = "";

    @Override
    public void validate(Object object) throws ValidationException {
        Matcher matcher;
        String fieldName = this.getFieldName();
        Object value = this.getFieldValue(fieldName, object);
        String regexToUse = this.getRegex();
        LOG.debug("Defined regexp as [{}]", new Object[]{regexToUse});
        if (value == null || regexToUse == null) {
            return;
        }
        if (!(value instanceof String)) {
            return;
        }
        String str = ((String)value).trim();
        if (str.length() == 0) {
            return;
        }
        Pattern pattern = this.isCaseSensitive() ? Pattern.compile(regexToUse) : Pattern.compile(regexToUse, 2);
        String compare = (String)value;
        if (this.isTrimed()) {
            compare = compare.trim();
        }
        if (!(matcher = pattern.matcher(compare)).matches()) {
            this.addFieldError(fieldName, object);
        }
    }

    public String getRegex() {
        if (StringUtils.isNotEmpty((CharSequence)this.regex)) {
            return this.regex;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.regexExpression)) {
            return (String)this.parse(this.regexExpression, String.class);
        }
        return null;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public void setRegexExpression(String regexExpression) {
        this.regexExpression = regexExpression;
    }

    public boolean isCaseSensitive() {
        if (StringUtils.isNotEmpty((CharSequence)this.caseSensitiveExpression)) {
            return (Boolean)this.parse(this.caseSensitiveExpression, Boolean.class);
        }
        return this.caseSensitive;
    }

    public void setCaseSensitive(Boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void setCaseSensitiveExpression(String caseSensitiveExpression) {
        this.caseSensitiveExpression = caseSensitiveExpression;
    }

    public boolean isTrimed() {
        if (StringUtils.isNotEmpty((CharSequence)this.trimExpression)) {
            return (Boolean)this.parse(this.trimExpression, Boolean.class);
        }
        return this.trim;
    }

    public void setTrim(Boolean trim) {
        this.trim = trim;
    }

    public void setTrimExpression(String trimExpression) {
        this.trimExpression = trimExpression;
    }
}

