/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.security;

import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.security.ExcludedPatternsChecker;
import com.opensymphony.xwork2.util.TextParseUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultExcludedPatternsChecker
implements ExcludedPatternsChecker {
    private static final Logger LOG = LogManager.getLogger(DefaultExcludedPatternsChecker.class);
    public static final String[] EXCLUDED_PATTERNS = new String[]{"(^|\\%\\{)((#?)(top(\\.|\\['|\\[\")|\\[\\d\\]\\.)?)(dojo|struts|session|request|response|application|servlet(Request|Response|Context)|parameters|context|_memberAccess)(\\.|\\[).*", ".*(^|\\.|\\[|\\'|\"|get)class(\\(\\.|\\[|\\'|\").*", "^(action|method):.*"};
    private Set<Pattern> excludedPatterns;

    public DefaultExcludedPatternsChecker() {
        this.setExcludedPatterns(EXCLUDED_PATTERNS);
    }

    @Inject(value="overrideExcludedPatterns", required=false)
    public void setOverrideExcludePatterns(String excludePatterns) {
        LOG.warn("Overriding excluded patterns [{}] with [{}], be aware that this affects all instances and safety of your application!", new Object[]{"overrideExcludedPatterns", excludePatterns});
        this.excludedPatterns = new HashSet<Pattern>();
        for (String pattern : TextParseUtil.commaDelimitedStringToSet(excludePatterns)) {
            this.excludedPatterns.add(Pattern.compile(pattern, 2));
        }
    }

    @Inject(value="additionalExcludedPatterns", required=false)
    public void setAdditionalExcludePatterns(String excludePatterns) {
        LOG.debug("Adding additional global patterns [{}] to excluded patterns!", new Object[]{excludePatterns});
        for (String pattern : TextParseUtil.commaDelimitedStringToSet(excludePatterns)) {
            this.excludedPatterns.add(Pattern.compile(pattern, 2));
        }
    }

    @Override
    public void setExcludedPatterns(String commaDelimitedPatterns) {
        this.setExcludedPatterns(TextParseUtil.commaDelimitedStringToSet(commaDelimitedPatterns));
    }

    @Override
    public void setExcludedPatterns(String[] patterns) {
        this.setExcludedPatterns(new HashSet<String>(Arrays.asList(patterns)));
    }

    @Override
    public void setExcludedPatterns(Set<String> patterns) {
        LOG.trace("Sets excluded patterns [{}]", new Object[]{patterns});
        this.excludedPatterns = new HashSet<Pattern>(patterns.size());
        for (String pattern : patterns) {
            this.excludedPatterns.add(Pattern.compile(pattern, 2));
        }
    }

    @Override
    public ExcludedPatternsChecker.IsExcluded isExcluded(String value) {
        for (Pattern excludedPattern : this.excludedPatterns) {
            if (!excludedPattern.matcher(value).matches()) continue;
            LOG.trace("[{}] matches excluded pattern [{}]", new Object[]{value, excludedPattern});
            return ExcludedPatternsChecker.IsExcluded.yes(excludedPattern);
        }
        return ExcludedPatternsChecker.IsExcluded.no(this.excludedPatterns);
    }

    @Override
    public Set<Pattern> getExcludedPatterns() {
        return this.excludedPatterns;
    }
}

