/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.util.LocalizedTextUtil;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class I18nInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 2496830135246700300L;
    protected static final Logger LOG = LogManager.getLogger(I18nInterceptor.class);
    public static final String DEFAULT_SESSION_ATTRIBUTE = "WW_TRANS_I18N_LOCALE";
    public static final String DEFAULT_PARAMETER = "request_locale";
    public static final String DEFAULT_REQUESTONLY_PARAMETER = "request_only_locale";
    protected String parameterName = "request_locale";
    protected String requestOnlyParameterName = "request_only_locale";
    protected String attributeName = "WW_TRANS_I18N_LOCALE";

    public I18nInterceptor() {
        LOG.debug("new I18nInterceptor()");
    }

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public void setRequestOnlyParameterName(String requestOnlyParameterName) {
        this.requestOnlyParameterName = requestOnlyParameterName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    @Override
    public String intercept(ActionInvocation invocation) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Intercept '{}/{}' {", new Object[]{invocation.getProxy().getNamespace(), invocation.getProxy().getActionName()});
        }
        LocaleFinder localeFinder = new LocaleFinder(invocation);
        Locale locale = this.getLocaleFromParam(localeFinder.getRequestedLocale());
        locale = this.storeLocale(invocation, locale, localeFinder.getStorage());
        this.saveLocale(invocation, locale);
        if (LOG.isDebugEnabled()) {
            LOG.debug("before Locale: {}", new Object[]{invocation.getStack().findValue("locale")});
        }
        String result = invocation.invoke();
        if (LOG.isDebugEnabled()) {
            LOG.debug("after Locale {}", new Object[]{invocation.getStack().findValue("locale")});
            LOG.debug("intercept } ");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Locale storeLocale(ActionInvocation invocation, Locale locale, String storage) {
        Map<String, Object> session = invocation.getInvocationContext().getSession();
        if (session != null) {
            Map<String, Object> map = session;
            synchronized (map) {
                if (locale == null) {
                    storage = Storage.NONE.toString();
                    locale = this.readStoredLocale(invocation, session);
                }
                if (Storage.SESSION.toString().equals(storage)) {
                    session.put(this.attributeName, locale);
                }
            }
        }
        return locale;
    }

    protected Locale getLocaleFromParam(Object requestedLocale) {
        Locale locale = null;
        if (requestedLocale != null) {
            Locale locale2 = locale = requestedLocale instanceof Locale ? (Locale)requestedLocale : LocalizedTextUtil.localeFromString(requestedLocale.toString(), null);
            if (locale != null) {
                LOG.debug("Applied request locale: {}", new Object[]{locale});
            }
        }
        if (locale != null && !Arrays.asList(Locale.getAvailableLocales()).contains(locale)) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    protected Locale readStoredLocale(ActionInvocation invocation, Map<String, Object> session) {
        Locale locale = this.readStoredLocalFromSession(invocation, session);
        if (locale != null) {
            return locale;
        }
        return this.readStoredLocalFromCurrentInvocation(invocation);
    }

    protected Locale readStoredLocalFromSession(ActionInvocation invocation, Map<String, Object> session) {
        Object sessionLocale = session.get(this.attributeName);
        if (sessionLocale != null && sessionLocale instanceof Locale) {
            Locale locale = (Locale)sessionLocale;
            LOG.debug("Applied session locale: {}", new Object[]{locale});
            return locale;
        }
        return null;
    }

    protected Locale readStoredLocalFromCurrentInvocation(ActionInvocation invocation) {
        Locale locale = invocation.getInvocationContext().getLocale();
        if (locale != null) {
            LOG.debug("Applied invocation context locale: {}", new Object[]{locale});
        }
        return locale;
    }

    protected Object findLocaleParameter(Map<String, Object> params, String parameterName) {
        Object requestedLocale = params.remove(parameterName);
        if (requestedLocale != null && requestedLocale.getClass().isArray() && ((Object[])requestedLocale).length > 0) {
            requestedLocale = ((Object[])requestedLocale)[0];
            LOG.debug("Requested locale: {}", new Object[]{requestedLocale});
        }
        return requestedLocale;
    }

    protected void saveLocale(ActionInvocation invocation, Locale locale) {
        invocation.getInvocationContext().setLocale(locale);
    }

    protected class LocaleFinder {
        protected String storage = Storage.SESSION.toString();
        protected Object requestedLocale = null;
        protected ActionInvocation actionInvocation = null;

        protected LocaleFinder(ActionInvocation invocation) {
            this.actionInvocation = invocation;
            this.find();
        }

        protected void find() {
            Map<String, Object> params = this.actionInvocation.getInvocationContext().getParameters();
            this.storage = Storage.SESSION.toString();
            this.requestedLocale = I18nInterceptor.this.findLocaleParameter(params, I18nInterceptor.this.parameterName);
            if (this.requestedLocale != null) {
                return;
            }
            this.requestedLocale = I18nInterceptor.this.findLocaleParameter(params, I18nInterceptor.this.requestOnlyParameterName);
            if (this.requestedLocale != null) {
                this.storage = Storage.NONE.toString();
            }
        }

        public String getStorage() {
            return this.storage;
        }

        public Object getRequestedLocale() {
            return this.requestedLocale;
        }
    }

    protected static enum Storage {
        SESSION,
        NONE;

    }
}

