/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionMap<K, V>
extends AbstractMap<K, V>
implements Serializable {
    private static final long serialVersionUID = 4678843241638046854L;
    protected HttpSession session;
    protected Set<Map.Entry<K, V>> entries;
    protected HttpServletRequest request;

    public SessionMap(HttpServletRequest request) {
        this.request = request;
        this.session = request.getSession(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        if (this.session == null) {
            return;
        }
        String string = this.session.getId().intern();
        synchronized (string) {
            this.session.invalidate();
            this.session = null;
            this.entries = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        if (this.session == null) {
            return;
        }
        String string = this.session.getId().intern();
        synchronized (string) {
            this.entries = null;
            Enumeration attributeNamesEnum = this.session.getAttributeNames();
            while (attributeNamesEnum.hasMoreElements()) {
                this.session.removeAttribute((String)attributeNamesEnum.nextElement());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.session == null) {
            return Collections.emptySet();
        }
        String string = this.session.getId().intern();
        synchronized (string) {
            if (this.entries == null) {
                this.entries = new HashSet<Map.Entry<K, V>>();
                Enumeration enumeration = this.session.getAttributeNames();
                while (enumeration.hasMoreElements()) {
                    final String key = enumeration.nextElement().toString();
                    final Object value = this.session.getAttribute(key);
                    this.entries.add(new Map.Entry<K, V>(){

                        @Override
                        public boolean equals(Object obj) {
                            if (!(obj instanceof Map.Entry)) {
                                return false;
                            }
                            Map.Entry entry = (Map.Entry)obj;
                            return (key == null ? entry.getKey() == null : key.equals(entry.getKey())) && (value == null ? entry.getValue() == null : value.equals(entry.getValue()));
                        }

                        @Override
                        public int hashCode() {
                            return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
                        }

                        @Override
                        public K getKey() {
                            return key;
                        }

                        @Override
                        public V getValue() {
                            return value;
                        }

                        @Override
                        public V setValue(Object obj) {
                            SessionMap.this.session.setAttribute(key, obj);
                            return value;
                        }
                    });
                }
            }
        }
        return this.entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        if (this.session == null) {
            return null;
        }
        String string = this.session.getId().intern();
        synchronized (string) {
            return (V)this.session.getAttribute(key.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        Object object = this;
        synchronized (object) {
            if (this.session == null) {
                this.session = this.request.getSession(true);
            }
        }
        object = this.session.getId().intern();
        synchronized (object) {
            V oldValue = this.get(key);
            this.entries = null;
            this.session.setAttribute(key.toString(), value);
            return oldValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        if (this.session == null) {
            return null;
        }
        String string = this.session.getId().intern();
        synchronized (string) {
            this.entries = null;
            V value = this.get(key);
            this.session.removeAttribute(key.toString());
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        if (this.session == null) {
            return false;
        }
        String string = this.session.getId().intern();
        synchronized (string) {
            return this.session.getAttribute(key.toString()) != null;
        }
    }
}

