/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.velocity;

import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.StrutsException;
import org.apache.struts2.util.VelocityStrutsUtil;
import org.apache.struts2.views.TagLibrary;
import org.apache.struts2.views.util.ContextUtil;
import org.apache.struts2.views.velocity.StrutsVelocityContext;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.view.ToolboxManager;
import org.apache.velocity.tools.view.context.ChainedContext;
import org.apache.velocity.tools.view.servlet.ServletToolboxManager;

public class VelocityManager {
    private static final Logger LOG = LoggerFactory.getLogger(VelocityManager.class);
    public static final String STRUTS = "struts";
    private ObjectFactory objectFactory;
    public static final String KEY_VELOCITY_STRUTS_CONTEXT = ".KEY_velocity.struts2.context";
    public static final String PARENT = "parent";
    public static final String TAG = "tag";
    private VelocityEngine velocityEngine;
    protected ToolboxManager toolboxManager = null;
    private String toolBoxLocation;
    private String[] chainedContextNames;
    private Properties velocityProperties;
    private String customConfigFile;
    private List<TagLibrary> tagLibraries;

    @Inject
    public void setObjectFactory(ObjectFactory fac) {
        this.objectFactory = fac;
    }

    @Inject
    public void setContainer(Container container) {
        ArrayList<Object> list = new ArrayList<Object>();
        Set prefixes = container.getInstanceNames(TagLibrary.class);
        for (String prefix : prefixes) {
            list.add(container.getInstance(TagLibrary.class, prefix));
        }
        this.tagLibraries = Collections.unmodifiableList(list);
    }

    public VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }

    public Context createContext(ValueStack stack, HttpServletRequest req, HttpServletResponse res) {
        StrutsVelocityContext result = null;
        VelocityContext[] chainedContexts = this.prepareChainedContexts(req, res, stack.getContext());
        StrutsVelocityContext context = new StrutsVelocityContext(chainedContexts, stack);
        Map standardMap = ContextUtil.getStandardContext(stack, req, res);
        for (Map.Entry entry : standardMap.entrySet()) {
            context.put((String)entry.getKey(), entry.getValue());
        }
        context.put(STRUTS, new VelocityStrutsUtil(this.velocityEngine, (Context)context, stack, req, res));
        ServletContext ctx = null;
        try {
            ctx = ServletActionContext.getServletContext();
        }
        catch (NullPointerException npe) {
            LOG.debug("internal toolbox context ignored", new String[0]);
        }
        if (this.toolboxManager != null && ctx != null) {
            ChainedContext chained = new ChainedContext((Context)context, this.velocityEngine, req, res, ctx);
            chained.setToolbox(this.toolboxManager.getToolbox((Object)chained));
            result = chained;
        } else {
            result = context;
        }
        req.setAttribute(KEY_VELOCITY_STRUTS_CONTEXT, (Object)result);
        return result;
    }

    protected VelocityContext[] prepareChainedContexts(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Map extraContext) {
        if (this.chainedContextNames == null) {
            return null;
        }
        ArrayList<VelocityContext> contextList = new ArrayList<VelocityContext>();
        for (int i = 0; i < this.chainedContextNames.length; ++i) {
            String className = this.chainedContextNames[i];
            try {
                VelocityContext velocityContext = (VelocityContext)this.objectFactory.buildBean(className, null);
                contextList.add(velocityContext);
                continue;
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn("Warning.  " + e.getClass().getName() + " caught while attempting to instantiate a chained VelocityContext, " + className + " -- skipping", new String[0]);
            }
        }
        if (contextList.size() > 0) {
            VelocityContext[] extraContexts = new VelocityContext[contextList.size()];
            contextList.toArray(extraContexts);
            return extraContexts;
        }
        return null;
    }

    public synchronized void init(ServletContext context) {
        if (this.velocityEngine == null) {
            this.velocityEngine = this.newVelocityEngine(context);
        }
        this.initToolbox(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties loadConfiguration(ServletContext context) {
        String userdirective;
        if (context == null) {
            String gripe = "Error attempting to create a loadConfiguration from a null ServletContext!";
            LOG.error(gripe, new String[0]);
            throw new IllegalArgumentException(gripe);
        }
        Properties properties = new Properties();
        this.applyDefaultConfiguration(context, properties);
        String defaultUserDirective = properties.getProperty("userdirective");
        String configfile = this.customConfigFile != null ? this.customConfigFile : "velocity.properties";
        configfile = configfile.trim();
        InputStream in = null;
        String resourceLocation = null;
        try {
            String filename;
            if (context.getRealPath(configfile) != null && (filename = context.getRealPath(configfile)) != null) {
                File file;
                File file2 = new File(filename);
                if (file2.isFile()) {
                    resourceLocation = file2.getCanonicalPath() + " from file system";
                    in = new FileInputStream(file2);
                }
                if (in == null && (file = new File(context.getRealPath("/WEB-INF/" + configfile))).isFile()) {
                    resourceLocation = file.getCanonicalPath() + " from file system";
                    in = new FileInputStream(file);
                }
            }
            if (in == null && (in = VelocityManager.class.getClassLoader().getResourceAsStream(configfile)) != null) {
                resourceLocation = configfile + " from classloader";
            }
            if (in != null) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Initializing velocity using " + resourceLocation, new String[0]);
                }
                properties.load(in);
            }
        }
        catch (IOException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Unable to load velocity configuration " + resourceLocation, (Throwable)e, new String[0]);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        if (this.velocityProperties != null) {
            for (String string : this.velocityProperties.keySet()) {
                properties.setProperty(string, this.velocityProperties.getProperty(string));
            }
        }
        userdirective = (userdirective = properties.getProperty("userdirective")) == null || userdirective.trim().equals("") ? defaultUserDirective : userdirective.trim() + "," + defaultUserDirective;
        properties.setProperty("userdirective", userdirective);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initializing Velocity with the following properties ...", new String[0]);
            for (String string : properties.keySet()) {
                String value = properties.getProperty(string);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("    '" + string + "' = '" + value + "'", new String[0]);
            }
        }
        return properties;
    }

    @Inject(value="struts.velocity.configfile")
    public void setCustomConfigFile(String val) {
        this.customConfigFile = val;
    }

    @Inject(value="struts.velocity.toolboxlocation")
    public void setToolBoxLocation(String toolboxLocation) {
        this.toolBoxLocation = toolboxLocation;
    }

    public ToolboxManager getToolboxManager() {
        return this.toolboxManager;
    }

    @Inject(value="struts.velocity.contexts")
    public void setChainedContexts(String contexts) {
        StringTokenizer st = new StringTokenizer(contexts, ",");
        ArrayList<String> contextList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String classname = st.nextToken();
            contextList.add(classname);
        }
        if (contextList.size() > 0) {
            String[] chainedContexts = new String[contextList.size()];
            contextList.toArray(chainedContexts);
            this.chainedContextNames = chainedContexts;
        }
    }

    protected void initToolbox(ServletContext context) {
        if (StringUtils.isNotBlank((String)this.toolBoxLocation)) {
            this.toolboxManager = ServletToolboxManager.getInstance((ServletContext)context, (String)this.toolBoxLocation);
        } else {
            Velocity.info((Object)"VelocityViewServlet: No toolbox entry in configuration.");
        }
    }

    protected VelocityEngine newVelocityEngine(ServletContext context) {
        if (context == null) {
            String gripe = "Error attempting to create a new VelocityEngine from a null ServletContext!";
            LOG.error(gripe, new String[0]);
            throw new IllegalArgumentException(gripe);
        }
        Properties p = this.loadConfiguration(context);
        VelocityEngine velocityEngine = new VelocityEngine();
        velocityEngine.setApplicationAttribute((Object)ServletContext.class.getName(), (Object)context);
        try {
            velocityEngine.init(p);
        }
        catch (Exception e) {
            String gripe = "Unable to instantiate VelocityEngine!";
            throw new StrutsException(gripe, e);
        }
        return velocityEngine;
    }

    private void applyDefaultConfiguration(ServletContext context, Properties p) {
        if (p.getProperty("resource.loader") == null) {
            p.setProperty("resource.loader", "strutsfile, strutsclass");
        }
        if (context.getRealPath("") != null) {
            p.setProperty("strutsfile.resource.loader.description", "Velocity File Resource Loader");
            p.setProperty("strutsfile.resource.loader.class", "org.apache.velocity.runtime.resource.loader.FileResourceLoader");
            p.setProperty("strutsfile.resource.loader.path", context.getRealPath(""));
            p.setProperty("strutsfile.resource.loader.modificationCheckInterval", "2");
            p.setProperty("strutsfile.resource.loader.cache", "true");
        } else {
            String prop = p.getProperty("resource.loader");
            if (prop.indexOf("strutsfile,") != -1) {
                prop = VelocityManager.replace(prop, "strutsfile,", "");
            } else if (prop.indexOf(", strutsfile") != -1) {
                prop = VelocityManager.replace(prop, ", strutsfile", "");
            } else if (prop.indexOf("strutsfile") != -1) {
                prop = VelocityManager.replace(prop, "strutsfile", "");
            }
            p.setProperty("resource.loader", prop);
        }
        p.setProperty("strutsclass.resource.loader.description", "Velocity Classpath Resource Loader");
        p.setProperty("strutsclass.resource.loader.class", "org.apache.struts2.views.velocity.StrutsResourceLoader");
        p.setProperty("strutsclass.resource.loader.modificationCheckInterval", "2");
        p.setProperty("strutsclass.resource.loader.cache", "true");
        StringBuilder sb = new StringBuilder();
        for (TagLibrary tagLibrary : this.tagLibraries) {
            List<Class> directives = tagLibrary.getVelocityDirectiveClasses();
            for (Class directive : directives) {
                this.addDirective(sb, directive);
            }
        }
        String directives = sb.toString();
        String userdirective = p.getProperty("userdirective");
        userdirective = userdirective == null || userdirective.trim().equals("") ? directives : userdirective.trim() + "," + directives;
        p.setProperty("userdirective", userdirective);
    }

    private void addDirective(StringBuilder sb, Class clazz) {
        sb.append(clazz.getName()).append(",");
    }

    private static final String replace(String string, String oldString, String newString) {
        if (string == null) {
            return null;
        }
        if (newString == null) {
            return string;
        }
        int i = 0;
        if ((i = string.indexOf(oldString, i)) >= 0) {
            char[] string2 = string.toCharArray();
            char[] newString2 = newString.toCharArray();
            int oLength = oldString.length();
            StringBuilder buf = new StringBuilder(string2.length);
            buf.append(string2, 0, i).append(newString2);
            int j = i += oLength;
            while ((i = string.indexOf(oldString, i)) > 0) {
                buf.append(string2, j, i - j).append(newString2);
                j = i += oLength;
            }
            buf.append(string2, j, string2.length - j);
            return buf.toString();
        }
        return string;
    }

    public Properties getVelocityProperties() {
        return this.velocityProperties;
    }

    public void setVelocityProperties(Properties velocityProperties) {
        this.velocityProperties = velocityProperties;
    }
}

