/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.config;

import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.ConfigurationProvider;
import com.opensymphony.xwork2.inject.ContainerBuilder;
import com.opensymphony.xwork2.inject.Context;
import com.opensymphony.xwork2.inject.Factory;
import com.opensymphony.xwork2.util.location.LocatableProperties;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.struts2.config.Settings;

public class LegacyPropertiesConfigurationProvider
implements ConfigurationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(LegacyPropertiesConfigurationProvider.class);

    public void destroy() {
        Settings.reset();
    }

    public void init(Configuration configuration) throws ConfigurationException {
        Settings.reset();
    }

    public void loadPackages() throws ConfigurationException {
    }

    public boolean needsReload() {
        return false;
    }

    public void register(ContainerBuilder builder, LocatableProperties props) throws ConfigurationException {
        Settings settings = Settings.getInstance();
        this.loadSettings(props, settings);
        builder.factory(Locale.class, new Factory(){
            private Locale locale;

            public synchronized Object create(Context context) throws Exception {
                if (this.locale == null) {
                    String loc = (String)context.getContainer().getInstance(String.class, "struts.locale");
                    if (loc != null) {
                        StringTokenizer localeTokens = new StringTokenizer(loc, "_");
                        String lang = null;
                        String country = null;
                        if (localeTokens.hasMoreTokens()) {
                            lang = localeTokens.nextToken();
                        }
                        if (localeTokens.hasMoreTokens()) {
                            country = localeTokens.nextToken();
                        }
                        this.locale = new Locale(lang, country);
                    } else {
                        if (LOG.isInfoEnabled()) {
                            LOG.info("No locale define, substituting the default VM locale", new String[0]);
                        }
                        this.locale = Locale.getDefault();
                    }
                }
                return this.locale;
            }
        });
    }

    protected void loadSettings(LocatableProperties props, Settings settings) {
        Iterator i = settings.listImpl();
        while (i.hasNext()) {
            String name = (String)i.next();
            props.setProperty(name, settings.getImpl(name), (Object)settings.getLocationImpl(name));
        }
    }
}

