/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.components;

import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang.xwork.StringEscapeUtils;
import org.apache.struts2.components.Component;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;

@StrutsTag(name="property", tldBodyContent="empty", tldTagClass="org.apache.struts2.views.jsp.PropertyTag", description="Print out expression which evaluates against the stack")
public class Property
extends Component {
    private static final Logger LOG = LoggerFactory.getLogger(Property.class);
    private String defaultValue;
    private String value;
    private boolean escape = true;
    private boolean escapeJavaScript = false;

    public Property(ValueStack stack) {
        super(stack);
    }

    @StrutsTagAttribute(description="The default value to be used if <u>value</u> attribute is null")
    public void setDefault(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @StrutsTagAttribute(description=" Whether to escape HTML", type="Boolean", defaultValue="true")
    public void setEscape(boolean escape) {
        this.escape = escape;
    }

    @StrutsTagAttribute(description="Whether to escape Javascript", type="Boolean", defaultValue="false")
    public void setEscapeJavaScript(boolean escapeJavaScript) {
        this.escapeJavaScript = escapeJavaScript;
    }

    @StrutsTagAttribute(description="Value to be displayed", type="Object", defaultValue="&lt;top of stack&gt;")
    public void setValue(String value) {
        this.value = value;
    }

    public boolean start(Writer writer) {
        boolean result = super.start(writer);
        String actualValue = null;
        this.value = this.value == null ? "top" : this.stripExpressionIfAltSyntax(this.value);
        actualValue = (String)this.getStack().findValue(this.value, String.class, this.throwExceptionOnELFailure);
        try {
            if (actualValue != null) {
                writer.write(this.prepare(actualValue));
            } else if (this.defaultValue != null) {
                writer.write(this.prepare(this.defaultValue));
            }
        }
        catch (IOException e) {
            LOG.info("Could not print out value '" + this.value + "'", (Throwable)e, new String[0]);
        }
        return result;
    }

    private String prepare(String value) {
        String result = value;
        if (this.escape) {
            result = StringEscapeUtils.escapeHtml((String)result);
        }
        if (this.escapeJavaScript) {
            result = StringEscapeUtils.escapeJavaScript((String)result);
        }
        return result;
    }
}

