/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.bolt.selector;

import org.apache.storm.kafka.bolt.selector.KafkaTopicSelector;
import org.apache.storm.tuple.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldNameTopicSelector
implements KafkaTopicSelector {
    private static final Logger LOG = LoggerFactory.getLogger(FieldNameTopicSelector.class);
    private final String fieldName;
    private final String defaultTopicName;

    public FieldNameTopicSelector(String fieldName, String defaultTopicName) {
        this.fieldName = fieldName;
        this.defaultTopicName = defaultTopicName;
    }

    @Override
    public String getTopic(Tuple tuple) {
        if (tuple.contains(this.fieldName)) {
            return tuple.getStringByField(this.fieldName);
        }
        LOG.warn("Field " + this.fieldName + " Not Found . Using default topic " + this.defaultTopicName);
        return this.defaultTopicName;
    }
}

