/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.bolt.selector;

import org.apache.storm.kafka.bolt.selector.KafkaTopicSelector;
import org.apache.storm.tuple.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldIndexTopicSelector
implements KafkaTopicSelector {
    private static final Logger LOG = LoggerFactory.getLogger(FieldIndexTopicSelector.class);
    private final int fieldIndex;
    private final String defaultTopicName;

    public FieldIndexTopicSelector(int fieldIndex, String defaultTopicName) {
        this.fieldIndex = fieldIndex;
        this.defaultTopicName = defaultTopicName;
    }

    @Override
    public String getTopic(Tuple tuple) {
        if (this.fieldIndex < tuple.size()) {
            return tuple.getString(this.fieldIndex);
        }
        LOG.warn("Field Index " + this.fieldIndex + " Out of bound . Using default topic " + this.defaultTopicName);
        return this.defaultTopicName;
    }
}

