/*
 * Decompiled with CFR 0.152.
 */
package storm.kafka.bolt;

import backtype.storm.task.OutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.topology.base.BaseRichBolt;
import backtype.storm.tuple.Tuple;
import java.util.Map;
import java.util.Properties;
import kafka.javaapi.producer.Producer;
import kafka.producer.KeyedMessage;
import kafka.producer.ProducerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import storm.kafka.bolt.mapper.FieldNameBasedTupleToKafkaMapper;
import storm.kafka.bolt.mapper.TupleToKafkaMapper;
import storm.kafka.bolt.selector.DefaultTopicSelector;
import storm.kafka.bolt.selector.KafkaTopicSelector;

public class KafkaBolt<K, V>
extends BaseRichBolt {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaBolt.class);
    public static final String TOPIC = "topic";
    public static final String KAFKA_BROKER_PROPERTIES = "kafka.broker.properties";
    private Producer<K, V> producer;
    private OutputCollector collector;
    private TupleToKafkaMapper<K, V> mapper;
    private KafkaTopicSelector topicSelector;

    public KafkaBolt<K, V> withTupleToKafkaMapper(TupleToKafkaMapper<K, V> mapper) {
        this.mapper = mapper;
        return this;
    }

    public KafkaBolt<K, V> withTopicSelector(KafkaTopicSelector selector) {
        this.topicSelector = selector;
        return this;
    }

    public void prepare(Map stormConf, TopologyContext context, OutputCollector collector) {
        if (this.mapper == null) {
            this.mapper = new FieldNameBasedTupleToKafkaMapper();
        }
        if (this.topicSelector == null) {
            this.topicSelector = new DefaultTopicSelector((String)stormConf.get(TOPIC));
        }
        Map configMap = (Map)stormConf.get(KAFKA_BROKER_PROPERTIES);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)configMap);
        ProducerConfig config = new ProducerConfig(properties);
        this.producer = new Producer(config);
        this.collector = collector;
    }

    public void execute(Tuple input) {
        Object key = null;
        Object message = null;
        String topic = null;
        try {
            key = this.mapper.getKeyFromTuple(input);
            message = this.mapper.getMessageFromTuple(input);
            topic = this.topicSelector.getTopic(input);
            if (topic != null) {
                this.producer.send(new KeyedMessage(topic, key, message));
            } else {
                LOG.warn("skipping key = " + key + ", topic selector returned null.");
            }
            this.collector.ack(input);
        }
        catch (Exception ex) {
            this.collector.reportError((Throwable)ex);
            this.collector.fail(input);
        }
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
    }
}

