/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.x11;

import java.io.IOException;
import java.io.OutputStream;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.client.channel.AbstractClientChannel;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.FactoryManagerUtils;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoServiceFactory;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.CloseableUtils;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;

public class X11ForwardSupport
extends CloseableUtils.AbstractInnerCloseable
implements IoHandler {
    public static final String CHANNEL_OPEN_TIMEOUT_PROP = "x11-fwd-open-timeout";
    public static final long DEFAULT_CHANNEL_OPEN_TIMEOUT = TimeUnit.SECONDS.toMillis(30L);
    public static final int X11_DISPLAY_OFFSET = 10;
    public static final int MAX_DISPLAYS = 1000;
    public static final String ENV_DISPLAY = "DISPLAY";
    private static final String XAUTH_COMMAND = System.getProperty("sshd.XAUTH_COMMAND", "xauth");
    private final ConnectionService service;
    private IoAcceptor acceptor;

    public X11ForwardSupport(ConnectionService service) {
        this.service = service;
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().close(this.acceptor).build();
    }

    public synchronized String createDisplay(boolean singleConnection, String authenticationProtocol, String authenticationCookie, int screen) throws IOException {
        int displayNumber;
        if (this.isClosed()) {
            throw new IllegalStateException("X11ForwardSupport is closed");
        }
        if (this.isClosing()) {
            throw new IllegalStateException("X11ForwardSupport is closing");
        }
        if (this.acceptor == null) {
            Session session = ValidateUtils.checkNotNull(this.service.getSession(), "No session");
            FactoryManager manager = ValidateUtils.checkNotNull(session.getFactoryManager(), "No factory manager");
            IoServiceFactory factory = ValidateUtils.checkNotNull(manager.getIoServiceFactory(), "No I/O service factory");
            this.acceptor = factory.createAcceptor(this);
        }
        for (displayNumber = 10; displayNumber < 1000; ++displayNumber) {
            int port = 6000 + displayNumber;
            try {
                InetSocketAddress addr = new InetSocketAddress("127.0.0.1", port);
                this.acceptor.bind(addr);
                break;
            }
            catch (BindException bindException) {
                continue;
            }
        }
        if (displayNumber >= 1000) {
            this.log.error("Failed to allocate internet-domain X11 display socket.");
            if (this.acceptor.getBoundAddresses().isEmpty()) {
                this.close();
            }
            return null;
        }
        String os = System.getProperty("os.name").toLowerCase();
        if (!os.contains("windows")) {
            try {
                String authDisplay = "unix:" + displayNumber + "." + screen;
                Process p = new ProcessBuilder(XAUTH_COMMAND, "remove", authDisplay).start();
                int result = p.waitFor();
                if (result == 0) {
                    p = new ProcessBuilder(XAUTH_COMMAND, "add", authDisplay, authenticationProtocol, authenticationCookie).start();
                    result = p.waitFor();
                }
            }
            catch (Exception e) {
                this.log.error("Could not run xauth", (Throwable)e);
                return null;
            }
            return "localhost:" + displayNumber + "." + screen;
        }
        return null;
    }

    @Override
    public void sessionCreated(IoSession session) throws Exception {
        ChannelForwardedX11 channel = new ChannelForwardedX11(session);
        session.setAttribute(ChannelForwardedX11.class, channel);
        this.service.registerChannel(channel);
        channel.open().verify(FactoryManagerUtils.getLongProperty(this.service.getSession(), CHANNEL_OPEN_TIMEOUT_PROP, DEFAULT_CHANNEL_OPEN_TIMEOUT));
    }

    @Override
    public void sessionClosed(IoSession session) throws Exception {
        ChannelForwardedX11 channel = (ChannelForwardedX11)session.getAttribute(ChannelForwardedX11.class);
        if (channel != null) {
            channel.close(false);
        }
    }

    @Override
    public void messageReceived(IoSession session, Readable message) throws Exception {
        ChannelForwardedX11 channel = (ChannelForwardedX11)session.getAttribute(ChannelForwardedX11.class);
        ByteArrayBuffer buffer = new ByteArrayBuffer();
        buffer.putBuffer(message);
        OutputStream outputStream = channel.getInvertedIn();
        outputStream.write(((Buffer)buffer).array(), ((Buffer)buffer).rpos(), buffer.available());
        outputStream.flush();
    }

    @Override
    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        cause.printStackTrace();
        session.close(false);
    }

    public static class ChannelForwardedX11
    extends AbstractClientChannel {
        private final IoSession serverSession;

        public ChannelForwardedX11(IoSession serverSession) {
            super("x11");
            this.serverSession = serverSession;
        }

        @Override
        public synchronized OpenFuture open() throws IOException {
            InetSocketAddress remote = (InetSocketAddress)this.serverSession.getRemoteAddress();
            if (this.closeFuture.isClosed()) {
                throw new SshException("Session has been closed");
            }
            this.openFuture = new DefaultOpenFuture(this.lock);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Send SSH_MSG_CHANNEL_OPEN on channel {}", (Object)this.id);
            }
            Buffer buffer = this.session.createBuffer((byte)90);
            buffer.putString(this.type);
            buffer.putInt(this.id);
            buffer.putInt(this.localWindow.getSize());
            buffer.putInt(this.localWindow.getPacketSize());
            buffer.putString(remote.getAddress().getHostAddress());
            buffer.putInt(remote.getPort());
            this.writePacket(buffer);
            return this.openFuture;
        }

        @Override
        protected synchronized void doOpen() throws IOException {
            if (this.streaming == ClientChannel.Streaming.Async) {
                throw new IllegalArgumentException("Asynchronous streaming isn't supported yet on this channel");
            }
            this.invertedIn = this.out = new ChannelOutputStream(this, this.remoteWindow, this.log, 94);
        }

        @Override
        protected Closeable getInnerCloseable() {
            return this.builder().sequential(this.serverSession, super.getInnerCloseable()).build();
        }

        @Override
        protected synchronized void doWriteData(byte[] data, int off, int len) throws IOException {
            this.localWindow.consumeAndCheck(len);
            this.serverSession.write(new ByteArrayBuffer(data, off, len));
        }

        @Override
        public void handleEof() throws IOException {
            super.handleEof();
            this.serverSession.close(false);
        }
    }
}

