/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.subsystem.sftp;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.FactoryManagerUtils;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.config.VersionProperties;
import org.apache.sshd.common.digest.BuiltinDigests;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.file.FileSystemAware;
import org.apache.sshd.common.random.Random;
import org.apache.sshd.common.subsystem.sftp.extensions.SpaceAvailableExtensionInfo;
import org.apache.sshd.common.subsystem.sftp.extensions.openssh.AbstractOpenSSHExtensionParser;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.Int2IntFunction;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.Pair;
import org.apache.sshd.common.util.SelectorUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.io.FileInfoExtractor;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.SessionAware;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.subsystem.sftp.DirectoryHandle;
import org.apache.sshd.server.subsystem.sftp.FileHandle;
import org.apache.sshd.server.subsystem.sftp.Handle;
import org.apache.sshd.server.subsystem.sftp.InvalidHandleException;
import org.apache.sshd.server.subsystem.sftp.SftpHelper;
import org.apache.sshd.server.subsystem.sftp.UnixDateFormat;
import org.apache.sshd.server.subsystem.sftp.UnsupportedAttributePolicy;

public class SftpSubsystem
extends AbstractLoggingBean
implements Command,
Runnable,
SessionAware,
FileSystemAware {
    public static final String MAX_OPEN_HANDLES_PER_SESSION = "max-open-handles-per-session";
    public static final int DEFAULT_MAX_OPEN_HANDLES = Integer.MAX_VALUE;
    public static final String FILE_HANDLE_SIZE = "sftp-handle-size";
    public static final int MIN_FILE_HANDLE_SIZE = 4;
    public static final int DEFAULT_FILE_HANDLE_SIZE = 16;
    public static final int MAX_FILE_HANDLE_SIZE = 64;
    public static final String MAX_FILE_HANDLE_RAND_ROUNDS = "sftp-handle-rand-max-rounds";
    public static final int MIN_FILE_HANDLE_ROUNDS = 1;
    public static final int DEFAULT_FILE_HANDLE_ROUNDS = 4;
    public static final int MAX_FILE_HANDLE_ROUNDS = 64;
    public static final String SFTP_VERSION = "sftp-version";
    public static final int LOWER_SFTP_IMPL = 3;
    public static final int HIGHER_SFTP_IMPL = 6;
    public static final String ALL_SFTP_IMPL;
    public static final String MAX_PACKET_LENGTH_PROP = "sftp-max-packet-length";
    public static final int DEFAULT_MAX_PACKET_LENGTH = 16384;
    public static final String CLIENT_EXTENSIONS_PROP = "sftp-client-extensions";
    public static final Set<String> DEFAULT_SUPPORTED_CLIENT_EXTENSIONS;
    public static final String OPENSSH_EXTENSIONS_PROP = "sftp-openssh-extensions";
    public static final List<AbstractOpenSSHExtensionParser.OpenSSHExtension> DEFAULT_OPEN_SSH_EXTENSIONS;
    public static final List<String> DEFAULT_OPEN_SSH_EXTENSIONS_NAMES;
    public static final List<String> DEFAULT_UNIX_VIEW;
    public static final Map<String, FileInfoExtractor<?>> FILEATTRS_RESOLVERS;
    protected ExitCallback callback;
    protected InputStream in;
    protected OutputStream out;
    protected OutputStream err;
    protected Environment env;
    protected Random randomizer;
    protected int fileHandleSize = 16;
    protected int maxFileHandleRounds = 4;
    protected ServerSession session;
    protected boolean closed;
    protected ExecutorService executors;
    protected boolean shutdownExecutor;
    protected Future<?> pendingFuture;
    protected byte[] workBuf = new byte[Math.max(16, 4)];
    protected FileSystem fileSystem = FileSystems.getDefault();
    protected Path defaultDir = this.fileSystem.getPath(System.getProperty("user.dir"), new String[0]);
    protected long requestsCount;
    protected int version;
    protected final Map<String, byte[]> extensions = new HashMap<String, byte[]>();
    protected final Map<String, Handle> handles = new HashMap<String, Handle>();
    protected final UnsupportedAttributePolicy unsupportedAttributePolicy;

    public SftpSubsystem(ExecutorService executorService, boolean shutdownOnExit, UnsupportedAttributePolicy policy) {
        if (executorService == null) {
            this.executors = ThreadUtils.newSingleThreadExecutor(this.getClass().getSimpleName());
            this.shutdownExecutor = true;
        } else {
            this.executors = executorService;
            this.shutdownExecutor = shutdownOnExit;
        }
        if (policy == null) {
            throw new IllegalArgumentException("No policy provided");
        }
        this.unsupportedAttributePolicy = policy;
    }

    public int getVersion() {
        return this.version;
    }

    public final UnsupportedAttributePolicy getUnsupportedAttributePolicy() {
        return this.unsupportedAttributePolicy;
    }

    @Override
    public void setSession(ServerSession session) {
        this.session = session;
        ServerFactoryManager manager = session.getFactoryManager();
        Factory<Random> factory = manager.getRandomFactory();
        this.randomizer = factory.create();
        this.fileHandleSize = FactoryManagerUtils.getIntProperty(manager, FILE_HANDLE_SIZE, 16);
        ValidateUtils.checkTrue(this.fileHandleSize >= 4, "File handle size too small: %d", (Object)this.fileHandleSize);
        ValidateUtils.checkTrue(this.fileHandleSize <= 64, "File handle size too big: %d", (Object)this.fileHandleSize);
        this.maxFileHandleRounds = FactoryManagerUtils.getIntProperty(manager, MAX_FILE_HANDLE_RAND_ROUNDS, 4);
        ValidateUtils.checkTrue(this.maxFileHandleRounds >= 1, "File handle rounds too small: %d", (Object)this.maxFileHandleRounds);
        ValidateUtils.checkTrue(this.maxFileHandleRounds <= 64, "File handle rounds too big: %d", (Object)this.maxFileHandleRounds);
        if (this.workBuf.length < this.fileHandleSize) {
            this.workBuf = new byte[this.fileHandleSize];
        }
    }

    @Override
    public void setFileSystem(FileSystem fileSystem) {
        if (fileSystem != this.fileSystem) {
            this.fileSystem = fileSystem;
            Iterable<Path> roots = ValidateUtils.checkNotNull(fileSystem.getRootDirectories(), "No root directories");
            Iterator<Path> available = ValidateUtils.checkNotNull(roots.iterator(), "No roots iterator");
            ValidateUtils.checkTrue(available.hasNext(), "No available root");
            this.defaultDir = available.next();
        }
    }

    @Override
    public void setExitCallback(ExitCallback callback) {
        this.callback = callback;
    }

    @Override
    public void setInputStream(InputStream in) {
        this.in = in;
    }

    @Override
    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    @Override
    public void setErrorStream(OutputStream err) {
        this.err = err;
    }

    @Override
    public void start(Environment env) throws IOException {
        this.env = env;
        try {
            this.pendingFuture = this.executors.submit(this);
        }
        catch (RuntimeException e) {
            this.log.error("Failed (" + e.getClass().getSimpleName() + ") to start command: " + e.toString(), (Throwable)e);
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            try {
                long count = 1L;
                while (true) {
                    int l;
                    int length;
                    ValidateUtils.checkTrue((length = BufferUtils.readInt(this.in, this.workBuf, 0, this.workBuf.length)) >= 5, "Bad length to read: %d", (Object)length);
                    ByteArrayBuffer buffer = new ByteArrayBuffer(length + 4);
                    buffer.putInt(length);
                    for (int remainLen = length; remainLen > 0; remainLen -= l) {
                        l = this.in.read(((Buffer)buffer).array(), ((Buffer)buffer).wpos(), remainLen);
                        if (l < 0) {
                            throw new IllegalArgumentException("Premature EOF at buffer #" + count + " while read length=" + length + " and remain=" + remainLen);
                        }
                        ((Buffer)buffer).wpos(((Buffer)buffer).wpos() + l);
                    }
                    this.process(buffer);
                    ++count;
                }
            }
            catch (Throwable t) {
                if (!this.closed && !(t instanceof EOFException)) {
                    this.log.error("Exception caught in SFTP subsystem", t);
                }
                for (Map.Entry<String, Handle> entry : this.handles.entrySet()) {
                    String id = entry.getKey();
                    Handle handle = entry.getValue();
                    try {
                        handle.close();
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("Closed pending handle {} [{}]", (Object)id, (Object)handle);
                    }
                    catch (IOException ioe) {
                        this.log.error("Failed ({}) to close handle={}[{}]: {}", new Object[]{ioe.getClass().getSimpleName(), id, handle, ioe.getMessage()});
                    }
                }
                this.callback.onExit(0);
            }
        }
        catch (Throwable throwable) {
            for (Map.Entry<String, Handle> entry : this.handles.entrySet()) {
                String id = entry.getKey();
                Handle handle = entry.getValue();
                try {
                    handle.close();
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Closed pending handle {} [{}]", (Object)id, (Object)handle);
                }
                catch (IOException ioe) {
                    this.log.error("Failed ({}) to close handle={}[{}]: {}", new Object[]{ioe.getClass().getSimpleName(), id, handle, ioe.getMessage()});
                }
            }
            this.callback.onExit(0);
            throw throwable;
        }
    }

    protected void process(Buffer buffer) throws IOException {
        int length = buffer.getInt();
        int type = buffer.getUByte();
        int id = buffer.getInt();
        if (this.log.isDebugEnabled()) {
            this.log.debug("process(length={}, type={}, id={})", new Object[]{length, type, id});
        }
        switch (type) {
            case 1: {
                this.doInit(buffer, id);
                break;
            }
            case 3: {
                this.doOpen(buffer, id);
                break;
            }
            case 4: {
                this.doClose(buffer, id);
                break;
            }
            case 5: {
                this.doRead(buffer, id);
                break;
            }
            case 6: {
                this.doWrite(buffer, id);
                break;
            }
            case 7: {
                this.doLStat(buffer, id);
                break;
            }
            case 8: {
                this.doFStat(buffer, id);
                break;
            }
            case 9: {
                this.doSetStat(buffer, id);
                break;
            }
            case 10: {
                this.doFSetStat(buffer, id);
                break;
            }
            case 11: {
                this.doOpenDir(buffer, id);
                break;
            }
            case 12: {
                this.doReadDir(buffer, id);
                break;
            }
            case 13: {
                this.doRemove(buffer, id);
                break;
            }
            case 14: {
                this.doMakeDirectory(buffer, id);
                break;
            }
            case 15: {
                this.doRemoveDirectory(buffer, id);
                break;
            }
            case 16: {
                this.doRealPath(buffer, id);
                break;
            }
            case 17: {
                this.doStat(buffer, id);
                break;
            }
            case 18: {
                this.doRename(buffer, id);
                break;
            }
            case 19: {
                this.doReadLink(buffer, id);
                break;
            }
            case 20: {
                this.doSymLink(buffer, id);
                break;
            }
            case 21: {
                this.doLink(buffer, id);
                break;
            }
            case 22: {
                this.doBlock(buffer, id);
                break;
            }
            case 23: {
                this.doUnblock(buffer, id);
                break;
            }
            case 200: {
                this.doExtended(buffer, id);
                break;
            }
            default: {
                this.log.warn("Unknown command type received: {}", (Object)type);
                this.sendStatus(BufferUtils.clear(buffer), id, 8, "Command " + type + " is unsupported or not implemented");
            }
        }
        if (type != 1) {
            ++this.requestsCount;
        }
    }

    protected void doExtended(Buffer buffer, int id) throws IOException {
        this.executeExtendedCommand(buffer, id, buffer.getString());
    }

    protected void executeExtendedCommand(Buffer buffer, int id, String extension) throws IOException {
        switch (extension) {
            case "text-seek": {
                this.doTextSeek(buffer, id);
                break;
            }
            case "version-select": {
                this.doVersionSelect(buffer, id);
                break;
            }
            case "copy-file": {
                this.doCopyFile(buffer, id);
                break;
            }
            case "copy-data": {
                this.doCopyData(buffer, id);
                break;
            }
            case "md5-hash": 
            case "md5-hash-handle": {
                this.doMD5Hash(buffer, id, extension);
                break;
            }
            case "check-file-handle": 
            case "check-file-name": {
                this.doCheckFileHash(buffer, id, extension);
                break;
            }
            case "fsync@openssh.com": {
                this.doOpenSSHFsync(buffer, id);
                break;
            }
            case "space-available": {
                this.doSpaceAvailable(buffer, id);
                break;
            }
            default: {
                this.log.info("Received unsupported SSH_FXP_EXTENDED({})", (Object)extension);
                this.sendStatus(BufferUtils.clear(buffer), id, 8, "Command SSH_FXP_EXTENDED(" + extension + ") is unsupported or not implemented");
            }
        }
    }

    protected void doSpaceAvailable(Buffer buffer, int id) throws IOException {
        SpaceAvailableExtensionInfo info;
        String path = buffer.getString();
        try {
            info = this.doSpaceAvailable(id, path);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e);
            return;
        }
        buffer.clear();
        buffer.putByte((byte)-55);
        buffer.putInt(id);
        SpaceAvailableExtensionInfo.encode(buffer, info);
        this.send(buffer);
    }

    protected SpaceAvailableExtensionInfo doSpaceAvailable(int id, String path) throws IOException {
        Path nrm = this.resolveNormalizedLocation(path);
        if (this.log.isDebugEnabled()) {
            this.log.debug("doSpaceAvailable(id={}) path={}[{}]", new Object[]{id, path, nrm});
        }
        FileStore store = Files.getFileStore(nrm);
        if (this.log.isTraceEnabled()) {
            this.log.trace("doSpaceAvailable(id={}) path={}[{}] - {}[{}]", new Object[]{id, path, nrm, store.name(), store.type()});
        }
        return new SpaceAvailableExtensionInfo(store);
    }

    protected void doTextSeek(Buffer buffer, int id) throws IOException {
        String handle = buffer.getString();
        long line = buffer.getLong();
        try {
            this.doTextSeek(id, handle, line);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e);
            return;
        }
        this.sendStatus(BufferUtils.clear(buffer), id, 0, "");
    }

    protected void doTextSeek(int id, String handle, long line) throws IOException {
        Handle h = this.handles.get(handle);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received SSH_FXP_EXTENDED(text-seek) (handle={}[{}], line={})", new Object[]{handle, h, line});
        }
        FileHandle fileHandle = this.validateHandle(handle, h, FileHandle.class);
        throw new UnsupportedOperationException("doTextSeek(" + fileHandle + ")");
    }

    protected void doOpenSSHFsync(Buffer buffer, int id) throws IOException {
        String handle = buffer.getString();
        try {
            this.doOpenSSHFsync(id, handle);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e);
            return;
        }
        this.sendStatus(BufferUtils.clear(buffer), id, 0, "");
    }

    protected void doOpenSSHFsync(int id, String handle) throws IOException {
        Handle h = this.handles.get(handle);
        if (this.log.isDebugEnabled()) {
            this.log.debug("doOpenSSHFsync({})[{}]", (Object)handle, (Object)h);
        }
        FileHandle fileHandle = this.validateHandle(handle, h, FileHandle.class);
        FileChannel channel = fileHandle.getFileChannel();
        channel.force(false);
    }

    protected void doCheckFileHash(Buffer buffer, int id, String targetType) throws IOException {
        String target = buffer.getString();
        String algList = buffer.getString();
        String[] algos = GenericUtils.split(algList, ',');
        long startOffset = buffer.getLong();
        long length = buffer.getLong();
        int blockSize = buffer.getInt();
        try {
            buffer.clear();
            buffer.putByte((byte)-55);
            buffer.putInt(id);
            buffer.putString("check-file");
            this.doCheckFileHash(id, targetType, target, Arrays.asList(algos), startOffset, length, blockSize, buffer);
        }
        catch (Exception e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e);
            return;
        }
        this.send(buffer);
    }

    protected void doCheckFileHash(int id, String targetType, String target, Collection<String> algos, long startOffset, long length, int blockSize, Buffer buffer) throws Exception {
        String a;
        Path path;
        if ("check-file-handle".equalsIgnoreCase(targetType)) {
            Handle h = this.handles.get(target);
            FileHandle fileHandle = this.validateHandle(target, h, FileHandle.class);
            path = fileHandle.getFile();
            int access = fileHandle.getAccessMask();
            if ((access & 1) == 0) {
                throw new AccessDeniedException("File not opened for read: " + path);
            }
        } else {
            path = this.resolveFile(target);
            for (int index = 0; Files.isSymbolicLink(path) && index < 127; ++index) {
                path = Files.readSymbolicLink(path);
            }
            if (Files.isSymbolicLink(path)) {
                throw new FileSystemLoopException(target + " yields a circular or too long chain of symlinks");
            }
            if (Files.isDirectory(path, IoUtils.getLinkOptions(false))) {
                throw new NotDirectoryException(path.toString());
            }
        }
        ValidateUtils.checkNotNullAndNotEmpty(algos, "No hash algorithms specified", new Object[0]);
        BuiltinDigests factory = null;
        Iterator<String> iterator = algos.iterator();
        while (iterator.hasNext() && (factory = BuiltinDigests.fromFactoryName(a = iterator.next())) == null) {
        }
        ValidateUtils.checkNotNull(factory, "No matching digest factory found for %s", algos);
        this.doCheckFileHash(id, path, factory, startOffset, length, blockSize, buffer);
    }

    protected void doCheckFileHash(int id, Path file, NamedFactory<? extends Digest> factory, long startOffset, long length, int blockSize, Buffer buffer) throws Exception {
        block23: {
            ValidateUtils.checkTrue(startOffset >= 0L, "Invalid start offset: %d", (Object)startOffset);
            ValidateUtils.checkTrue(length >= 0L, "Invalid length: %d", (Object)length);
            ValidateUtils.checkTrue(blockSize == 0 || blockSize >= 256, "Invalid block size: %d", (Object)blockSize);
            ValidateUtils.checkNotNull(factory, "No digest factory provided");
            buffer.putString(factory.getName());
            long effectiveLength = length;
            long totalLength = Files.size(file);
            if (effectiveLength == 0L) {
                effectiveLength = totalLength - startOffset;
            } else {
                long maxRead = startOffset + length;
                if (maxRead > totalLength) {
                    effectiveLength = totalLength - startOffset;
                }
            }
            ValidateUtils.checkTrue(effectiveLength > 0L, "Non-positive effective hash data length: %d", (Object)effectiveLength);
            byte[] digestBuf = blockSize == 0 ? new byte[Math.min((int)effectiveLength, 8192)] : new byte[Math.min((int)effectiveLength, blockSize)];
            ByteBuffer wb = ByteBuffer.wrap(digestBuf);
            try (FileChannel channel = FileChannel.open(file, IoUtils.EMPTY_OPEN_OPTIONS);){
                channel.position(startOffset);
                Digest digest = (Digest)factory.create();
                digest.init();
                if (blockSize == 0) {
                    while (effectiveLength > 0L) {
                        int remainLen = Math.min(digestBuf.length, (int)effectiveLength);
                        ByteBuffer bb = wb;
                        if (remainLen < digestBuf.length) {
                            bb = ByteBuffer.wrap(digestBuf, 0, remainLen);
                        }
                        bb.clear();
                        int readLen = channel.read(bb);
                        if (readLen < 0) break;
                        effectiveLength -= (long)readLen;
                        digest.update(digestBuf, 0, readLen);
                    }
                    byte[] hashValue = digest.digest();
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("doCheckFileHash({}) offset={}, length={} - hash={}", new Object[]{file, startOffset, length, BufferUtils.printHex(':', hashValue)});
                    }
                    buffer.putBytes(hashValue);
                    break block23;
                }
                int count = 0;
                while (effectiveLength > 0L) {
                    int remainLen = Math.min(digestBuf.length, (int)effectiveLength);
                    ByteBuffer bb = wb;
                    if (remainLen < digestBuf.length) {
                        bb = ByteBuffer.wrap(digestBuf, 0, remainLen);
                    }
                    bb.clear();
                    int readLen = channel.read(bb);
                    if (readLen < 0) {
                        break;
                    }
                    effectiveLength -= (long)readLen;
                    digest.update(digestBuf, 0, readLen);
                    byte[] hashValue = digest.digest();
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("doCheckFileHash({})[{}] offset={}, length={} - hash={}", new Object[]{file, count, startOffset, length, BufferUtils.printHex(':', hashValue)});
                    }
                    buffer.putBytes(hashValue);
                    ++count;
                }
            }
        }
    }

    protected void doMD5Hash(Buffer buffer, int id, String targetType) throws IOException {
        byte[] hashValue;
        String target = buffer.getString();
        long startOffset = buffer.getLong();
        long length = buffer.getLong();
        byte[] quickCheckHash = buffer.getBytes();
        try {
            hashValue = this.doMD5Hash(id, targetType, target, startOffset, length, quickCheckHash);
            if (this.log.isTraceEnabled()) {
                this.log.debug("doMD5Hash({})[{}] offset={}, length={}, quick-hash={} - hash={}", new Object[]{targetType, target, startOffset, length, BufferUtils.printHex(':', quickCheckHash), BufferUtils.printHex(':', hashValue)});
            }
        }
        catch (Exception e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e);
            return;
        }
        buffer.clear();
        buffer.putByte((byte)-55);
        buffer.putInt(id);
        buffer.putString(targetType);
        buffer.putBytes(hashValue);
        this.send(buffer);
    }

    protected byte[] doMD5Hash(int id, String targetType, String target, long startOffset, long length, byte[] quickCheckHash) throws Exception {
        Path path;
        if (this.log.isDebugEnabled()) {
            this.log.debug("doMD5Hash({})[{}] offset={}, length={}, quick-hash={}", new Object[]{targetType, target, startOffset, length, BufferUtils.printHex(':', quickCheckHash)});
        }
        if ("md5-hash-handle".equalsIgnoreCase(targetType)) {
            Handle h = this.handles.get(target);
            FileHandle fileHandle = this.validateHandle(target, h, FileHandle.class);
            path = fileHandle.getFile();
            int access = fileHandle.getAccessMask();
            if ((access & 1) == 0) {
                throw new AccessDeniedException("File not opened for read: " + path);
            }
        } else {
            path = this.resolveFile(target);
            if (Files.isDirectory(path, IoUtils.getLinkOptions(false))) {
                throw new NotDirectoryException(path.toString());
            }
        }
        long effectiveLength = length;
        long totalSize = Files.size(path);
        if (startOffset == 0L && length == 0L) {
            effectiveLength = totalSize;
        } else {
            long maxRead = startOffset + effectiveLength;
            if (maxRead > totalSize) {
                effectiveLength = totalSize - startOffset;
            }
        }
        return this.doMD5Hash(id, path, startOffset, effectiveLength, quickCheckHash);
    }

    protected byte[] doMD5Hash(int id, Path path, long startOffset, long length, byte[] quickCheckHash) throws Exception {
        ValidateUtils.checkTrue(startOffset >= 0L, "Invalid start offset: %d", (Object)startOffset);
        ValidateUtils.checkTrue(length > 0L, "Invalid length: %d", (Object)length);
        Digest digest = BuiltinDigests.md5.create();
        digest.init();
        long effectiveLength = length;
        byte[] digestBuf = new byte[(int)Math.min(effectiveLength, 2048L)];
        ByteBuffer wb = ByteBuffer.wrap(digestBuf);
        boolean hashMatches = false;
        byte[] hashValue = null;
        try (FileChannel channel = FileChannel.open(path, StandardOpenOption.READ);){
            channel.position(startOffset);
            if (GenericUtils.length(quickCheckHash) <= 0) {
                hashMatches = true;
            } else {
                int readLen = channel.read(wb);
                if (readLen < 0) {
                    throw new EOFException("EOF while read initial buffer from " + path);
                }
                effectiveLength -= (long)readLen;
                digest.update(digestBuf, 0, readLen);
                hashValue = digest.digest();
                hashMatches = Arrays.equals(quickCheckHash, hashValue);
                if (hashMatches) {
                    if (effectiveLength > 0L) {
                        digest = BuiltinDigests.md5.create();
                        digest.init();
                        digest.update(digestBuf, 0, readLen);
                        hashValue = null;
                    }
                } else if (this.log.isTraceEnabled()) {
                    this.log.trace("doMD5Hash({}) offset={}, length={} - quick-hash mismatched expected={}, actual={}", new Object[]{path, startOffset, length, BufferUtils.printHex(':', quickCheckHash), BufferUtils.printHex(':', hashValue)});
                }
            }
            if (hashMatches) {
                while (effectiveLength > 0L) {
                    int remainLen = Math.min(digestBuf.length, (int)effectiveLength);
                    ByteBuffer bb = wb;
                    if (remainLen < digestBuf.length) {
                        bb = ByteBuffer.wrap(digestBuf, 0, remainLen);
                    }
                    bb.clear();
                    int readLen = channel.read(bb);
                    if (readLen < 0) break;
                    effectiveLength -= (long)readLen;
                    digest.update(digestBuf, 0, readLen);
                }
                if (hashValue == null) {
                    hashValue = digest.digest();
                }
            } else {
                hashValue = GenericUtils.EMPTY_BYTE_ARRAY;
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("doMD5Hash({}) offset={}, length={} - matches={}, quick={} hash={}", new Object[]{path, startOffset, length, hashMatches, BufferUtils.printHex(':', quickCheckHash), BufferUtils.printHex(':', hashValue)});
        }
        return hashValue;
    }

    protected void doVersionSelect(Buffer buffer, int id) throws IOException {
        String proposed = buffer.getString();
        if (this.requestsCount > 0L) {
            this.sendStatus(BufferUtils.clear(buffer), id, 4, "Version selection not the 1st request for proposal = " + proposed);
            this.session.close(true);
            return;
        }
        Boolean result = this.validateProposedVersion(buffer, id, proposed);
        if (result == null) {
            this.session.close(true);
            return;
        }
        if (result.booleanValue()) {
            this.version = Integer.parseInt(proposed);
            this.sendStatus(BufferUtils.clear(buffer), id, 0, "");
        } else {
            this.sendStatus(BufferUtils.clear(buffer), id, 4, "Unsupported version " + proposed);
            this.session.close(true);
        }
    }

    protected Boolean validateProposedVersion(Buffer buffer, int id, String proposed) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received SSH_FXP_EXTENDED(version-select) (version={})", (Object)proposed);
        }
        if (GenericUtils.length(proposed) != 1) {
            return Boolean.FALSE;
        }
        char digit = proposed.charAt(0);
        if (digit < '0' || digit > '9') {
            return Boolean.FALSE;
        }
        int value = digit - 48;
        String all = this.checkVersionCompatibility(buffer, id, value, 4);
        if (GenericUtils.isEmpty(all)) {
            return null;
        }
        return Boolean.TRUE;
    }

    protected String checkVersionCompatibility(Buffer buffer, int id, int proposed, int failureOpcode) throws IOException {
        int low = 3;
        int hig = 6;
        String available = ALL_SFTP_IMPL;
        Integer sftpVersion = FactoryManagerUtils.getInteger(this.session, SFTP_VERSION);
        if (sftpVersion != null) {
            int forcedValue = sftpVersion;
            if (forcedValue < 3 || forcedValue > 6) {
                throw new IllegalStateException("Forced SFTP version (" + sftpVersion + ") not within supported values: " + available);
            }
            low = hig = sftpVersion.intValue();
            available = sftpVersion.toString();
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("checkVersionCompatibility(id={}) - proposed={}, available={}", new Object[]{id, proposed, available});
        }
        if (proposed < low || proposed > hig) {
            this.sendStatus(BufferUtils.clear(buffer), id, failureOpcode, "Proposed version (" + proposed + ") not in supported range: " + available);
            return null;
        }
        return available;
    }

    protected void doBlock(Buffer buffer, int id) throws IOException {
        String handle = buffer.getString();
        long offset = buffer.getLong();
        long length = buffer.getLong();
        int mask = buffer.getInt();
        try {
            this.doBlock(id, handle, offset, length, mask);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e);
            return;
        }
        this.sendStatus(BufferUtils.clear(buffer), id, 0, "");
    }

    protected void doBlock(int id, String handle, long offset, long length, int mask) throws IOException {
        Handle p = this.handles.get(handle);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received SSH_FXP_BLOCK (handle={}[{}], offset={}, length={}, mask=0x{})", new Object[]{handle, p, offset, length, Integer.toHexString(mask)});
        }
        FileHandle fileHandle = this.validateHandle(handle, p, FileHandle.class);
        fileHandle.lock(offset, length, mask);
    }

    protected void doUnblock(Buffer buffer, int id) throws IOException {
        boolean found;
        String handle = buffer.getString();
        long offset = buffer.getLong();
        long length = buffer.getLong();
        try {
            found = this.doUnblock(id, handle, offset, length);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e);
            return;
        }
        this.sendStatus(BufferUtils.clear(buffer), id, found ? 0 : 31, "");
    }

    protected boolean doUnblock(int id, String handle, long offset, long length) throws IOException {
        Handle p = this.handles.get(handle);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received SSH_FXP_UNBLOCK (handle={}[{}], offset={}, length={})", new Object[]{handle, p, offset, length});
        }
        FileHandle fileHandle = this.validateHandle(handle, p, FileHandle.class);
        return fileHandle.unlock(offset, length);
    }

    protected void doLink(Buffer buffer, int id) throws IOException {
        String targetPath = buffer.getString();
        String linkPath = buffer.getString();
        boolean symLink = buffer.getBoolean();
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Received SSH_FXP_LINK id={}, linkpath={}, targetpath={}, symlink={}", new Object[]{id, linkPath, targetPath, symLink});
            }
            this.doLink(id, targetPath, linkPath, symLink);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e);
            return;
        }
        this.sendStatus(BufferUtils.clear(buffer), id, 0, "");
    }

    protected void doLink(int id, String targetPath, String linkPath, boolean symLink) throws IOException {
        this.createLink(id, targetPath, linkPath, symLink);
    }

    protected void doSymLink(Buffer buffer, int id) throws IOException {
        String targetPath = buffer.getString();
        String linkPath = buffer.getString();
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Received SSH_FXP_SYMLINK id={}, linkpath={}, targetpath={}", new Object[]{id, targetPath, linkPath});
            }
            this.doSymLink(id, targetPath, linkPath);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e);
            return;
        }
        this.sendStatus(BufferUtils.clear(buffer), id, 0, "");
    }

    protected void doSymLink(int id, String targetPath, String linkPath) throws IOException {
        this.createLink(id, targetPath, linkPath, true);
    }

    protected void createLink(int id, String targetPath, String linkPath, boolean symLink) throws IOException {
        Path link = this.resolveFile(linkPath);
        Path target = this.fileSystem.getPath(targetPath, new String[0]);
        if (this.log.isDebugEnabled()) {
            this.log.debug("createLink(id={}), linkpath={}[{}], targetpath={}[{}], symlink={})", new Object[]{id, linkPath, link, targetPath, target, symLink});
        }
        if (symLink) {
            Files.createSymbolicLink(link, target, new FileAttribute[0]);
        } else {
            Files.createLink(link, target);
        }
    }

    protected void doReadLink(Buffer buffer, int id) throws IOException {
        String l;
        String path = buffer.getString();
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Received SSH_FXP_READLINK id={} path={}", (Object)id, (Object)path);
            }
            l = this.doReadLink(id, path);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e);
            return;
        }
        this.sendLink(BufferUtils.clear(buffer), id, l);
    }

    protected String doReadLink(int id, String path) throws IOException {
        Path f = this.resolveFile(path);
        Path t = Files.readSymbolicLink(f);
        if (this.log.isDebugEnabled()) {
            this.log.debug("doReadLink(id={}) path={}[{}]: {}", new Object[]{id, path, f, t});
        }
        return t.toString();
    }

    protected void doRename(Buffer buffer, int id) throws IOException {
        String oldPath = buffer.getString();
        String newPath = buffer.getString();
        int flags = 0;
        if (this.version >= 5) {
            flags = buffer.getInt();
        }
        try {
            this.doRename(id, oldPath, newPath, flags);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e);
            return;
        }
        this.sendStatus(BufferUtils.clear(buffer), id, 0, "");
    }

    protected void doRename(int id, String oldPath, String newPath, int flags) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received SSH_FXP_RENAME (oldPath={}, newPath={}, flags=0x{})", new Object[]{oldPath, newPath, Integer.toHexString(flags)});
        }
        List<CopyOption> opts = Collections.emptyList();
        if (flags != 0) {
            opts = new ArrayList();
            if ((flags & 2) == 2) {
                opts.add(StandardCopyOption.ATOMIC_MOVE);
            }
            if ((flags & 1) == 1) {
                opts.add(StandardCopyOption.REPLACE_EXISTING);
            }
        }
        this.doRename(id, oldPath, newPath, opts);
    }

    protected void doRename(int id, String oldPath, String newPath, Collection<CopyOption> opts) throws IOException {
        Path o = this.resolveFile(oldPath);
        Path n = this.resolveFile(newPath);
        Files.move(o, n, GenericUtils.isEmpty(opts) ? IoUtils.EMPTY_COPY_OPTIONS : opts.toArray(new CopyOption[opts.size()]));
    }

    protected void doCopyData(Buffer buffer, int id) throws IOException {
        String readHandle = buffer.getString();
        long readOffset = buffer.getLong();
        long readLength = buffer.getLong();
        String writeHandle = buffer.getString();
        long writeOffset = buffer.getLong();
        try {
            this.doCopyData(id, readHandle, readOffset, readLength, writeHandle, writeOffset);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e);
            return;
        }
        this.sendStatus(BufferUtils.clear(buffer), id, 0, "");
    }

    protected void doCopyData(int id, String readHandle, long readOffset, long readLength, String writeHandle, long writeOffset) throws IOException {
        Handle wh;
        boolean inPlaceCopy = readHandle.equals(writeHandle);
        Handle rh = this.handles.get(readHandle);
        Handle handle = wh = inPlaceCopy ? rh : this.handles.get(writeHandle);
        if (this.log.isDebugEnabled()) {
            this.log.debug("SSH_FXP_EXTENDED[{}] read={}[{}], read-offset={}, read-length={}, write={}[{}], write-offset={})", new Object[]{"copy-data", readHandle, rh, readOffset, readLength, writeHandle, wh, writeOffset});
        }
        FileHandle srcHandle = this.validateHandle(readHandle, rh, FileHandle.class);
        Path srcPath = srcHandle.getFile();
        int srcAccess = srcHandle.getAccessMask();
        if ((srcAccess & 1) != 1) {
            throw new AccessDeniedException("File not opened for read: " + srcPath);
        }
        ValidateUtils.checkTrue(readLength >= 0L, "Invalid read length: %d", (Object)readLength);
        ValidateUtils.checkTrue(readOffset >= 0L, "Invalid read offset: %d", (Object)readOffset);
        long totalSize = Files.size(srcHandle.getFile());
        long effectiveLength = readLength;
        if (effectiveLength == 0L) {
            effectiveLength = totalSize - readOffset;
        } else {
            long maxRead = readOffset + effectiveLength;
            if (maxRead > totalSize) {
                effectiveLength = totalSize - readOffset;
            }
        }
        ValidateUtils.checkTrue(effectiveLength > 0L, "Non-positive effective copy data length: %d", (Object)effectiveLength);
        FileHandle dstHandle = inPlaceCopy ? srcHandle : this.validateHandle(writeHandle, wh, FileHandle.class);
        int dstAccess = dstHandle.getAccessMask();
        if ((dstAccess & 2) != 2) {
            throw new AccessDeniedException("File not opened for write: " + srcHandle);
        }
        ValidateUtils.checkTrue(writeOffset >= 0L, "Invalid write offset: %d", (Object)writeOffset);
        if (inPlaceCopy) {
            long maxWrite;
            long maxRead = readOffset + effectiveLength;
            if (maxRead > totalSize) {
                maxRead = totalSize;
            }
            if ((maxWrite = writeOffset + effectiveLength) > readOffset) {
                throw new IllegalArgumentException("Write range end [" + writeOffset + "-" + maxWrite + "]" + " overlaps with read range [" + readOffset + "-" + maxRead + "]");
            }
            if (maxRead > writeOffset) {
                throw new IllegalArgumentException("Read range end [" + readOffset + "-" + maxRead + "]" + " overlaps with write range [" + writeOffset + "-" + maxWrite + "]");
            }
        }
        byte[] copyBuf = new byte[Math.min(8192, (int)effectiveLength)];
        while (effectiveLength > 0L) {
            int remainLength = Math.min(copyBuf.length, (int)effectiveLength);
            int readLen = srcHandle.read(copyBuf, 0, remainLength, readOffset);
            if (readLen < 0) {
                throw new EOFException("Premature EOF while still remaining " + effectiveLength + " bytes");
            }
            dstHandle.write(copyBuf, 0, readLen, writeOffset);
            effectiveLength -= (long)readLen;
            readOffset += (long)readLen;
            writeOffset += (long)readLen;
        }
    }

    protected void doCopyFile(Buffer buffer, int id) throws IOException {
        String srcFile = buffer.getString();
        String dstFile = buffer.getString();
        boolean overwriteDestination = buffer.getBoolean();
        try {
            this.doCopyFile(id, srcFile, dstFile, overwriteDestination);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e);
            return;
        }
        this.sendStatus(BufferUtils.clear(buffer), id, 0, "");
    }

    protected void doCopyFile(int id, String srcFile, String dstFile, boolean overwriteDestination) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("SSH_FXP_EXTENDED[{}] (src={}, dst={}, overwrite=0x{})", new Object[]{"copy-file", srcFile, dstFile, overwriteDestination});
        }
        this.doCopyFile(id, srcFile, dstFile, overwriteDestination ? Collections.singletonList(StandardCopyOption.REPLACE_EXISTING) : Collections.emptyList());
    }

    protected void doCopyFile(int id, String srcFile, String dstFile, Collection<CopyOption> opts) throws IOException {
        Path src = this.resolveFile(srcFile);
        Path dst = this.resolveFile(dstFile);
        Files.copy(src, dst, GenericUtils.isEmpty(opts) ? IoUtils.EMPTY_COPY_OPTIONS : opts.toArray(new CopyOption[opts.size()]));
    }

    protected void doStat(Buffer buffer, int id) throws IOException {
        Map<String, Object> attrs;
        String path = buffer.getString();
        int flags = 65535;
        if (this.version >= 4) {
            flags = buffer.getInt();
        }
        try {
            attrs = this.doStat(id, path, flags);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e);
            return;
        }
        this.sendAttrs(BufferUtils.clear(buffer), id, attrs);
    }

    protected Map<String, Object> doStat(int id, String path, int flags) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received SSH_FXP_STAT (path={}, flags=0x{})", (Object)path, (Object)Integer.toHexString(flags));
        }
        Path p = this.resolveFile(path);
        return this.resolveFileAttributes(p, flags, IoUtils.getLinkOptions(false));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doRealPath(Buffer buffer, int id) throws IOException {
        void var4_9;
        Pair<Path, Boolean> result;
        String path = buffer.getString();
        this.log.debug("Received SSH_FXP_REALPATH (path={})", (Object)path);
        path = GenericUtils.trimToEmpty(path);
        if (GenericUtils.isEmpty(path)) {
            path = ".";
        }
        Map map = Collections.emptyMap();
        try {
            LinkOption[] options = IoUtils.getLinkOptions(false);
            if (this.version < 6) {
                result = this.doRealPathV345(id, path, options);
            } else {
                int control = 0;
                if (buffer.available() > 0) {
                    control = buffer.getUByte();
                }
                LinkedList<String> extraPaths = new LinkedList<String>();
                while (buffer.available() > 0) {
                    extraPaths.add(buffer.getString());
                }
                result = this.doRealPathV6(id, path, extraPaths, options);
                Path p = result.getFirst();
                Boolean status = result.getSecond();
                if (control == 2) {
                    if (status == null) {
                        Map<String, Object> map2 = this.handleUnknownStatusFileAttributes(p, 65535, options);
                    } else if (status.booleanValue()) {
                        try {
                            Map<String, Object> map3 = this.getAttributes(p, IoUtils.getLinkOptions(false));
                        }
                        catch (IOException e) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Failed ({}) to retrieve attributes of {}: {}", new Object[]{e.getClass().getSimpleName(), p, e.getMessage()});
                            }
                        }
                    } else if (this.log.isDebugEnabled()) {
                        this.log.debug("Dummy attributes for non-existing file: " + p);
                    }
                } else if (control == 3) {
                    if (status == null) {
                        Map<String, Object> map4 = this.handleUnknownStatusFileAttributes(p, 65535, options);
                    } else {
                        if (!status.booleanValue()) throw new FileNotFoundException(p.toString());
                        Map<String, Object> map5 = this.getAttributes(p, options);
                    }
                }
            }
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e);
            return;
        }
        this.sendPath(BufferUtils.clear(buffer), id, result.getFirst(), (Map<String, ?>)var4_9);
    }

    protected Pair<Path, Boolean> doRealPathV6(int id, String path, Collection<String> extraPaths, LinkOption ... options) throws IOException {
        Path p = this.resolveFile(path);
        int numExtra = GenericUtils.size(extraPaths);
        if (numExtra > 0) {
            StringBuilder sb = new StringBuilder(GenericUtils.length(path) + numExtra * 8);
            sb.append(path);
            for (String p2 : extraPaths) {
                p = p.resolve(p2);
                sb.append('/').append(p2);
            }
            path = sb.toString();
        }
        return this.validateRealPath(id, path, p, options);
    }

    protected Pair<Path, Boolean> doRealPathV345(int id, String path, LinkOption ... options) throws IOException {
        return this.validateRealPath(id, path, this.resolveFile(path), options);
    }

    protected Pair<Path, Boolean> validateRealPath(int id, String path, Path f, LinkOption ... options) throws IOException {
        Path p = this.normalize(f);
        Boolean status = IoUtils.checkFileExists(p, options);
        return new Pair<Path, Boolean>(p, status);
    }

    protected void doRemoveDirectory(Buffer buffer, int id) throws IOException {
        String path = buffer.getString();
        try {
            this.doRemoveDirectory(id, path, IoUtils.getLinkOptions(false));
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e);
            return;
        }
        this.sendStatus(BufferUtils.clear(buffer), id, 0, "");
    }

    protected void doRemoveDirectory(int id, String path, LinkOption ... options) throws IOException {
        Path p = this.resolveFile(path);
        this.log.debug("Received SSH_FXP_RMDIR (path={})[{}]", (Object)path, (Object)p);
        if (!Files.isDirectory(p, options)) {
            throw new NotDirectoryException(p.toString());
        }
        Files.delete(p);
    }

    protected void doMakeDirectory(Buffer buffer, int id) throws IOException {
        String path = buffer.getString();
        Map<String, Object> attrs = this.readAttrs(buffer);
        try {
            this.doMakeDirectory(id, path, attrs, IoUtils.getLinkOptions(false));
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e);
            return;
        }
        this.sendStatus(BufferUtils.clear(buffer), id, 0, "");
    }

    protected void doMakeDirectory(int id, String path, Map<String, ?> attrs, LinkOption ... options) throws IOException {
        Boolean status;
        Path p = this.resolveFile(path);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received SSH_FXP_MKDIR (path={}[{}], attrs={})", new Object[]{path, p, attrs});
        }
        if ((status = IoUtils.checkFileExists(p, options)) == null) {
            throw new AccessDeniedException("Cannot validate make-directory existence for " + p);
        }
        if (status.booleanValue()) {
            if (Files.isDirectory(p, options)) {
                throw new FileAlreadyExistsException(p.toString(), p.toString(), "Target directory already exists");
            }
            throw new FileNotFoundException(p.toString() + " already exists as a file");
        }
        Files.createDirectory(p, new FileAttribute[0]);
        this.setAttributes(p, attrs);
    }

    protected void doRemove(Buffer buffer, int id) throws IOException {
        String path = buffer.getString();
        try {
            this.doRemove(id, path, IoUtils.getLinkOptions(false));
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e);
            return;
        }
        this.sendStatus(BufferUtils.clear(buffer), id, 0, "");
    }

    protected void doRemove(int id, String path, LinkOption ... options) throws IOException {
        Boolean status;
        Path p = this.resolveFile(path);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received SSH_FXP_REMOVE (path={}[{}])", (Object)path, (Object)p);
        }
        if ((status = IoUtils.checkFileExists(p, options)) == null) {
            throw new AccessDeniedException("Cannot determine existence of remove candidate: " + p);
        }
        if (!status.booleanValue()) {
            throw new FileNotFoundException(p.toString());
        }
        if (Files.isDirectory(p, options)) {
            throw new FileNotFoundException(p.toString() + " is as a folder");
        }
        Files.delete(p);
    }

    protected void doReadDir(Buffer buffer, int id) throws IOException {
        String handle = buffer.getString();
        Handle h = this.handles.get(handle);
        this.log.debug("Received SSH_FXP_READDIR (handle={}[{}])", (Object)handle, (Object)h);
        Buffer reply = null;
        try {
            LinkOption[] options;
            DirectoryHandle dh = this.validateHandle(handle, h, DirectoryHandle.class);
            if (dh.isDone()) {
                throw new EOFException("Directory reading is done");
            }
            Path file = dh.getFile();
            Boolean status = IoUtils.checkFileExists(file, options = IoUtils.getLinkOptions(false));
            if (status == null) {
                throw new AccessDeniedException("Cannot determine existence of read-dir for " + file);
            }
            if (!status.booleanValue()) {
                throw new FileNotFoundException(file.toString());
            }
            if (!Files.isDirectory(file, options)) {
                throw new NotDirectoryException(file.toString());
            }
            if (!Files.isReadable(file)) {
                throw new AccessDeniedException("Not readable: " + file.toString());
            }
            if (dh.isSendDot() || dh.isSendDotDot() || dh.hasNext()) {
                reply = BufferUtils.clear(buffer);
                reply.putByte((byte)104);
                reply.putInt(id);
                int lenPos = reply.wpos();
                reply.putInt(0L);
                int count = this.doReadDir(id, dh, reply, FactoryManagerUtils.getIntProperty(this.session, MAX_PACKET_LENGTH_PROP, 16384));
                BufferUtils.updateLengthPlaceholder(reply, lenPos, count);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("doReadDir({})[{}] - sent {} entries", new Object[]{handle, h, count});
                }
                if (!(dh.isSendDot() || dh.isSendDotDot() || dh.hasNext())) {
                    dh.markDone();
                }
            } else {
                dh.markDone();
                throw new EOFException("Empty directory");
            }
            ValidateUtils.checkNotNull(reply, "No reply buffer created");
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e);
            return;
        }
        this.send(reply);
    }

    protected void doOpenDir(Buffer buffer, int id) throws IOException {
        String handle;
        String path = buffer.getString();
        try {
            handle = this.doOpenDir(id, path, IoUtils.getLinkOptions(false));
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e);
            return;
        }
        this.sendHandle(BufferUtils.clear(buffer), id, handle);
    }

    protected String doOpenDir(int id, String path, LinkOption ... options) throws IOException {
        Path p = this.resolveNormalizedLocation(path);
        this.log.debug("Received SSH_FXP_OPENDIR (path={})[{}]", (Object)path, (Object)p);
        Boolean status = IoUtils.checkFileExists(p, options);
        if (status == null) {
            throw new AccessDeniedException("Cannot determine open-dir existence for " + p);
        }
        if (!status.booleanValue()) {
            throw new FileNotFoundException(path);
        }
        if (!Files.isDirectory(p, options)) {
            throw new NotDirectoryException(path);
        }
        if (!Files.isReadable(p)) {
            throw new AccessDeniedException("Not readable: " + p);
        }
        String handle = this.generateFileHandle(p);
        this.handles.put(handle, new DirectoryHandle(p));
        return handle;
    }

    protected void doFSetStat(Buffer buffer, int id) throws IOException {
        String handle = buffer.getString();
        Map<String, Object> attrs = this.readAttrs(buffer);
        try {
            this.doFSetStat(id, handle, attrs);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e);
            return;
        }
        this.sendStatus(BufferUtils.clear(buffer), id, 0, "");
    }

    protected void doFSetStat(int id, String handle, Map<String, ?> attrs) throws IOException {
        Handle h = this.handles.get(handle);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received SSH_FXP_FSETSTAT (handle={}[{}], attrs={})", new Object[]{handle, h, attrs});
        }
        this.setAttributes(this.validateHandle(handle, h, Handle.class).getFile(), attrs);
    }

    protected void doSetStat(Buffer buffer, int id) throws IOException {
        String path = buffer.getString();
        Map<String, Object> attrs = this.readAttrs(buffer);
        try {
            this.doSetStat(id, path, attrs);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e);
            return;
        }
        this.sendStatus(BufferUtils.clear(buffer), id, 0, "");
    }

    protected void doSetStat(int id, String path, Map<String, ?> attrs) throws IOException {
        this.log.debug("Received SSH_FXP_SETSTAT (path={}, attrs={})", (Object)path, attrs);
        Path p = this.resolveFile(path);
        this.setAttributes(p, attrs);
    }

    protected void doFStat(Buffer buffer, int id) throws IOException {
        Map<String, Object> attrs;
        String handle = buffer.getString();
        int flags = 65535;
        if (this.version >= 4) {
            flags = buffer.getInt();
        }
        try {
            attrs = this.doFStat(id, handle, flags);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e);
            return;
        }
        this.sendAttrs(BufferUtils.clear(buffer), id, attrs);
    }

    protected Map<String, Object> doFStat(int id, String handle, int flags) throws IOException {
        Handle h = this.handles.get(handle);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received SSH_FXP_FSTAT (handle={}[{}], flags=0x{})", new Object[]{handle, h, Integer.toHexString(flags)});
        }
        return this.resolveFileAttributes(this.validateHandle(handle, h, Handle.class).getFile(), flags, IoUtils.getLinkOptions(true));
    }

    protected void doLStat(Buffer buffer, int id) throws IOException {
        Map<String, Object> attrs;
        String path = buffer.getString();
        int flags = 65535;
        if (this.version >= 4) {
            flags = buffer.getInt();
        }
        try {
            attrs = this.doLStat(id, path, flags);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e);
            return;
        }
        this.sendAttrs(BufferUtils.clear(buffer), id, attrs);
    }

    protected Map<String, Object> doLStat(int id, String path, int flags) throws IOException {
        Path p = this.resolveFile(path);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received SSH_FXP_LSTAT (path={}[{}], flags=0x{})", new Object[]{path, p, Integer.toHexString(flags)});
        }
        return this.resolveFileAttributes(p, flags, IoUtils.getLinkOptions(false));
    }

    protected void doWrite(Buffer buffer, int id) throws IOException {
        String handle = buffer.getString();
        long offset = buffer.getLong();
        int length = buffer.getInt();
        try {
            this.doWrite(id, handle, offset, length, buffer.array(), buffer.rpos(), buffer.available());
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e);
            return;
        }
        this.sendStatus(BufferUtils.clear(buffer), id, 0, "");
    }

    protected void doWrite(int id, String handle, long offset, int length, byte[] data, int doff, int remaining) throws IOException {
        Handle h = this.handles.get(handle);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received SSH_FXP_WRITE (handle={}[{}], offset={}, data=byte[{}])", new Object[]{handle, h, offset, length});
        }
        FileHandle fh = this.validateHandle(handle, h, FileHandle.class);
        if (length < 0) {
            throw new IllegalStateException("Bad length (" + length + ") for writing to " + fh);
        }
        if (remaining < length) {
            throw new IllegalStateException("Not enough buffer data for writing to " + fh + ": required=" + length + ", available=" + remaining);
        }
        if (fh.isOpenAppend()) {
            fh.append(data, doff, length);
        } else {
            fh.write(data, doff, length, offset);
        }
    }

    protected void doRead(Buffer buffer, int id) throws IOException {
        String handle = buffer.getString();
        long offset = buffer.getLong();
        int requestedLength = buffer.getInt();
        int maxAllowed = FactoryManagerUtils.getIntProperty(this.session, MAX_PACKET_LENGTH_PROP, 16384);
        int readLen = Math.min(requestedLength, maxAllowed);
        if (this.log.isTraceEnabled()) {
            this.log.trace("doRead({})[offset={}] - req.={}, max.={}, effective={}", new Object[]{handle, offset, requestedLength, maxAllowed, readLen});
        }
        try {
            ValidateUtils.checkTrue(readLen >= 0, "Illegal requested read length: %d", (Object)readLen);
            buffer.clear();
            buffer.ensureCapacity(readLen + 64, Int2IntFunction.IDENTITY);
            buffer.putByte((byte)103);
            buffer.putInt(id);
            int lenPos = buffer.wpos();
            buffer.putInt(0L);
            int startPos = buffer.wpos();
            int len = this.doRead(id, handle, offset, readLen, buffer.array(), startPos);
            if (len < 0) {
                throw new EOFException("Unable to read " + readLen + " bytes from offset=" + offset + " of " + handle);
            }
            buffer.wpos(startPos + len);
            BufferUtils.updateLengthPlaceholder(buffer, lenPos, len);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e);
            return;
        }
        this.send(buffer);
    }

    protected int doRead(int id, String handle, long offset, int length, byte[] data, int doff) throws IOException {
        Handle h = this.handles.get(handle);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received SSH_FXP_READ (handle={}[{}], offset={}, length={})", new Object[]{handle, h, offset, length});
        }
        ValidateUtils.checkTrue(length > 0, "Invalid read length: %d", (Object)length);
        FileHandle fh = this.validateHandle(handle, h, FileHandle.class);
        return fh.read(data, doff, length, offset);
    }

    protected void doClose(Buffer buffer, int id) throws IOException {
        String handle = buffer.getString();
        try {
            this.doClose(id, handle);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e);
            return;
        }
        this.sendStatus(BufferUtils.clear(buffer), id, 0, "", "");
    }

    protected void doClose(int id, String handle) throws IOException {
        Handle h = this.handles.remove(handle);
        this.log.debug("Received SSH_FXP_CLOSE (handle={}[{}])", (Object)handle, (Object)h);
        this.validateHandle(handle, h, Handle.class).close();
    }

    protected void doOpen(Buffer buffer, int id) throws IOException {
        String handle;
        int pflags;
        String path = buffer.getString();
        int access = 0;
        if (this.version >= 5 && (access = buffer.getInt()) == 0) {
            access = 129;
        }
        if ((pflags = buffer.getInt()) == 0) {
            pflags = 1;
        }
        if (this.version < 5) {
            int flags = pflags;
            pflags = 0;
            switch (flags & 3) {
                case 1: {
                    access |= 0x81;
                    break;
                }
                case 2: {
                    access |= 0x102;
                    break;
                }
                default: {
                    access |= 0x81;
                    access |= 0x102;
                }
            }
            if ((flags & 4) != 0) {
                access |= 4;
                pflags |= 0x18;
            }
            pflags = (flags & 8) != 0 ? ((flags & 0x20) != 0 ? (pflags |= 0) : ((flags & 0x10) != 0 ? (pflags |= 1) : (pflags |= 3))) : ((flags & 0x10) != 0 ? (pflags |= 4) : (pflags |= 2));
        }
        Map<String, Object> attrs = this.readAttrs(buffer);
        try {
            handle = this.doOpen(id, path, pflags, access, attrs);
        }
        catch (IOException | RuntimeException e) {
            this.sendStatus(BufferUtils.clear(buffer), id, e);
            return;
        }
        this.sendHandle(BufferUtils.clear(buffer), id, handle);
    }

    protected String doOpen(int id, String path, int pflags, int access, Map<String, Object> attrs) throws IOException {
        int maxHandleCount;
        int curHandleCount;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received SSH_FXP_OPEN (path={}, access=0x{}, pflags=0x{}, attrs={})", new Object[]{path, Integer.toHexString(access), Integer.toHexString(pflags), attrs});
        }
        if ((curHandleCount = this.handles.size()) > (maxHandleCount = FactoryManagerUtils.getIntProperty(this.session, MAX_OPEN_HANDLES_PER_SESSION, Integer.MAX_VALUE))) {
            throw new IllegalStateException("Too many open handles: current=" + curHandleCount + ", max.=" + maxHandleCount);
        }
        Path file = this.resolveFile(path);
        String handle = this.generateFileHandle(file);
        this.handles.put(handle, new FileHandle(this, file, pflags, access, attrs));
        return handle;
    }

    protected String generateFileHandle(Path file) {
        for (int index = 0; index < this.maxFileHandleRounds; ++index) {
            this.randomizer.fill(this.workBuf, 0, this.fileHandleSize);
            String handle = BufferUtils.printHex(this.workBuf, 0, this.fileHandleSize, '\u0000');
            if (this.handles.containsKey(handle)) {
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace("generateFileHandle({}) handle={} in use at round {}", new Object[]{file, handle, index});
                continue;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("generateFileHandle({}) {}", (Object)file, (Object)handle);
            }
            return handle;
        }
        throw new IllegalStateException("Failed to generate a unique file handle for " + file);
    }

    protected void doInit(Buffer buffer, int id) throws IOException {
        String all;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received SSH_FXP_INIT (version={})", (Object)id);
        }
        if (GenericUtils.isEmpty(all = this.checkVersionCompatibility(buffer, id, id, 8))) {
            return;
        }
        this.version = id;
        while (buffer.available() > 0) {
            String name = buffer.getString();
            byte[] data = buffer.getBytes();
            this.extensions.put(name, data);
        }
        buffer.clear();
        buffer.putByte((byte)2);
        buffer.putInt(this.version);
        this.appendExtensions(buffer, all);
        this.send(buffer);
    }

    protected void appendExtensions(Buffer buffer, String supportedVersions) {
        this.appendVersionsExtension(buffer, supportedVersions);
        this.appendNewlineExtension(buffer, System.getProperty("line.separator"));
        this.appendVendorIdExtension(buffer, VersionProperties.getVersionProperties());
        this.appendOpenSSHExtensions(buffer);
        Collection<String> extras = this.getSupportedClientExtensions();
        this.appendSupportedExtension(buffer, extras);
        this.appendSupported2Extension(buffer, extras);
    }

    protected List<AbstractOpenSSHExtensionParser.OpenSSHExtension> appendOpenSSHExtensions(Buffer buffer) {
        List<AbstractOpenSSHExtensionParser.OpenSSHExtension> extList = this.resolveOpenSSHExtensions();
        if (GenericUtils.isEmpty(extList)) {
            return extList;
        }
        for (AbstractOpenSSHExtensionParser.OpenSSHExtension ext : extList) {
            buffer.putString(ext.getName());
            buffer.putString(ext.getVersion());
        }
        return extList;
    }

    protected List<AbstractOpenSSHExtensionParser.OpenSSHExtension> resolveOpenSSHExtensions() {
        String value = FactoryManagerUtils.getString(this.session, OPENSSH_EXTENSIONS_PROP);
        if (value == null) {
            return DEFAULT_OPEN_SSH_EXTENSIONS;
        }
        String[] pairs = GenericUtils.split(value, ',');
        int numExts = GenericUtils.length(pairs);
        if (numExts <= 0) {
            return Collections.emptyList();
        }
        ArrayList<AbstractOpenSSHExtensionParser.OpenSSHExtension> extList = new ArrayList<AbstractOpenSSHExtensionParser.OpenSSHExtension>(numExts);
        for (String nvp : pairs) {
            if (GenericUtils.isEmpty(nvp = GenericUtils.trimToEmpty(nvp))) continue;
            int pos = nvp.indexOf(61);
            ValidateUtils.checkTrue(pos > 0 && pos < nvp.length() - 1, "Malformed OpenSSH extension spec: %s", (Object)nvp);
            String name = GenericUtils.trimToEmpty(nvp.substring(0, pos));
            String version = GenericUtils.trimToEmpty(nvp.substring(pos + 1));
            extList.add(new AbstractOpenSSHExtensionParser.OpenSSHExtension(name, ValidateUtils.checkNotNullAndNotEmpty(version, "No version specified for OpenSSH extension %s", (Object)name)));
        }
        return extList;
    }

    protected Collection<String> getSupportedClientExtensions() {
        String value = FactoryManagerUtils.getString(this.session, CLIENT_EXTENSIONS_PROP);
        if (value == null) {
            return DEFAULT_SUPPORTED_CLIENT_EXTENSIONS;
        }
        if (value.length() <= 0) {
            return Collections.emptyList();
        }
        String[] comps = GenericUtils.split(value, ',');
        return Arrays.asList(comps);
    }

    protected void appendVersionsExtension(Buffer buffer, String value) {
        buffer.putString("versions");
        buffer.putString(value);
    }

    protected void appendNewlineExtension(Buffer buffer, String value) {
        buffer.putString("newline");
        buffer.putString(value);
    }

    protected void appendVendorIdExtension(Buffer buffer, Map<String, ?> versionProperties) {
        buffer.putString("vendor-id");
        int lenPos = buffer.wpos();
        buffer.putInt(0L);
        buffer.putString(FactoryManagerUtils.getStringProperty(versionProperties, "groupId", this.getClass().getPackage().getName()));
        buffer.putString(FactoryManagerUtils.getStringProperty(versionProperties, "artifactId", this.getClass().getSimpleName()));
        buffer.putString(FactoryManagerUtils.getStringProperty(versionProperties, "version", "SSHD-UNKNOWN"));
        buffer.putLong(0L);
        BufferUtils.updateLengthPlaceholder(buffer, lenPos);
    }

    protected void appendSupportedExtension(Buffer buffer, Collection<String> extras) {
        buffer.putString("supported");
        int lenPos = buffer.wpos();
        buffer.putInt(0L);
        buffer.putInt(701L);
        buffer.putInt(0L);
        buffer.putInt(63L);
        buffer.putInt(0L);
        buffer.putInt(0L);
        buffer.putStringList(extras, false);
        BufferUtils.updateLengthPlaceholder(buffer, lenPos);
    }

    protected void appendSupported2Extension(Buffer buffer, Collection<String> extras) {
        buffer.putString("supported2");
        int lenPos = buffer.wpos();
        buffer.putInt(0L);
        buffer.putInt(701L);
        buffer.putInt(0L);
        buffer.putInt(15L);
        buffer.putInt(0L);
        buffer.putInt(0L);
        buffer.putShort(0);
        buffer.putShort(0);
        buffer.putStringList(Collections.emptyList(), true);
        buffer.putStringList(extras, true);
        BufferUtils.updateLengthPlaceholder(buffer, lenPos);
    }

    protected void sendHandle(Buffer buffer, int id, String handle) throws IOException {
        buffer.putByte((byte)102);
        buffer.putInt(id);
        buffer.putString(handle);
        this.send(buffer);
    }

    protected void sendAttrs(Buffer buffer, int id, Map<String, ?> attributes) throws IOException {
        buffer.putByte((byte)105);
        buffer.putInt(id);
        this.writeAttrs(buffer, attributes);
        this.send(buffer);
    }

    protected void sendPath(Buffer buffer, int id, Path f, Map<String, ?> attrs) throws IOException {
        buffer.putByte((byte)104);
        buffer.putInt(id);
        buffer.putInt(1L);
        String originalPath = f.toString();
        String unixPath = originalPath.replace(File.separatorChar, '/');
        String normalizedPath = SelectorUtils.normalizePath(unixPath, "/");
        if (normalizedPath.length() == 0) {
            normalizedPath = "/";
        }
        buffer.putString(normalizedPath);
        if (this.version == 3) {
            f = this.resolveFile(normalizedPath);
            buffer.putString(this.getLongName(f, attrs));
            buffer.putInt(0L);
        } else if (this.version >= 4) {
            this.writeAttrs(buffer, attrs);
        } else {
            throw new IllegalStateException("sendPath(" + f + ") unsupported version: " + this.version);
        }
        this.send(buffer);
    }

    protected void sendLink(Buffer buffer, int id, String link) throws IOException {
        String unixPath = link.replace(File.separatorChar, '/');
        buffer.putByte((byte)104);
        buffer.putInt(id);
        buffer.putInt(1L);
        buffer.putString(unixPath);
        if (this.version == 3) {
            buffer.putString(unixPath);
        }
        SftpHelper.writeAttrs(this.version, buffer, Collections.emptyMap());
        this.send(buffer);
    }

    protected int doReadDir(int id, DirectoryHandle dir, Buffer buffer, int maxSize) throws IOException {
        int nb = 0;
        LinkOption[] options = IoUtils.getLinkOptions(false);
        while ((dir.isSendDot() || dir.isSendDotDot() || dir.hasNext()) && buffer.wpos() < maxSize) {
            if (dir.isSendDot()) {
                this.writeDirEntry(id, dir, buffer, nb, dir.getFile(), ".", options);
                dir.markDotSent();
            } else if (dir.isSendDotDot()) {
                this.writeDirEntry(id, dir, buffer, nb, dir.getFile().getParent(), "..", options);
                dir.markDotDotSent();
            } else {
                Path f = dir.next();
                this.writeDirEntry(id, dir, buffer, nb, f, this.getShortName(f), options);
            }
            ++nb;
        }
        return nb;
    }

    protected void writeDirEntry(int id, DirectoryHandle dir, Buffer buffer, int index, Path f, String shortName, LinkOption ... options) throws IOException {
        Map<String, Object> attrs = this.resolveFileAttributes(f, 65535, options);
        buffer.putString(shortName);
        if (this.version == 3) {
            String longName = this.getLongName(f, options);
            buffer.putString(longName);
            if (this.log.isTraceEnabled()) {
                this.log.trace("writeDirEntry(id=" + id + ")[" + index + "] - " + shortName + " [" + longName + "]: " + attrs);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("writeDirEntry(id=" + id + ")[" + index + "] - " + shortName + ": " + attrs);
        }
        this.writeAttrs(buffer, attrs);
    }

    protected String getLongName(Path f, LinkOption ... options) throws IOException {
        return this.getLongName(f, true, options);
    }

    private String getLongName(Path f, boolean sendAttrs, LinkOption ... options) throws IOException {
        Map<Object, Object> attributes = sendAttrs ? this.getAttributes(f, options) : Collections.emptyMap();
        return this.getLongName(f, attributes);
    }

    private String getLongName(Path f, Map<String, ?> attributes) throws IOException {
        String username = attributes.containsKey("owner") ? Objects.toString(attributes.get("owner"), null) : "owner";
        if (username.length() > 8) {
            username = username.substring(0, 8);
        } else {
            for (int i = username.length(); i < 8; ++i) {
                username = username + " ";
            }
        }
        String group = attributes.containsKey("group") ? Objects.toString(attributes.get("group"), null) : "group";
        if (group.length() > 8) {
            group = group.substring(0, 8);
        } else {
            for (int i = group.length(); i < 8; ++i) {
                group = group + " ";
            }
        }
        Number length = (Number)attributes.get("size");
        if (length == null) {
            length = 0L;
        }
        String lengthString = String.format("%1$8s", length);
        Boolean isDirectory = (Boolean)attributes.get("isDirectory");
        Boolean isLink = (Boolean)attributes.get("isSymbolicLink");
        EnumSet<PosixFilePermission> perms = (EnumSet<PosixFilePermission>)attributes.get("permissions");
        if (perms == null) {
            perms = EnumSet.noneOf(PosixFilePermission.class);
        }
        return (SftpHelper.getBool(isDirectory) ? "d" : (SftpHelper.getBool(isLink) ? "l" : "-")) + PosixFilePermissions.toString(perms) + "  " + (attributes.containsKey("nlink") ? attributes.get("nlink") : "1") + " " + username + " " + group + " " + lengthString + " " + UnixDateFormat.getUnixDate((FileTime)attributes.get("lastModifiedTime")) + " " + this.getShortName(f);
    }

    protected String getShortName(Path f) throws IOException {
        Path nrm = this.normalize(f);
        int count = nrm.getNameCount();
        if (OsUtils.isUNIX()) {
            Path name = f.getFileName();
            if (name == null) {
                Path p = this.resolveFile(".");
                name = p.getFileName();
            }
            if (name == null && count > 0) {
                name = nrm.getFileName();
            }
            if (name != null) {
                return name.toString();
            }
            return nrm.toString();
        }
        if (count > 0) {
            Path name = nrm.getFileName();
            return name.toString();
        }
        return nrm.toString().replace(File.separatorChar, '/');
    }

    protected Map<String, Object> resolveFileAttributes(Path file, int flags, LinkOption ... options) throws IOException {
        Boolean status = IoUtils.checkFileExists(file, options);
        if (status == null) {
            return this.handleUnknownStatusFileAttributes(file, flags, options);
        }
        if (!status.booleanValue()) {
            throw new FileNotFoundException(file.toString());
        }
        return this.getAttributes(file, flags, options);
    }

    protected void writeAttrs(Buffer buffer, Map<String, ?> attributes) throws IOException {
        SftpHelper.writeAttrs(this.version, buffer, attributes);
    }

    protected Map<String, Object> getAttributes(Path file, LinkOption ... options) throws IOException {
        return this.getAttributes(file, 65535, options);
    }

    protected Map<String, Object> handleUnknownStatusFileAttributes(Path file, int flags, LinkOption ... options) throws IOException {
        switch (this.unsupportedAttributePolicy) {
            case Ignore: {
                break;
            }
            case ThrowException: {
                throw new AccessDeniedException("Cannot determine existence for attributes of " + file);
            }
            case Warn: {
                this.log.warn("handleUnknownStatusFileAttributes(" + file + ") cannot determine existence");
                break;
            }
            default: {
                this.log.warn("handleUnknownStatusFileAttributes(" + file + ") unknown policy: " + (Object)((Object)this.unsupportedAttributePolicy));
            }
        }
        return this.getAttributes(file, flags, options);
    }

    protected Map<String, Object> getAttributes(Path file, int flags, LinkOption ... options) throws IOException {
        List<Object> views;
        FileSystem fs = file.getFileSystem();
        Set<String> supportedViews = fs.supportedFileAttributeViews();
        TreeMap<String, Object> attrs = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        if (GenericUtils.isEmpty(supportedViews)) {
            views = Collections.emptyList();
        } else if (supportedViews.contains("unix")) {
            views = DEFAULT_UNIX_VIEW;
        } else {
            views = new ArrayList(supportedViews.size());
            for (String string : supportedViews) {
                views.add(string + ":*");
            }
        }
        for (String string : views) {
            Map<String, Object> ta = this.readFileAttributes(file, string, options);
            if (GenericUtils.size(ta) <= 0) continue;
            attrs.putAll(ta);
        }
        Map<String, Object> completions = this.resolveMissingFileAttributes(file, flags, attrs, options);
        if (GenericUtils.size(completions) > 0) {
            attrs.putAll(completions);
        }
        return attrs;
    }

    protected Map<String, Object> resolveMissingFileAttributes(Path file, int flags, Map<String, Object> current, LinkOption ... options) throws IOException {
        TreeMap<String, Object> attrs = null;
        for (Map.Entry<String, FileInfoExtractor<?>> re : FILEATTRS_RESOLVERS.entrySet()) {
            String name = re.getKey();
            Object value = GenericUtils.isEmpty(current) ? null : current.get(name);
            FileInfoExtractor<?> x = re.getValue();
            try {
                Object resolved = this.resolveMissingFileAttributeValue(file, name, value, x, options);
                if (Objects.equals(resolved, value)) continue;
                if (attrs == null) {
                    attrs = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
                }
                attrs.put(name, resolved);
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("resolveMissingFileAttributes(" + file + ")[" + name + "]" + " replace " + value + " with " + resolved);
            }
            catch (IOException e) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("resolveMissingFileAttributes(" + file + ")[" + name + "]" + " failed (" + e.getClass().getSimpleName() + ")" + " to resolve missing value: " + e.getMessage());
            }
        }
        if (attrs == null) {
            return Collections.emptyMap();
        }
        return attrs;
    }

    protected Object resolveMissingFileAttributeValue(Path file, String name, Object value, FileInfoExtractor<?> x, LinkOption ... options) throws IOException {
        if (value != null) {
            return value;
        }
        return x.infoOf(file, options);
    }

    protected Map<String, Object> addMissingAttribute(Path file, Map<String, Object> current, String name, FileInfoExtractor<?> x, LinkOption ... options) throws IOException {
        Object value;
        Object object = value = GenericUtils.isEmpty(current) ? null : current.get(name);
        if (value != null) {
            return current;
        }
        value = x.infoOf(file, options);
        if (value == null) {
            return current;
        }
        if (current == null) {
            current = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        }
        current.put(name, value);
        return current;
    }

    protected Map<String, Object> readFileAttributes(Path file, String view, LinkOption ... options) throws IOException {
        try {
            return Files.readAttributes(file, view, options);
        }
        catch (IOException e) {
            return this.handleReadFileAttributesException(file, view, options, e);
        }
    }

    protected Map<String, Object> handleReadFileAttributesException(Path file, String view, LinkOption[] options, IOException e) throws IOException {
        switch (this.unsupportedAttributePolicy) {
            case Ignore: {
                break;
            }
            case Warn: {
                this.log.warn("handleReadFileAttributesException(" + file + ")[" + view + "] " + e.getClass().getSimpleName() + ": " + e.getMessage());
                break;
            }
            case ThrowException: {
                throw e;
            }
            default: {
                this.log.warn("handleReadFileAttributesException(" + file + ")[" + view + "]" + " Unknown policy (" + (Object)((Object)this.unsupportedAttributePolicy) + ")" + " for " + e.getClass().getSimpleName() + ": " + e.getMessage());
            }
        }
        return Collections.emptyMap();
    }

    protected void setAttributes(Path file, Map<String, ?> attributes) throws IOException {
        HashSet<String> unsupported = new HashSet<String>();
        block33: for (String attribute : attributes.keySet()) {
            String view = null;
            Object value = attributes.get(attribute);
            switch (attribute) {
                case "size": {
                    long newSize = ((Number)value).longValue();
                    FileChannel channel = FileChannel.open(file, StandardOpenOption.WRITE);
                    Throwable throwable = null;
                    try {
                        channel.truncate(newSize);
                        continue block33;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (channel == null) continue block33;
                        if (throwable != null) {
                            try {
                                channel.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue block33;
                        }
                        channel.close();
                        continue block33;
                    }
                }
                case "uid": {
                    view = "unix";
                    break;
                }
                case "gid": {
                    view = "unix";
                    break;
                }
                case "owner": {
                    view = "posix";
                    value = this.toUser(file, (UserPrincipal)value);
                    break;
                }
                case "group": {
                    view = "posix";
                    value = this.toGroup(file, (GroupPrincipal)value);
                    break;
                }
                case "permissions": {
                    if (OsUtils.isWin32()) {
                        Collection perms = (Collection)value;
                        IoUtils.setPermissionsToFile(file.toFile(), perms);
                        continue block33;
                    }
                    view = "posix";
                    break;
                }
                case "creationTime": {
                    view = "basic";
                    break;
                }
                case "lastModifiedTime": {
                    view = "basic";
                    break;
                }
                case "lastAccessTime": {
                    view = "basic";
                    break;
                }
            }
            if (view == null || value == null) continue;
            try {
                Files.setAttribute(file, view + ":" + attribute, value, IoUtils.getLinkOptions(false));
            }
            catch (UnsupportedOperationException e) {
                unsupported.add(attribute);
            }
        }
        this.handleUnsupportedAttributes(unsupported);
    }

    protected void handleUnsupportedAttributes(Collection<String> attributes) {
        if (!attributes.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String attr : attributes) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(attr);
            }
            switch (this.unsupportedAttributePolicy) {
                case Ignore: {
                    break;
                }
                case Warn: {
                    this.log.warn("Unsupported attributes: " + sb.toString());
                    break;
                }
                case ThrowException: {
                    throw new UnsupportedOperationException("Unsupported attributes: " + sb.toString());
                }
                default: {
                    this.log.warn("Unknown policy for attributes=" + sb.toString() + ": " + (Object)((Object)this.unsupportedAttributePolicy));
                }
            }
        }
    }

    private GroupPrincipal toGroup(Path file, GroupPrincipal name) throws IOException {
        String groupName = name.toString();
        FileSystem fileSystem = file.getFileSystem();
        UserPrincipalLookupService lookupService = fileSystem.getUserPrincipalLookupService();
        try {
            return lookupService.lookupPrincipalByGroupName(groupName);
        }
        catch (IOException e) {
            this.handleUserPrincipalLookupServiceException(GroupPrincipal.class, groupName, e);
            return null;
        }
    }

    private UserPrincipal toUser(Path file, UserPrincipal name) throws IOException {
        String username = name.toString();
        FileSystem fileSystem = file.getFileSystem();
        UserPrincipalLookupService lookupService = fileSystem.getUserPrincipalLookupService();
        try {
            return lookupService.lookupPrincipalByName(username);
        }
        catch (IOException e) {
            this.handleUserPrincipalLookupServiceException(UserPrincipal.class, username, e);
            return null;
        }
    }

    protected void handleUserPrincipalLookupServiceException(Class<? extends Principal> principalType, String name, IOException e) throws IOException {
        switch (this.unsupportedAttributePolicy) {
            case Ignore: {
                break;
            }
            case Warn: {
                this.log.warn("handleUserPrincipalLookupServiceException(" + principalType.getSimpleName() + "[" + name + "])" + " failed (" + e.getClass().getSimpleName() + "): " + e.getMessage());
                break;
            }
            case ThrowException: {
                throw e;
            }
            default: {
                this.log.warn("Unknown policy for principal=" + principalType.getSimpleName() + "[" + name + "]: " + (Object)((Object)this.unsupportedAttributePolicy));
            }
        }
    }

    protected Map<String, Object> readAttrs(Buffer buffer) throws IOException {
        return SftpHelper.readAttrs(this.version, buffer);
    }

    protected <H extends Handle> H validateHandle(String handle, Handle h, Class<H> type) throws IOException {
        if (h == null) {
            throw new FileNotFoundException("No such current handle: " + handle);
        }
        Class<?> t = h.getClass();
        if (!type.isAssignableFrom(t)) {
            throw new InvalidHandleException(handle, h, type);
        }
        return (H)((Handle)type.cast(h));
    }

    protected void sendStatus(Buffer buffer, int id, Exception e) throws IOException {
        int substatus = SftpHelper.resolveSubstatus(e);
        this.sendStatus(buffer, id, substatus, e.toString());
    }

    protected void sendStatus(Buffer buffer, int id, int substatus, String msg) throws IOException {
        this.sendStatus(buffer, id, substatus, msg != null ? msg : "", "");
    }

    protected void sendStatus(Buffer buffer, int id, int substatus, String msg, String lang) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Send SSH_FXP_STATUS (substatus={}, lang={}, msg={})", new Object[]{substatus, lang, msg});
        }
        buffer.putByte((byte)101);
        buffer.putInt(id);
        buffer.putInt(substatus);
        buffer.putString(msg);
        buffer.putString(lang);
        this.send(buffer);
    }

    protected void send(Buffer buffer) throws IOException {
        int len = buffer.available();
        BufferUtils.writeInt(this.out, len, this.workBuf, 0, this.workBuf.length);
        this.out.write(buffer.array(), buffer.rpos(), len);
        this.out.flush();
    }

    @Override
    public void destroy() {
        if (!this.closed) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("destroy() - mark as closed");
            }
            this.closed = true;
            if (this.pendingFuture != null && !this.pendingFuture.isDone()) {
                boolean result = this.pendingFuture.cancel(true);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("destroy() - cancel pending future=" + result);
                }
            }
            this.pendingFuture = null;
            if (this.executors != null && !this.executors.isShutdown() && this.shutdownExecutor) {
                List<Runnable> runners = this.executors.shutdownNow();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("destroy() - shutdown executor service - runners count=" + runners.size());
                }
            }
            this.executors = null;
            try {
                this.fileSystem.close();
            }
            catch (UnsupportedOperationException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Closing the file system is not supported");
                }
            }
            catch (IOException e) {
                this.log.debug("Error closing FileSystem", (Throwable)e);
            }
        }
    }

    protected Path resolveNormalizedLocation(String remotePath) throws IOException, InvalidPathException {
        return this.normalize(this.resolveFile(remotePath));
    }

    protected Path normalize(Path f) {
        if (f == null) {
            return null;
        }
        Path abs = f.isAbsolute() ? f : f.toAbsolutePath();
        return abs.normalize();
    }

    protected Path resolveFile(String remotePath) throws IOException, InvalidPathException {
        String path = SelectorUtils.translateToLocalFileSystemPath(remotePath, '/', this.defaultDir.getFileSystem());
        Path p = this.defaultDir.resolve(path);
        if (this.log.isTraceEnabled()) {
            this.log.trace("resolveFile({}) {}", (Object)remotePath, (Object)p);
        }
        return p;
    }

    static {
        DEFAULT_SUPPORTED_CLIENT_EXTENSIONS = Collections.unmodifiableSet(GenericUtils.asSortedSet(String.CASE_INSENSITIVE_ORDER, Arrays.asList("version-select", "copy-file", "md5-hash", "md5-hash-handle", "check-file-handle", "check-file-name", "copy-data", "space-available")));
        DEFAULT_OPEN_SSH_EXTENSIONS = Collections.unmodifiableList(Arrays.asList(new AbstractOpenSSHExtensionParser.OpenSSHExtension("fsync@openssh.com", "1")));
        DEFAULT_OPEN_SSH_EXTENSIONS_NAMES = Collections.unmodifiableList(new ArrayList<String>(DEFAULT_OPEN_SSH_EXTENSIONS.size()){
            private static final long serialVersionUID = 1L;
            {
                for (AbstractOpenSSHExtensionParser.OpenSSHExtension ext : DEFAULT_OPEN_SSH_EXTENSIONS) {
                    this.add(ext.getName());
                }
            }
        });
        DEFAULT_UNIX_VIEW = Collections.singletonList("unix:*");
        FILEATTRS_RESOLVERS = Collections.unmodifiableMap(new TreeMap<String, FileInfoExtractor<?>>(String.CASE_INSENSITIVE_ORDER){
            private static final long serialVersionUID = 1L;
            {
                this.put("isRegularFile", FileInfoExtractor.ISREG);
                this.put("isDirectory", FileInfoExtractor.ISDIR);
                this.put("isSymbolicLink", FileInfoExtractor.ISSYMLINK);
                this.put("permissions", FileInfoExtractor.PERMISSIONS);
                this.put("size", FileInfoExtractor.SIZE);
                this.put("lastModifiedTime", FileInfoExtractor.LASTMODIFIED);
            }
        });
        StringBuilder sb = new StringBuilder(8);
        for (int v = 3; v <= 6; ++v) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(v);
        }
        ALL_SFTP_IMPL = sb.toString();
    }
}

