/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.subsystem.sftp;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import org.apache.sshd.server.subsystem.sftp.Handle;

public class DirectoryHandle
extends Handle
implements Iterator<Path> {
    private boolean done;
    private boolean sendDotDot;
    private boolean sendDot = true;
    private DirectoryStream<Path> ds;
    private Iterator<Path> fileList;

    public DirectoryHandle(Path file) throws IOException {
        super(file);
        this.ds = Files.newDirectoryStream(file);
        Path parent = file.getParent();
        this.sendDotDot = parent != null;
        this.fileList = this.ds.iterator();
    }

    public boolean isDone() {
        return this.done;
    }

    public void markDone() {
        this.done = true;
        this.fileList = null;
    }

    public boolean isSendDot() {
        return this.sendDot;
    }

    public void markDotSent() {
        this.sendDot = false;
    }

    public boolean isSendDotDot() {
        return this.sendDotDot;
    }

    public void markDotDotSent() {
        this.sendDotDot = false;
    }

    @Override
    public boolean hasNext() {
        return this.fileList.hasNext();
    }

    @Override
    public Path next() {
        return this.fileList.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not allowed to remove " + this.toString());
    }

    @Override
    public void close() throws IOException {
        this.markDone();
        this.ds.close();
    }
}

