/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.session;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.common.FactoryManagerUtils;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.Service;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.CloseableUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.auth.UserAuth;
import org.apache.sshd.server.session.ServerSession;

public class ServerUserAuthService
extends CloseableUtils.AbstractCloseable
implements Service {
    public static final int DEFAULT_MAX_AUTH_REQUESTS = 20;
    private final ServerSession session;
    private List<NamedFactory<UserAuth>> userAuthFactories;
    private List<List<String>> authMethods;
    private String authUserName;
    private String authMethod;
    private String authService;
    private UserAuth currentAuth;
    private int maxAuthRequests;
    private int nbAuthRequests;

    public ServerUserAuthService(Session s) throws SshException {
        ValidateUtils.checkTrue(s instanceof ServerSession, "Server side service used on client side");
        if (s.isAuthenticated()) {
            throw new SshException("Session already authenticated");
        }
        this.session = (ServerSession)s;
        this.maxAuthRequests = this.session.getIntProperty("max-auth-requests", 20);
        ServerFactoryManager manager = this.getFactoryManager();
        this.userAuthFactories = new ArrayList<NamedFactory<UserAuth>>(manager.getUserAuthFactories());
        this.authMethods = new ArrayList<List<String>>();
        String mths = FactoryManagerUtils.getString(manager, "auth-methods");
        if (GenericUtils.isEmpty(mths)) {
            for (NamedFactory namedFactory : manager.getUserAuthFactories()) {
                this.authMethods.add(new ArrayList<String>(Collections.singletonList(namedFactory.getName())));
            }
        } else {
            for (String mthl : mths.split("\\s")) {
                this.authMethods.add(new ArrayList<String>(Arrays.asList(mthl.split(","))));
            }
        }
        for (List list : this.authMethods) {
            for (String m : list) {
                NamedFactory<UserAuth> factory = NamedResource.Utils.findByName(m, String.CASE_INSENSITIVE_ORDER, this.userAuthFactories);
                if (factory != null) continue;
                throw new SshException("Configured method is not supported: " + m);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Authorized authentication methods: {}", (Object)NamedResource.Utils.getNames(this.userAuthFactories));
        }
    }

    @Override
    public void start() {
    }

    @Override
    public ServerSession getSession() {
        return this.session;
    }

    @Override
    public void process(int cmd, Buffer buffer) throws Exception {
        String username;
        Boolean authed = Boolean.FALSE;
        if (cmd == 50) {
            NamedFactory<UserAuth> namedFactory;
            this.log.debug("Received SSH_MSG_USERAUTH_REQUEST");
            if (this.currentAuth != null) {
                this.currentAuth.destroy();
                this.currentAuth = null;
            }
            username = buffer.getString();
            String service = buffer.getString();
            String method = buffer.getString();
            if (this.authUserName == null || this.authService == null) {
                this.authUserName = username;
                this.authService = service;
            } else if (!this.authUserName.equals(username) || !this.authService.equals(service)) {
                this.session.disconnect(2, "Change of username or service is not allowed (" + this.authUserName + ", " + this.authService + ") -> (" + username + ", " + service + ")");
                return;
            }
            this.authMethod = method;
            if (this.nbAuthRequests++ > this.maxAuthRequests) {
                this.session.disconnect(2, "Too many authentication failures");
                return;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Authenticating user '{}' with service '{}' and method '{}'", new Object[]{username, service, method});
            }
            if ((namedFactory = NamedResource.Utils.findByName(method, String.CASE_INSENSITIVE_ORDER, this.userAuthFactories)) != null) {
                this.currentAuth = (UserAuth)namedFactory.create();
                try {
                    authed = this.currentAuth.auth(this.session, username, service, buffer);
                }
                catch (Exception exception) {
                    this.log.debug("Authentication failed: {}", (Object)exception.getMessage());
                }
            }
        } else {
            if (this.currentAuth == null) {
                throw new IllegalStateException("No current authentication mechanism for cmd=" + (cmd & 0xFF));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Received authentication message {}", (Object)(cmd & 0xFF));
            }
            buffer.rpos(buffer.rpos() - 1);
            try {
                authed = this.currentAuth.next(buffer);
            }
            catch (Exception e) {
                this.log.debug("Failed ({}) to authenticate: {}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
            }
        }
        if (authed == null) {
            this.log.debug("Authentication not finished");
        } else if (authed.booleanValue()) {
            this.log.debug("Authentication succeeded");
            username = this.currentAuth.getUserName();
            boolean success = false;
            for (List list : this.authMethods) {
                if (GenericUtils.size(list) <= 0 || !((String)list.get(0)).equals(this.authMethod)) continue;
                list.remove(0);
                success |= list.isEmpty();
            }
            if (success) {
                int n;
                ServerFactoryManager manager = this.getFactoryManager();
                Integer n2 = FactoryManagerUtils.getInteger(manager, "max-concurrent-sessions");
                if (n2 != null && (n = this.session.getActiveSessionCountForUser(username)) >= n2) {
                    this.session.disconnect(7, "Too many concurrent connections (" + n + ") - max. allowed: " + n2);
                    return;
                }
                String string = FactoryManagerUtils.getString(manager, "welcome-banner");
                if (string != null) {
                    buffer = this.session.createBuffer((byte)53);
                    buffer.putString(string);
                    buffer.putString("en");
                    this.session.writePacket(buffer);
                }
                buffer = this.session.createBuffer((byte)52);
                this.session.writePacket(buffer);
                this.session.setUsername(username);
                this.session.setAuthenticated();
                this.session.startService(this.authService);
                this.session.resetIdleTimeout();
                this.log.info("Session {}@{} authenticated", (Object)username, (Object)this.session.getIoSession().getRemoteAddress());
            } else {
                buffer = this.session.createBuffer((byte)51);
                StringBuilder sb = new StringBuilder();
                for (List<String> list : this.authMethods) {
                    if (GenericUtils.size(list) <= 0) continue;
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(list.get(0));
                }
                buffer.putString(sb.toString());
                buffer.putBoolean(true);
                this.session.writePacket(buffer);
            }
            this.currentAuth.destroy();
            this.currentAuth = null;
        } else {
            this.log.debug("Authentication failed");
            buffer = this.session.createBuffer((byte)51);
            StringBuilder sb = new StringBuilder();
            for (List<String> l : this.authMethods) {
                String string;
                if (GenericUtils.size(l) <= 0 || "none".equals(string = l.get(0))) continue;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(l.get(0));
            }
            buffer.putString(sb.toString());
            buffer.putByte((byte)0);
            this.session.writePacket(buffer);
            if (this.currentAuth != null) {
                this.currentAuth.destroy();
                this.currentAuth = null;
            }
        }
    }

    private ServerFactoryManager getFactoryManager() {
        return this.session.getFactoryManager();
    }
}

