/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.session;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.FactoryManagerUtils;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.ServiceFactory;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.IoService;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.kex.KexState;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.session.AbstractSession;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.session.ServerSession;

public class ServerSessionImpl
extends AbstractSession
implements ServerSession {
    protected static final long MAX_PACKETS = 0x80000000L;
    private long maxBytes = Math.max(32L, this.getLongProperty("rekey-bytes-limit", this.maxBytes));
    private long maxKeyInterval = this.getLongProperty("rekey-time-limit", this.maxKeyInterval);

    public ServerSessionImpl(ServerFactoryManager server, IoSession ioSession) throws Exception {
        super(true, server, ioSession);
        this.log.info("Server session created from {}", (Object)ioSession.getRemoteAddress());
        this.sendServerIdentification();
    }

    @Override
    public ServerFactoryManager getFactoryManager() {
        return (ServerFactoryManager)this.factoryManager;
    }

    @Override
    protected void checkKeys() {
    }

    @Override
    public void startService(String name) throws Exception {
        this.currentService = ServiceFactory.Utils.create(this.getFactoryManager().getServiceFactories(), name, this);
    }

    @Override
    protected void serviceAccept() throws IOException {
        this.disconnect(2, "Unsupported packet: SSH_MSG_SERVICE_ACCEPT");
    }

    @Override
    protected void checkRekey() throws IOException {
        if (KexState.DONE.equals(this.kexState.get())) {
            long now = System.currentTimeMillis();
            if (this.inPacketsCount.get() > 0x80000000L || this.outPacketsCount.get() > 0x80000000L || this.inBytesCount.get() > this.maxBytes || this.outBytesCount.get() > this.maxBytes || this.maxKeyInterval > 0L && now - this.lastKeyTimeValue.get() > this.maxKeyInterval) {
                this.reExchangeKeys();
            }
        }
    }

    protected void sendServerIdentification() {
        ServerFactoryManager manager = this.getFactoryManager();
        String ident = FactoryManagerUtils.getString(manager, "server-identification");
        this.serverVersion = GenericUtils.isEmpty(ident) ? "SSH-2.0-" + manager.getVersion() : "SSH-2.0-" + ident;
        this.sendIdentification(this.serverVersion);
    }

    @Override
    protected byte[] sendKexInit(Map<KexProposalOption, String> proposal) throws IOException {
        this.mergeProposals(this.serverProposal, proposal);
        return super.sendKexInit(proposal);
    }

    @Override
    protected void setKexSeed(byte ... seed) {
        this.i_s = ValidateUtils.checkNotNullAndNotEmpty(seed, "No KEX seed", new Object[0]);
    }

    @Override
    protected String resolveAvailableSignaturesProposal(FactoryManager manager) {
        Iterable<String> provided;
        KeyPairProvider kpp = manager.getKeyPairProvider();
        List<String> supported = NamedResource.Utils.getNameList(manager.getSignatureFactories());
        Iterable<String> iterable = provided = kpp == null ? null : kpp.getKeyTypes();
        if (provided == null || GenericUtils.isEmpty(supported)) {
            return this.resolveEmptySignaturesProposal(supported, provided);
        }
        StringBuilder resolveKeys = null;
        for (String keyType : provided) {
            if (!supported.contains(keyType)) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("resolveAvailableSignaturesProposal(" + provided + ") " + keyType + " not in list of supported: " + supported);
                continue;
            }
            if (resolveKeys == null) {
                resolveKeys = new StringBuilder(supported.size() * 16);
            }
            if (resolveKeys.length() > 0) {
                resolveKeys.append(',');
            }
            resolveKeys.append(keyType);
        }
        if (GenericUtils.isEmpty(resolveKeys)) {
            return this.resolveEmptySignaturesProposal(supported, provided);
        }
        return resolveKeys.toString();
    }

    protected String resolveEmptySignaturesProposal(Iterable<String> supported, Iterable<String> provided) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("resolveEmptySignaturesProposal({}) none of the keys appears in supported list: {}", provided, supported);
        }
        return null;
    }

    @Override
    protected boolean readIdentification(Buffer buffer) throws IOException {
        this.clientVersion = this.doReadIdentification(buffer, true);
        if (GenericUtils.isEmpty(this.clientVersion)) {
            return false;
        }
        this.log.debug("Client version string: {}", (Object)this.clientVersion);
        if (!this.clientVersion.startsWith("SSH-2.0-")) {
            String msg = "Unsupported protocol version: " + this.clientVersion;
            this.ioSession.write(new ByteArrayBuffer((msg + "\n").getBytes(StandardCharsets.UTF_8))).addListener(new SshFutureListener<IoWriteFuture>(){

                @Override
                public void operationComplete(IoWriteFuture future) {
                    ServerSessionImpl.this.close(true);
                }
            });
            throw new SshException(msg);
        }
        this.kexState.set(KexState.INIT);
        this.sendKexInit();
        return true;
    }

    @Override
    protected void receiveKexInit(Map<KexProposalOption, String> proposal, byte[] seed) throws IOException {
        this.mergeProposals(this.clientProposal, proposal);
        this.i_c = seed;
    }

    @Override
    public KeyPair getHostKey() {
        String value = this.getNegotiatedKexParameter(KexProposalOption.SERVERKEYS);
        KeyPairProvider provider = ValidateUtils.checkNotNull(this.factoryManager.getKeyPairProvider(), "No host keys provider");
        return provider.loadKey(value);
    }

    @Override
    public int getActiveSessionCountForUser(String userName) {
        if (GenericUtils.isEmpty(userName)) {
            return 0;
        }
        IoService service = this.ioSession.getService();
        Map<Long, IoSession> sessionsMap = service.getManagedSessions();
        if (GenericUtils.isEmpty(sessionsMap)) {
            return 0;
        }
        int totalCount = 0;
        for (IoSession is : sessionsMap.values()) {
            String sessionUser;
            ServerSession session = (ServerSession)((Object)ServerSessionImpl.getSession(is, true));
            if (session == null || GenericUtils.isEmpty(sessionUser = session.getUsername()) || !Objects.equals(sessionUser, userName)) continue;
            ++totalCount;
        }
        return totalCount;
    }

    public long getId() {
        return this.ioSession.getId();
    }
}

