/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.kex;

import java.security.KeyPair;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.kex.AbstractDH;
import org.apache.sshd.common.kex.DHFactory;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.kex.KeyExchange;
import org.apache.sshd.common.kex.KeyExchangeFactory;
import org.apache.sshd.common.session.AbstractSession;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.kex.AbstractDHServerKeyExchange;

public class DHGServer
extends AbstractDHServerKeyExchange {
    protected final DHFactory factory;
    protected AbstractDH dh;

    protected DHGServer(DHFactory factory) {
        this.factory = ValidateUtils.checkNotNull(factory, "No factory");
    }

    public static KeyExchangeFactory newFactory(final DHFactory factory) {
        return new KeyExchangeFactory(){

            @Override
            public KeyExchange create() {
                return new DHGServer(factory);
            }

            @Override
            public String getName() {
                return factory.getName();
            }

            public String toString() {
                return NamedFactory.class.getSimpleName() + "<" + KeyExchange.class.getSimpleName() + ">" + "[" + this.getName() + "]";
            }
        };
    }

    @Override
    public void init(AbstractSession s, byte[] v_s, byte[] v_c, byte[] i_s, byte[] i_c) throws Exception {
        super.init(s, v_s, v_c, i_s, i_c);
        this.dh = this.factory.create(new Object[0]);
        this.hash = this.dh.getHash();
        this.hash.init();
        this.f = this.dh.getE();
    }

    @Override
    public boolean next(Buffer buffer) throws Exception {
        int cmd = buffer.getUByte();
        if (cmd != 30) {
            throw new SshException(3, "Protocol error: expected packet 30, got " + cmd);
        }
        this.log.debug("Received SSH_MSG_KEXDH_INIT");
        this.e = buffer.getMPIntAsBytes();
        this.dh.setF(this.e);
        this.k = this.dh.getK();
        KeyPair kp = ValidateUtils.checkNotNull(this.session.getHostKey(), "No server key pair available");
        String algo = this.session.getNegotiatedKexParameter(KexProposalOption.SERVERKEYS);
        ServerFactoryManager manager = this.session.getFactoryManager();
        Signature sig = ValidateUtils.checkNotNull(NamedFactory.Utils.create(manager.getSignatureFactories(), algo), "Unknown negotiated server keys: %s", (Object)algo);
        sig.initSigner(kp.getPrivate());
        buffer = new ByteArrayBuffer();
        buffer.putRawPublicKey(kp.getPublic());
        byte[] k_s = buffer.getCompactData();
        buffer.clear();
        buffer.putBytes(this.v_c);
        buffer.putBytes(this.v_s);
        buffer.putBytes(this.i_c);
        buffer.putBytes(this.i_s);
        buffer.putBytes(k_s);
        buffer.putMPInt(this.e);
        buffer.putMPInt(this.f);
        buffer.putMPInt(this.k);
        this.hash.update(buffer.array(), 0, buffer.available());
        this.h = this.hash.digest();
        buffer.clear();
        sig.update(this.h, 0, this.h.length);
        buffer.putString(algo);
        buffer.putBytes(sig.sign());
        byte[] sigH = buffer.getCompactData();
        if (this.log.isDebugEnabled()) {
            this.log.debug("K_S:  {}", (Object)BufferUtils.printHex(k_s));
            this.log.debug("f:    {}", (Object)BufferUtils.printHex(this.f));
            this.log.debug("sigH: {}", (Object)BufferUtils.printHex(sigH));
        }
        this.log.debug("Send SSH_MSG_KEXDH_REPLY");
        buffer.clear();
        buffer.rpos(5);
        buffer.wpos(5);
        buffer.putByte((byte)31);
        buffer.putBytes(k_s);
        buffer.putBytes(this.f);
        buffer.putBytes(sigH);
        this.session.writePacket(buffer);
        return true;
    }
}

