/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public enum Signal {
    HUP(1),
    INT(2),
    QUIT(3),
    ILL(4),
    TRAP(5),
    IOT(6),
    BUS(7),
    FPE(8),
    KILL(9),
    USR1(10),
    SEGV(11),
    USR2(12),
    PIPE(13),
    ALRM(14),
    TERM(15),
    STKFLT(16),
    CHLD(17),
    CONT(18),
    STOP(19),
    TSTP(20),
    TTIN(21),
    TTOU(22),
    URG(23),
    XCPU(24),
    XFSZ(25),
    VTALRM(26),
    PROF(27),
    WINCH(28),
    IO(29),
    PWR(30);

    public static final Set<Signal> SIGNALS;
    private static final Map<String, Signal> LOOKUP_TABLE;
    private final int numeric;

    private Signal(int numeric) {
        this.numeric = numeric;
    }

    public static Signal get(String name) {
        return LOOKUP_TABLE.get(name);
    }

    public int getNumeric() {
        return this.numeric;
    }

    static {
        SIGNALS = Collections.unmodifiableSet(EnumSet.allOf(Signal.class));
        LOOKUP_TABLE = new HashMap<String, Signal>(40);
        for (Signal s : Signal.values()) {
            LOOKUP_TABLE.put(s.name(), s);
        }
    }
}

