/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.OsUtils;

public final class IoUtils {
    public static final OpenOption[] EMPTY_OPEN_OPTIONS = new OpenOption[0];
    public static final CopyOption[] EMPTY_COPY_OPTIONS = new CopyOption[0];
    public static final LinkOption[] EMPTY_LINK_OPTIONS = new LinkOption[0];
    public static final List<String> WINDOWS_EXECUTABLE_EXTENSIONS = Collections.unmodifiableList(Arrays.asList(".bat", ".exe", ".cmd"));
    public static final int DEFAULT_COPY_SIZE = 8192;
    private static final LinkOption[] NO_FOLLOW_OPTIONS = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};

    private IoUtils() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static LinkOption[] getLinkOptions(boolean followLinks) {
        if (followLinks) {
            return EMPTY_LINK_OPTIONS;
        }
        return (LinkOption[])NO_FOLLOW_OPTIONS.clone();
    }

    public static long copy(InputStream source, OutputStream sink) throws IOException {
        return IoUtils.copy(source, sink, 8192);
    }

    public static long copy(InputStream source, OutputStream sink, int bufferSize) throws IOException {
        int n;
        long nread = 0L;
        byte[] buf = new byte[bufferSize];
        while ((n = source.read(buf)) > 0) {
            sink.write(buf, 0, n);
            nread += (long)n;
        }
        return nread;
    }

    public static void closeQuietly(Closeable ... closeables) {
        for (Closeable c : closeables) {
            try {
                if (c == null) continue;
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static boolean isWindowsExecutable(String fileName) {
        if (fileName == null || fileName.length() <= 0) {
            return false;
        }
        for (String suffix : WINDOWS_EXECUTABLE_EXTENSIONS) {
            if (!fileName.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public static Set<PosixFilePermission> getPermissions(Path path, LinkOption ... options) throws IOException {
        FileSystem fs = path.getFileSystem();
        Set<String> views = fs.supportedFileAttributeViews();
        if (views.contains("posix")) {
            return Files.getPosixFilePermissions(path, options);
        }
        return IoUtils.getPermissionsFromFile(path.toFile());
    }

    public static Set<PosixFilePermission> getPermissionsFromFile(File f) {
        EnumSet<PosixFilePermission> perms = EnumSet.noneOf(PosixFilePermission.class);
        if (f.canRead()) {
            perms.add(PosixFilePermission.OWNER_READ);
            perms.add(PosixFilePermission.GROUP_READ);
            perms.add(PosixFilePermission.OTHERS_READ);
        }
        if (f.canWrite()) {
            perms.add(PosixFilePermission.OWNER_WRITE);
            perms.add(PosixFilePermission.GROUP_WRITE);
            perms.add(PosixFilePermission.OTHERS_WRITE);
        }
        if (f.canExecute() || OsUtils.isWin32() && IoUtils.isWindowsExecutable(f.getName())) {
            perms.add(PosixFilePermission.OWNER_EXECUTE);
            perms.add(PosixFilePermission.GROUP_EXECUTE);
            perms.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return perms;
    }

    public static void setPermissions(Path path, Set<PosixFilePermission> perms) throws IOException {
        FileSystem fs = path.getFileSystem();
        Set<String> views = fs.supportedFileAttributeViews();
        if (views.contains("posix")) {
            Files.setPosixFilePermissions(path, perms);
        } else {
            IoUtils.setPermissionsToFile(path.toFile(), perms);
        }
    }

    public static void setPermissionsToFile(File f, Collection<PosixFilePermission> perms) {
        boolean readable = perms != null && (perms.contains((Object)PosixFilePermission.OWNER_READ) || perms.contains((Object)PosixFilePermission.GROUP_READ) || perms.contains((Object)PosixFilePermission.OTHERS_READ));
        f.setReadable(readable, false);
        boolean writable = perms != null && (perms.contains((Object)PosixFilePermission.OWNER_WRITE) || perms.contains((Object)PosixFilePermission.GROUP_WRITE) || perms.contains((Object)PosixFilePermission.OTHERS_WRITE));
        f.setWritable(writable, false);
        boolean executable = perms != null && (perms.contains((Object)PosixFilePermission.OWNER_EXECUTE) || perms.contains((Object)PosixFilePermission.GROUP_EXECUTE) || perms.contains((Object)PosixFilePermission.OTHERS_EXECUTE));
        f.setExecutable(executable, false);
    }

    public static Boolean checkFileExists(Path path, LinkOption ... options) {
        if (Files.exists(path, options)) {
            return Boolean.TRUE;
        }
        if (Files.notExists(path, options)) {
            return Boolean.FALSE;
        }
        return null;
    }

    public static void readFully(InputStream input, byte[] buffer) throws IOException {
        IoUtils.readFully(input, buffer, 0, buffer.length);
    }

    public static void readFully(InputStream input, byte[] buffer, int offset, int length) throws IOException {
        int actual = IoUtils.read(input, buffer, offset, length);
        if (actual != length) {
            throw new EOFException("Premature EOF - expected=" + length + ", actual=" + actual);
        }
    }

    public static int read(InputStream input, byte[] buffer) throws IOException {
        return IoUtils.read(input, buffer, 0, buffer.length);
    }

    public static int read(InputStream input, byte[] buffer, int offset, int length) throws IOException {
        int remaining = length;
        int curOffset = offset;
        while (remaining > 0) {
            int count = input.read(buffer, curOffset, remaining);
            if (count == -1) {
                return curOffset - offset;
            }
            remaining -= count;
            curOffset += count;
        }
        return length;
    }

    public static PosixFilePermission validateExcludedPermissions(Collection<PosixFilePermission> perms, Collection<PosixFilePermission> excluded) {
        if (GenericUtils.isEmpty(perms) || GenericUtils.isEmpty(excluded)) {
            return null;
        }
        for (PosixFilePermission p : excluded) {
            if (!perms.contains((Object)p)) continue;
            return p;
        }
        return null;
    }

    public static Path ensureDirectory(Path path, LinkOption ... options) {
        if (!Files.isDirectory(path, options)) {
            throw new UnsupportedOperationException("Not a directory: " + path);
        }
        return path;
    }

    public static boolean followLinks(LinkOption ... options) {
        if (GenericUtils.isEmpty(options)) {
            return true;
        }
        for (LinkOption localLinkOption : options) {
            if (localLinkOption != LinkOption.NOFOLLOW_LINKS) continue;
            return false;
        }
        return true;
    }
}

