/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.buffer;

import java.nio.charset.Charset;
import org.apache.sshd.common.util.Int2IntFunction;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferException;
import org.apache.sshd.common.util.buffer.BufferUtils;

public final class ByteArrayBuffer
extends Buffer {
    public static final int DEFAULT_SIZE = 256;
    public static final int MAX_LEN = 65536;
    private byte[] data;
    private int rpos;
    private int wpos;

    public ByteArrayBuffer() {
        this(256);
    }

    public ByteArrayBuffer(int size) {
        this(new byte[BufferUtils.getNextPowerOf2(size)], false);
    }

    public ByteArrayBuffer(byte[] data) {
        this(data, 0, data.length, true);
    }

    public ByteArrayBuffer(byte[] data, boolean read) {
        this(data, 0, data.length, read);
    }

    public ByteArrayBuffer(byte[] data, int off, int len) {
        this(data, off, len, true);
    }

    public ByteArrayBuffer(byte[] data, int off, int len, boolean read) {
        this.data = data;
        this.rpos = off;
        this.wpos = (read ? len : 0) + off;
    }

    @Override
    public int rpos() {
        return this.rpos;
    }

    @Override
    public void rpos(int rpos) {
        this.rpos = rpos;
    }

    @Override
    public int wpos() {
        return this.wpos;
    }

    @Override
    public void wpos(int wpos) {
        this.ensureCapacity(wpos - this.wpos);
        this.wpos = wpos;
    }

    @Override
    public int available() {
        return this.wpos - this.rpos;
    }

    @Override
    public int capacity() {
        return this.data.length - this.wpos;
    }

    @Override
    public byte[] array() {
        return this.data;
    }

    @Override
    public void compact() {
        if (this.available() > 0) {
            System.arraycopy(this.data, this.rpos, this.data, 0, this.wpos - this.rpos);
        }
        this.wpos -= this.rpos;
        this.rpos = 0;
    }

    @Override
    public void clear() {
        this.rpos = 0;
        this.wpos = 0;
    }

    @Override
    public byte getByte() {
        this.ensureAvailable(1);
        return this.data[this.rpos++];
    }

    @Override
    public void putByte(byte b) {
        this.ensureCapacity(1);
        this.data[this.wpos++] = b;
    }

    @Override
    public int putBuffer(Readable buffer, boolean expand) {
        int r = expand ? buffer.available() : Math.min(buffer.available(), this.capacity());
        this.ensureCapacity(r);
        buffer.getRawBytes(this.data, this.wpos, r);
        this.wpos += r;
        return r;
    }

    @Override
    public void putRawBytes(byte[] d, int off, int len) {
        this.ensureCapacity(len);
        System.arraycopy(d, off, this.data, this.wpos, len);
        this.wpos += len;
    }

    @Override
    public String getString(Charset charset) {
        int len = this.getInt();
        if (len < 0) {
            throw new BufferException("Bad item length: " + len);
        }
        this.ensureAvailable(len);
        String s = new String(this.data, this.rpos, len, charset);
        this.rpos += len;
        return s;
    }

    @Override
    public void getRawBytes(byte[] buf, int off, int len) {
        this.ensureAvailable(len);
        System.arraycopy(this.data, this.rpos, buf, off, len);
        this.rpos += len;
    }

    @Override
    public void ensureCapacity(int capacity, Int2IntFunction growthFactor) {
        int curPos;
        int maxSize = this.size();
        int remaining = maxSize - (curPos = this.wpos());
        if (remaining < capacity) {
            int minimum = curPos + capacity;
            int actual = growthFactor.apply(minimum);
            if (actual < minimum) {
                throw new IllegalStateException("ensureCapacity(" + capacity + ") actual (" + actual + ") below min. (" + minimum + ")");
            }
            byte[] tmp = new byte[actual];
            System.arraycopy(this.data, 0, tmp, 0, this.data.length);
            this.data = tmp;
        }
    }

    @Override
    protected int size() {
        return this.data.length;
    }
}

