/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.util.concurrent.Callable;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.keyprovider.AbstractClassLoadableResourceKeyPairProvider;
import org.apache.sshd.common.keyprovider.AbstractFileKeyPairProvider;
import org.apache.sshd.common.random.AbstractRandom;
import org.apache.sshd.common.random.JceRandomFactory;
import org.apache.sshd.common.random.Random;
import org.apache.sshd.common.random.RandomFactory;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.server.keyprovider.AbstractGeneratorHostKeyProvider;
import org.bouncycastle.crypto.prng.RandomGenerator;
import org.bouncycastle.crypto.prng.VMPCRandomGenerator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SecurityUtils {
    public static final String BOUNCY_CASTLE = "BC";
    private static final Logger LOG = LoggerFactory.getLogger(SecurityUtils.class);
    private static String securityProvider;
    private static Boolean registerBouncyCastle;
    private static boolean registrationDone;
    private static Boolean hasEcc;

    private SecurityUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static boolean hasEcc() {
        if (hasEcc == null) {
            try {
                SecurityUtils.getKeyPairGenerator("EC");
                hasEcc = Boolean.TRUE;
            }
            catch (Throwable t) {
                hasEcc = Boolean.FALSE;
            }
        }
        return hasEcc;
    }

    public static synchronized void setSecurityProvider(String securityProvider) {
        SecurityUtils.securityProvider = securityProvider;
        registrationDone = false;
    }

    public static synchronized void setRegisterBouncyCastle(boolean registerBouncyCastle) {
        SecurityUtils.registerBouncyCastle = registerBouncyCastle;
        registrationDone = false;
    }

    public static synchronized String getSecurityProvider() {
        SecurityUtils.register();
        return securityProvider;
    }

    public static synchronized boolean isBouncyCastleRegistered() {
        SecurityUtils.register();
        return BOUNCY_CASTLE.equals(securityProvider);
    }

    private static void register() {
        if (!registrationDone) {
            String prop;
            if (registerBouncyCastle == null && !GenericUtils.isEmpty(prop = System.getProperty("org.apache.sshd.registerBouncyCastle"))) {
                registerBouncyCastle = Boolean.valueOf(prop);
            }
            if (securityProvider == null && (registerBouncyCastle == null || registerBouncyCastle.booleanValue())) {
                try {
                    new BouncyCastleRegistration().call();
                }
                catch (Throwable t) {
                    if (registerBouncyCastle == null) {
                        LOG.info("BouncyCastle not registered, using the default JCE provider");
                    }
                    LOG.error("Failed to register BouncyCastle as the defaut JCE provider");
                    throw new RuntimeException("Failed to register BouncyCastle as the defaut JCE provider", t);
                }
            }
            registrationDone = true;
        }
    }

    public static KeyPair loadKeyPairIdentity(String resourceKey, InputStream inputStream, FilePasswordProvider provider) throws IOException, GeneralSecurityException {
        if (!SecurityUtils.isBouncyCastleRegistered()) {
            throw new NoSuchProviderException("BouncyCastle not registered");
        }
        return BouncyCastleInputStreamLoader.loadKeyPair(resourceKey, inputStream, provider);
    }

    public static AbstractFileKeyPairProvider createFileKeyPairProvider() {
        return new BouncyCastleFileKeyPairProvider();
    }

    public static AbstractClassLoadableResourceKeyPairProvider createClassLoadableResourceKeyPairProvider() {
        return new BouncyCastleClassLoadableResourceKeyPairProvider();
    }

    public static AbstractGeneratorHostKeyProvider createGeneratorHostKeyProvider(Path path) {
        return new BouncyCastleGeneratorHostKeyProvider(path);
    }

    public static RandomFactory getRandomFactory() {
        if (SecurityUtils.isBouncyCastleRegistered()) {
            return BouncyCastleRandomFactory.INSTANCE;
        }
        return JceRandomFactory.INSTANCE;
    }

    public static synchronized KeyFactory getKeyFactory(String algorithm) throws GeneralSecurityException {
        SecurityUtils.register();
        String providerName = SecurityUtils.getSecurityProvider();
        if (GenericUtils.isEmpty(providerName)) {
            return KeyFactory.getInstance(algorithm);
        }
        return KeyFactory.getInstance(algorithm, providerName);
    }

    public static synchronized Cipher getCipher(String transformation) throws GeneralSecurityException {
        SecurityUtils.register();
        String providerName = SecurityUtils.getSecurityProvider();
        if (GenericUtils.isEmpty(providerName)) {
            return Cipher.getInstance(transformation);
        }
        return Cipher.getInstance(transformation, providerName);
    }

    public static synchronized MessageDigest getMessageDigest(String algorithm) throws GeneralSecurityException {
        SecurityUtils.register();
        String providerName = SecurityUtils.getSecurityProvider();
        if (GenericUtils.isEmpty(providerName)) {
            return MessageDigest.getInstance(algorithm);
        }
        return MessageDigest.getInstance(algorithm, providerName);
    }

    public static synchronized KeyPairGenerator getKeyPairGenerator(String algorithm) throws GeneralSecurityException {
        SecurityUtils.register();
        String providerName = SecurityUtils.getSecurityProvider();
        if (GenericUtils.isEmpty(providerName)) {
            return KeyPairGenerator.getInstance(algorithm);
        }
        return KeyPairGenerator.getInstance(algorithm, providerName);
    }

    public static synchronized KeyAgreement getKeyAgreement(String algorithm) throws GeneralSecurityException {
        SecurityUtils.register();
        String providerName = SecurityUtils.getSecurityProvider();
        if (GenericUtils.isEmpty(providerName)) {
            return KeyAgreement.getInstance(algorithm);
        }
        return KeyAgreement.getInstance(algorithm, providerName);
    }

    public static synchronized Mac getMac(String algorithm) throws GeneralSecurityException {
        SecurityUtils.register();
        String providerName = SecurityUtils.getSecurityProvider();
        if (GenericUtils.isEmpty(providerName)) {
            return Mac.getInstance(algorithm);
        }
        return Mac.getInstance(algorithm, providerName);
    }

    public static synchronized Signature getSignature(String algorithm) throws GeneralSecurityException {
        SecurityUtils.register();
        String providerName = SecurityUtils.getSecurityProvider();
        if (GenericUtils.isEmpty(providerName)) {
            return Signature.getInstance(algorithm);
        }
        return Signature.getInstance(algorithm, providerName);
    }

    private static final class BouncyCastleRandom
    extends AbstractRandom {
        private final RandomGenerator random;

        public BouncyCastleRandom() {
            ValidateUtils.checkTrue(SecurityUtils.isBouncyCastleRegistered(), "BouncyCastle not registered");
            this.random = new VMPCRandomGenerator();
            byte[] seed = new SecureRandom().generateSeed(8);
            this.random.addSeedMaterial(seed);
        }

        @Override
        public void fill(byte[] bytes, int start, int len) {
            this.random.nextBytes(bytes, start, len);
        }

        @Override
        public int random(int n) {
            if (n > 0) {
                int val;
                int bits;
                if ((n & -n) == n) {
                    return (int)((long)n * (long)this.next(31) >> 31);
                }
                while ((bits = this.next(31)) - (val = bits % n) + (n - 1) < 0) {
                }
                return val;
            }
            throw new IllegalArgumentException("Limit must be positive: " + n);
        }

        private int next(int numBits) {
            int bytes = (numBits + 7) / 8;
            byte[] next = new byte[bytes];
            int ret = 0;
            this.random.nextBytes(next);
            for (int i = 0; i < bytes; ++i) {
                ret = next[i] & 0xFF | ret << 8;
            }
            return ret >>> bytes * 8 - numBits;
        }
    }

    private static final class BouncyCastleRandomFactory
    implements RandomFactory {
        private static final BouncyCastleRandomFactory INSTANCE = new BouncyCastleRandomFactory();

        private BouncyCastleRandomFactory() {
        }

        @Override
        public boolean isSupported() {
            return SecurityUtils.isBouncyCastleRegistered();
        }

        @Override
        public String getName() {
            return "bouncycastle";
        }

        @Override
        public Random create() {
            return new BouncyCastleRandom();
        }
    }

    private static final class BouncyCastleGeneratorHostKeyProvider
    extends AbstractGeneratorHostKeyProvider {
        private BouncyCastleGeneratorHostKeyProvider(Path path) {
            ValidateUtils.checkTrue(SecurityUtils.isBouncyCastleRegistered(), "BouncyCastle not registered");
            this.setPath(path);
        }

        @Override
        protected KeyPair doReadKeyPair(String resourceKey, InputStream inputStream) throws IOException, GeneralSecurityException {
            return BouncyCastleInputStreamLoader.loadKeyPair(resourceKey, inputStream, null);
        }

        @Override
        protected void doWriteKeyPair(String resourceKey, KeyPair kp, OutputStream outputStream) throws IOException, GeneralSecurityException {
            try (PEMWriter w = new PEMWriter((Writer)new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));){
                w.writeObject((Object)kp);
                w.flush();
            }
        }
    }

    private static final class BouncyCastleClassLoadableResourceKeyPairProvider
    extends AbstractClassLoadableResourceKeyPairProvider {
        private BouncyCastleClassLoadableResourceKeyPairProvider() {
            ValidateUtils.checkTrue(SecurityUtils.isBouncyCastleRegistered(), "BouncyCastle not registered");
        }

        @Override
        protected KeyPair doLoadKey(String resourceKey, InputStream inputStream, FilePasswordProvider provider) throws IOException, GeneralSecurityException {
            return BouncyCastleInputStreamLoader.loadKeyPair(resourceKey, inputStream, provider);
        }
    }

    private static final class BouncyCastleFileKeyPairProvider
    extends AbstractFileKeyPairProvider {
        private BouncyCastleFileKeyPairProvider() {
            ValidateUtils.checkTrue(SecurityUtils.isBouncyCastleRegistered(), "BouncyCastle not registered");
        }

        @Override
        protected KeyPair doLoadKey(String resourceKey, InputStream inputStream, FilePasswordProvider provider) throws IOException, GeneralSecurityException {
            return BouncyCastleInputStreamLoader.loadKeyPair(resourceKey, inputStream, provider);
        }
    }

    private static class BouncyCastleInputStreamLoader {
        private BouncyCastleInputStreamLoader() {
        }

        public static KeyPair loadKeyPair(String resourceKey, InputStream inputStream, FilePasswordProvider provider) throws IOException, GeneralSecurityException {
            Throwable throwable = null;
            try (PEMParser r = new PEMParser((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                KeyPair keyPair;
                Object o = r.readObject();
                JcaPEMKeyConverter pemConverter = new JcaPEMKeyConverter();
                pemConverter.setProvider(SecurityUtils.BOUNCY_CASTLE);
                if (o instanceof PEMEncryptedKeyPair) {
                    ValidateUtils.checkNotNull(provider, "No password provider for resource=%s", (Object)resourceKey);
                    String password = ValidateUtils.checkNotNullAndNotEmpty(provider.getPassword(resourceKey), "No password provided for resource=%s", (Object)resourceKey);
                    JcePEMDecryptorProviderBuilder decryptorBuilder = new JcePEMDecryptorProviderBuilder();
                    PEMDecryptorProvider pemDecryptor = decryptorBuilder.build(password.toCharArray());
                    o = ((PEMEncryptedKeyPair)o).decryptKeyPair(pemDecryptor);
                }
                if (o instanceof PEMKeyPair) {
                    keyPair = pemConverter.getKeyPair((PEMKeyPair)o);
                    return keyPair;
                }
                if (o instanceof KeyPair) {
                    keyPair = (KeyPair)o;
                    return keyPair;
                }
                try {
                    throw new IOException("Failed to read " + resourceKey + " - unknown result object: " + o);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    private static class BouncyCastleRegistration
    implements Callable<Void> {
        private BouncyCastleRegistration() {
        }

        @Override
        public Void call() throws Exception {
            if (Security.getProvider(SecurityUtils.BOUNCY_CASTLE) == null) {
                LOG.info("Trying to register BouncyCastle as a JCE provider");
                Security.addProvider((Provider)new BouncyCastleProvider());
                MessageDigest.getInstance("MD5", SecurityUtils.BOUNCY_CASTLE);
                KeyAgreement.getInstance("DH", SecurityUtils.BOUNCY_CASTLE);
                LOG.info("Registration succeeded");
            } else {
                LOG.info("BouncyCastle already registered as a JCE provider");
            }
            securityProvider = SecurityUtils.BOUNCY_CASTLE;
            return null;
        }
    }
}

