/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.sshd.common.util.ValidateUtils;

public final class GenericUtils {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final Comparator<String> CASE_SENSITIVE_ORDER = new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            if (s1 == s2) {
                return 0;
            }
            return s1.compareTo(s2);
        }
    };
    public static final String QUOTES = "\"'";
    private static final Comparator<Comparable> NATURAL_ORDER_COMPARATOR = new Comparator<Comparable>(){

        @Override
        public int compare(Comparable c1, Comparable c2) {
            return c1.compareTo(c2);
        }
    };

    private GenericUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static String trimToEmpty(String s) {
        if (s == null) {
            return "";
        }
        return s.trim();
    }

    public static int safeCompare(String s1, String s2, boolean caseSensitive) {
        if (s1 == s2) {
            return 0;
        }
        if (s1 == null) {
            return 1;
        }
        if (s2 == null) {
            return -1;
        }
        if (caseSensitive) {
            return s1.compareTo(s2);
        }
        return s1.compareToIgnoreCase(s2);
    }

    public static int length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    public static boolean isEmpty(CharSequence cs) {
        return GenericUtils.length(cs) <= 0;
    }

    public static String[] split(String s, char ch) {
        String v;
        if (GenericUtils.isEmpty(s)) {
            return EMPTY_STRING_ARRAY;
        }
        int lastPos = 0;
        int curPos = s.indexOf(ch);
        if (curPos < 0) {
            return new String[]{s};
        }
        LinkedList<String> values = new LinkedList<String>();
        do {
            v = s.substring(lastPos, curPos);
            values.add(v);
            lastPos = curPos + 1;
        } while (lastPos < s.length() && (curPos = s.indexOf(ch, lastPos)) >= lastPos && curPos < s.length());
        if (lastPos < s.length()) {
            v = s.substring(lastPos);
            values.add(v);
        }
        return values.toArray(new String[values.size()]);
    }

    public static <T> String join(T[] values, char ch) {
        return GenericUtils.join(GenericUtils.isEmpty(values) ? Collections.emptyList() : Arrays.asList(values), ch);
    }

    public static String join(Iterable<?> iter, char ch) {
        return GenericUtils.join(iter == null ? null : iter.iterator(), ch);
    }

    public static String join(Iterator<?> iter, char ch) {
        if (iter == null || !iter.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        do {
            Object o = iter.next();
            if (sb.length() > 0) {
                sb.append(ch);
            }
            sb.append(Objects.toString(o));
        } while (iter.hasNext());
        return sb.toString();
    }

    public static <T> String join(T[] values, CharSequence sep) {
        return GenericUtils.join(GenericUtils.isEmpty(values) ? Collections.emptyList() : Arrays.asList(values), sep);
    }

    public static String join(Iterable<?> iter, CharSequence sep) {
        return GenericUtils.join(iter == null ? null : iter.iterator(), sep);
    }

    public static String join(Iterator<?> iter, CharSequence sep) {
        if (iter == null || !iter.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        do {
            Object o = iter.next();
            if (sb.length() > 0) {
                sb.append(sep);
            }
            sb.append(Objects.toString(o));
        } while (iter.hasNext());
        return sb.toString();
    }

    public static int size(Collection<?> c) {
        return c == null ? 0 : c.size();
    }

    public static boolean isEmpty(Collection<?> c) {
        return GenericUtils.size(c) <= 0;
    }

    public static int size(Map<?, ?> m) {
        return m == null ? 0 : m.size();
    }

    public static boolean isEmpty(Map<?, ?> m) {
        return GenericUtils.size(m) <= 0;
    }

    public static boolean isEmpty(byte[] a) {
        return GenericUtils.length(a) <= 0;
    }

    public static int length(byte ... a) {
        return a == null ? 0 : a.length;
    }

    @SafeVarargs
    public static <T> int length(T ... a) {
        return a == null ? 0 : a.length;
    }

    public static <T> boolean isEmpty(Iterable<? extends T> iter) {
        if (iter == null) {
            return true;
        }
        if (iter instanceof Collection) {
            return GenericUtils.isEmpty((Collection)iter);
        }
        return GenericUtils.isEmpty(iter.iterator());
    }

    public static <T> boolean isEmpty(Iterator<? extends T> iter) {
        return iter == null || !iter.hasNext();
    }

    @SafeVarargs
    public static <T> boolean isEmpty(T ... a) {
        return GenericUtils.length(a) <= 0;
    }

    @SafeVarargs
    public static <E extends Enum<E>> Set<E> of(E ... values) {
        return GenericUtils.of(GenericUtils.isEmpty(values) ? Collections.emptySet() : Arrays.asList(values));
    }

    public static <E extends Enum<E>> Set<E> of(Collection<? extends E> values) {
        if (GenericUtils.isEmpty(values)) {
            return Collections.emptySet();
        }
        EnumSet<Enum> result = null;
        for (Enum v : values) {
            if (result == null) {
                result = EnumSet.of(v);
                continue;
            }
            result.add(v);
        }
        return result;
    }

    public static <V extends Comparable<V>> Comparator<V> naturalComparator() {
        return NATURAL_ORDER_COMPARATOR;
    }

    public static <V extends Comparable<V>> SortedSet<V> asSortedSet(Collection<? extends V> values) {
        return GenericUtils.asSortedSet(GenericUtils.naturalComparator(), values);
    }

    public static <V> SortedSet<V> asSortedSet(Comparator<? super V> comp, Collection<? extends V> values) {
        TreeSet<V> set = new TreeSet<V>(ValidateUtils.checkNotNull(comp, "No comparator"));
        if (GenericUtils.size(values) > 0) {
            set.addAll(values);
        }
        return set;
    }

    public static CharSequence stripQuotes(CharSequence s) {
        if (GenericUtils.isEmpty(s)) {
            return s;
        }
        for (int index = 0; index < QUOTES.length(); ++index) {
            char delim = QUOTES.charAt(index);
            CharSequence v = GenericUtils.stripDelimiters(s, delim);
            if (v == s) continue;
            return v;
        }
        return s;
    }

    public static CharSequence stripDelimiters(CharSequence s, char delim) {
        if (GenericUtils.isEmpty(s) || s.length() < 2) {
            return s;
        }
        int lastPos = s.length() - 1;
        if (s.charAt(0) != delim || s.charAt(lastPos) != delim) {
            return s;
        }
        return s.subSequence(1, lastPos);
    }

    public static Throwable resolveExceptionCause(Throwable t) {
        if (t == null) {
            return t;
        }
        Throwable c = t.getCause();
        if (c == null) {
            return t;
        }
        return c;
    }

    public static <T extends Throwable> T accumulateException(T current, T extra) {
        if (current == null) {
            return extra;
        }
        if (extra == null || extra == current) {
            return current;
        }
        current.addSuppressed(extra);
        return current;
    }

    public static int hashCode(long value) {
        return (int)(value ^ value >>> 32);
    }
}

