/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.session.AbstractSession;
import org.apache.sshd.common.session.AbstractSessionIoHandler;
import org.apache.sshd.common.session.SessionListener;
import org.apache.sshd.common.util.ValidateUtils;

public abstract class AbstractSessionFactory
extends AbstractSessionIoHandler {
    protected final List<SessionListener> listeners = new CopyOnWriteArrayList<SessionListener>();

    protected AbstractSessionFactory() {
    }

    @Override
    protected AbstractSession createSession(IoSession ioSession) throws Exception {
        AbstractSession session = this.doCreateSession(ioSession);
        for (SessionListener l : this.listeners) {
            l.sessionCreated(session);
            session.addListener(l);
        }
        return session;
    }

    protected abstract AbstractSession doCreateSession(IoSession var1) throws Exception;

    public void addListener(SessionListener listener) {
        ValidateUtils.checkNotNull(listener, "addListener(%s) no listener", (Object)this);
        this.listeners.add(listener);
    }

    public void removeListener(SessionListener listener) {
        this.listeners.remove(listener);
    }
}

