/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.sshd.agent.common.AgentForwardSupport;
import org.apache.sshd.client.channel.AbstractClientChannel;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.FactoryManagerUtils;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.RequestHandler;
import org.apache.sshd.common.forward.TcpipForwarder;
import org.apache.sshd.common.forward.TcpipForwarderFactory;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.session.AbstractSession;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.CloseableUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.Int2IntFunction;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.server.channel.OpenChannelException;
import org.apache.sshd.server.x11.X11ForwardSupport;

public abstract class AbstractConnectionService
extends CloseableUtils.AbstractInnerCloseable
implements ConnectionService {
    public static final String MAX_CONCURRENT_CHANNELS_PROP = "max-sshd-channels";
    public static final int DEFAULT_MAX_CHANNELS = Integer.MAX_VALUE;
    public static final Int2IntFunction RESPONSE_BUFFER_GROWTH_FACTOR = Int2IntFunction.Utils.add(8);
    protected final Map<Integer, Channel> channels = new ConcurrentHashMap<Integer, Channel>();
    protected final AtomicInteger nextChannelId = new AtomicInteger(0);
    protected final AbstractSession session;
    protected final TcpipForwarder tcpipForwarder;
    protected final AgentForwardSupport agentForward;
    protected final X11ForwardSupport x11Forward;
    protected boolean allowMoreSessions = true;

    protected AbstractConnectionService(Session session) {
        ValidateUtils.checkTrue(session instanceof AbstractSession, "Not an AbstractSession");
        this.session = (AbstractSession)session;
        FactoryManager manager = session.getFactoryManager();
        this.agentForward = new AgentForwardSupport(this);
        this.x11Forward = new X11ForwardSupport(this);
        TcpipForwarderFactory factory = ValidateUtils.checkNotNull(manager.getTcpipForwarderFactory(), "No forwarder factory", GenericUtils.EMPTY_OBJECT_ARRAY);
        this.tcpipForwarder = factory.create(this);
    }

    public Collection<Channel> getChannels() {
        return this.channels.values();
    }

    @Override
    public AbstractSession getSession() {
        return this.session;
    }

    @Override
    public void start() {
    }

    @Override
    public TcpipForwarder getTcpipForwarder() {
        return this.tcpipForwarder;
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().sequential(this.tcpipForwarder, this.agentForward, this.x11Forward).parallel(this.channels.values()).build();
    }

    protected int getNextChannelId() {
        return this.nextChannelId.getAndIncrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int registerChannel(Channel channel) throws IOException {
        int maxChannels = FactoryManagerUtils.getIntProperty(this.session, MAX_CONCURRENT_CHANNELS_PROP, Integer.MAX_VALUE);
        int curSize = this.channels.size();
        if (curSize > maxChannels) {
            throw new IllegalStateException("Currently active channels (" + curSize + ") at max.: " + maxChannels);
        }
        int channelId = this.getNextChannelId();
        channel.init(this, this.session, channelId);
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosing()) {
                throw new IllegalStateException("Session is being closed: " + this.toString());
            }
            this.channels.put(channelId, channel);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("registerChannel(id={}) {}", (Object)channelId, (Object)channel);
        }
        return channelId;
    }

    @Override
    public void unregisterChannel(Channel channel) {
        this.channels.remove(channel.getId());
    }

    @Override
    public void process(int cmd, Buffer buffer) throws Exception {
        switch (cmd) {
            case 90: {
                this.channelOpen(buffer);
                break;
            }
            case 91: {
                this.channelOpenConfirmation(buffer);
                break;
            }
            case 92: {
                this.channelOpenFailure(buffer);
                break;
            }
            case 98: {
                this.channelRequest(buffer);
                break;
            }
            case 94: {
                this.channelData(buffer);
                break;
            }
            case 95: {
                this.channelExtendedData(buffer);
                break;
            }
            case 100: {
                this.channelFailure(buffer);
                break;
            }
            case 93: {
                this.channelWindowAdjust(buffer);
                break;
            }
            case 96: {
                this.channelEof(buffer);
                break;
            }
            case 97: {
                this.channelClose(buffer);
                break;
            }
            case 80: {
                this.globalRequest(buffer);
                break;
            }
            case 81: {
                this.requestSuccess(buffer);
                break;
            }
            case 82: {
                this.requestFailure(buffer);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported command: " + cmd);
            }
        }
    }

    @Override
    public void setAllowMoreSessions(boolean allow) {
        this.allowMoreSessions = allow;
    }

    public void channelOpenConfirmation(Buffer buffer) throws IOException {
        Channel channel = this.getChannel(buffer);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received SSH_MSG_CHANNEL_OPEN_CONFIRMATION on channel {}", (Object)channel.getId());
        }
        int recipient = buffer.getInt();
        int rwsize = buffer.getInt();
        int rmpsize = buffer.getInt();
        channel.handleOpenSuccess(recipient, rwsize, rmpsize, buffer);
    }

    public void channelOpenFailure(Buffer buffer) throws IOException {
        AbstractClientChannel channel = (AbstractClientChannel)this.getChannel(buffer);
        int id = channel.getId();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received SSH_MSG_CHANNEL_OPEN_FAILURE on channel {}", (Object)id);
        }
        this.channels.remove(id);
        channel.handleOpenFailure(buffer);
    }

    public void channelData(Buffer buffer) throws IOException {
        Channel channel = this.getChannel(buffer);
        channel.handleData(buffer);
    }

    public void channelExtendedData(Buffer buffer) throws IOException {
        Channel channel = this.getChannel(buffer);
        channel.handleExtendedData(buffer);
    }

    public void channelWindowAdjust(Buffer buffer) throws IOException {
        try {
            Channel channel = this.getChannel(buffer);
            channel.handleWindowAdjust(buffer);
        }
        catch (SshException e) {
            this.log.info("channelWindowAdjust error: {}", (Object)e.getMessage());
        }
    }

    public void channelEof(Buffer buffer) throws IOException {
        Channel channel = this.getChannel(buffer);
        channel.handleEof();
    }

    public void channelClose(Buffer buffer) throws IOException {
        Channel channel = this.getChannel(buffer);
        channel.handleClose();
    }

    public void channelRequest(Buffer buffer) throws IOException {
        Channel channel = this.getChannel(buffer);
        channel.handleRequest(buffer);
    }

    public void channelFailure(Buffer buffer) throws IOException {
        Channel channel = this.getChannel(buffer);
        channel.handleFailure();
    }

    protected Channel getChannel(Buffer buffer) throws IOException {
        int recipient = buffer.getInt();
        Channel channel = this.channels.get(recipient);
        if (channel == null) {
            buffer.rpos(buffer.rpos() - 5);
            int cmd = buffer.getUByte();
            throw new SshException("Received " + cmd + " on unknown channel " + recipient);
        }
        return channel;
    }

    protected void channelOpen(Buffer buffer) throws Exception {
        String type = buffer.getString();
        final int id = buffer.getInt();
        int rwsize = buffer.getInt();
        int rmpsize = buffer.getInt();
        this.log.debug("Received SSH_MSG_CHANNEL_OPEN {}", (Object)type);
        if (this.isClosing()) {
            Buffer buf = this.session.createBuffer((byte)92);
            buf.putInt(id);
            buf.putInt(2L);
            buf.putString("SSH server is shutting down: " + type);
            buf.putString("");
            this.session.writePacket(buf);
            return;
        }
        if (!this.allowMoreSessions) {
            Buffer buf = this.session.createBuffer((byte)92);
            buf.putInt(id);
            buf.putInt(2L);
            buf.putString("additional sessions disabled");
            buf.putString("");
            this.session.writePacket(buf);
            return;
        }
        final Channel channel = NamedFactory.Utils.create(this.session.getFactoryManager().getChannelFactories(), type);
        if (channel == null) {
            Buffer buf = this.session.createBuffer((byte)92);
            buf.putInt(id);
            buf.putInt(3L);
            buf.putString("Unsupported channel type: " + type);
            buf.putString("");
            this.session.writePacket(buf);
            return;
        }
        final int channelId = this.registerChannel(channel);
        channel.open(id, rwsize, rmpsize, buffer).addListener(new SshFutureListener<OpenFuture>(){

            @Override
            public void operationComplete(OpenFuture future) {
                try {
                    if (future.isOpened()) {
                        Buffer buf = AbstractConnectionService.this.session.createBuffer((byte)91);
                        buf.putInt(id);
                        buf.putInt(channelId);
                        buf.putInt(channel.getLocalWindow().getSize());
                        buf.putInt(channel.getLocalWindow().getPacketSize());
                        AbstractConnectionService.this.session.writePacket(buf);
                    } else {
                        Throwable exception = future.getException();
                        if (exception != null) {
                            Buffer buf = AbstractConnectionService.this.session.createBuffer((byte)92);
                            buf.putInt(id);
                            if (exception instanceof OpenChannelException) {
                                buf.putInt(((OpenChannelException)exception).getReasonCode());
                                buf.putString(exception.getMessage());
                            } else {
                                buf.putInt(0L);
                                buf.putString("Error opening channel: " + exception.getMessage());
                            }
                            buf.putString("");
                            AbstractConnectionService.this.session.writePacket(buf);
                        }
                    }
                }
                catch (IOException e) {
                    AbstractConnectionService.this.session.exceptionCaught(e);
                }
            }
        });
    }

    protected void globalRequest(Buffer buffer) throws Exception {
        List<RequestHandler<ConnectionService>> handlers;
        String req = buffer.getString();
        boolean wantReply = buffer.getBoolean();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received SSH_MSG_GLOBAL_REQUEST {} want-reply={}", (Object)req, (Object)wantReply);
        }
        if (GenericUtils.size(handlers = this.session.getFactoryManager().getGlobalRequestHandlers()) > 0) {
            for (RequestHandler<ConnectionService> handler : handlers) {
                RequestHandler.Result result;
                try {
                    result = handler.process(this, req, wantReply, buffer);
                }
                catch (Exception e) {
                    this.log.warn("Error processing global request " + req, (Throwable)e);
                    result = RequestHandler.Result.ReplyFailure;
                }
                if (RequestHandler.Result.Unsupported.equals((Object)result)) {
                    if (!this.log.isTraceEnabled()) continue;
                    this.log.trace("{}#process({}): {}", new Object[]{handler.getClass().getSimpleName(), req, result});
                    continue;
                }
                this.sendResponse(buffer, req, result, wantReply);
                return;
            }
        }
        this.log.warn("Unknown global request: {}", (Object)req);
        this.sendResponse(buffer, req, RequestHandler.Result.Unsupported, wantReply);
    }

    protected void sendResponse(Buffer buffer, String req, RequestHandler.Result result, boolean wantReply) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendResponse({}) result={}, want-reply={}", new Object[]{req, result, wantReply});
        }
        if (RequestHandler.Result.Replied.equals((Object)result) || !wantReply) {
            return;
        }
        byte cmd = RequestHandler.Result.ReplySuccess.equals((Object)result) ? (byte)99 : 100;
        buffer.clear();
        buffer.ensureCapacity(10, RESPONSE_BUFFER_GROWTH_FACTOR);
        buffer.rpos(5);
        buffer.wpos(5);
        buffer.putByte(cmd);
        this.session.writePacket(buffer);
    }

    protected void requestSuccess(Buffer buffer) throws Exception {
        this.session.requestSuccess(buffer);
    }

    protected void requestFailure(Buffer buffer) throws Exception {
        this.session.requestFailure(buffer);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.session + "]";
    }
}

