/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.nio2;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.future.DefaultSshFuture;
import org.apache.sshd.common.io.IoConnectFuture;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.nio2.Nio2CompletionHandler;
import org.apache.sshd.common.io.nio2.Nio2Service;
import org.apache.sshd.common.io.nio2.Nio2Session;

public class Nio2Connector
extends Nio2Service
implements IoConnector {
    public Nio2Connector(FactoryManager manager, IoHandler handler, AsynchronousChannelGroup group) {
        super(manager, handler, group);
    }

    @Override
    public IoConnectFuture connect(SocketAddress address) {
        this.log.debug("Connecting to {}", (Object)address);
        final DefaultIoConnectFuture future = new DefaultIoConnectFuture((Object)null);
        try {
            final AsynchronousSocketChannel socket = AsynchronousSocketChannel.open(this.group);
            this.setOption(socket, "socket-keepalive", StandardSocketOptions.SO_KEEPALIVE, null);
            this.setOption(socket, "socket-linger", StandardSocketOptions.SO_LINGER, null);
            this.setOption(socket, "socket-rcvbuf", StandardSocketOptions.SO_RCVBUF, null);
            this.setOption(socket, "socket-reuseaddr", StandardSocketOptions.SO_REUSEADDR, Boolean.TRUE);
            this.setOption(socket, "socket-sndbuf", StandardSocketOptions.SO_SNDBUF, null);
            this.setOption(socket, "tcp-nodelay", StandardSocketOptions.TCP_NODELAY, null);
            socket.connect(address, null, new Nio2CompletionHandler<Void, Object>(){

                @Override
                protected void onCompleted(Void result, Object attachment) {
                    try {
                        Nio2Session session = new Nio2Session(Nio2Connector.this, Nio2Connector.this.manager, Nio2Connector.this.handler, socket);
                        Nio2Connector.this.handler.sessionCreated(session);
                        Nio2Connector.this.sessions.put(session.getId(), session);
                        future.setSession(session);
                        session.startReading();
                    }
                    catch (Throwable e) {
                        try {
                            socket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        future.setException(e);
                    }
                }

                @Override
                protected void onFailed(Throwable exc, Object attachment) {
                    future.setException(exc);
                }
            });
        }
        catch (IOException exc) {
            future.setException(exc);
        }
        return future;
    }

    static class DefaultIoConnectFuture
    extends DefaultSshFuture<IoConnectFuture>
    implements IoConnectFuture {
        DefaultIoConnectFuture(Object lock) {
            super(lock);
        }

        @Override
        public IoSession getSession() {
            Object v = this.getValue();
            return v instanceof IoSession ? (IoSession)v : null;
        }

        @Override
        public Throwable getException() {
            Object v = this.getValue();
            return v instanceof Throwable ? (Throwable)v : null;
        }

        @Override
        public boolean isConnected() {
            return this.getValue() instanceof IoSession;
        }

        @Override
        public void setSession(IoSession session) {
            this.setValue(session);
        }

        @Override
        public void setException(Throwable exception) {
            this.setValue(exception);
        }
    }
}

