/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.forward;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.SshdSocketAddress;
import org.apache.sshd.common.forward.LocalForwardingEntry;
import org.apache.sshd.common.forward.SocksProxy;
import org.apache.sshd.common.forward.TcpipClientChannel;
import org.apache.sshd.common.forward.TcpipForwarder;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoHandlerFactory;
import org.apache.sshd.common.io.IoServiceFactory;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.CloseableUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.server.forward.ForwardingFilter;

public class DefaultTcpipForwarder
extends CloseableUtils.AbstractInnerCloseable
implements TcpipForwarder {
    private final ConnectionService service;
    private final IoHandlerFactory socksProxyIoHandlerFactory = new IoHandlerFactory(){

        @Override
        public IoHandler create() {
            return new SocksProxy(DefaultTcpipForwarder.this.getConnectionService());
        }
    };
    private final Session session;
    private final Map<Integer, SshdSocketAddress> localToRemote = new HashMap<Integer, SshdSocketAddress>();
    private final Map<Integer, SshdSocketAddress> remoteToLocal = new HashMap<Integer, SshdSocketAddress>();
    private final Map<Integer, SocksProxy> dynamicLocal = new HashMap<Integer, SocksProxy>();
    private final Set<LocalForwardingEntry> localForwards = new HashSet<LocalForwardingEntry>();
    private final IoHandlerFactory staticIoHandlerFactory = new IoHandlerFactory(){

        @Override
        public IoHandler create() {
            return new StaticIoHandler();
        }
    };
    private IoAcceptor acceptor;

    public DefaultTcpipForwarder(ConnectionService service) {
        this.service = ValidateUtils.checkNotNull(service, "No connection service");
        this.session = ValidateUtils.checkNotNull(service.getSession(), "No session");
    }

    public final ConnectionService getConnectionService() {
        return this.service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SshdSocketAddress startLocalPortForwarding(SshdSocketAddress local, SshdSocketAddress remote) throws IOException {
        SshdSocketAddress prev;
        ValidateUtils.checkNotNull(local, "Local address is null");
        ValidateUtils.checkTrue(local.getPort() >= 0, "Invalid local port: %s", (Object)local);
        ValidateUtils.checkNotNull(remote, "Remote address is null");
        if (this.isClosed()) {
            throw new IllegalStateException("TcpipForwarder is closed");
        }
        if (this.isClosing()) {
            throw new IllegalStateException("TcpipForwarder is closing");
        }
        InetSocketAddress bound = this.doBind(local, this.staticIoHandlerFactory);
        int port = bound.getPort();
        Map<Integer, SshdSocketAddress> map = this.localToRemote;
        synchronized (map) {
            prev = this.localToRemote.put(port, remote);
        }
        if (prev != null) {
            throw new IOException("Multiple local port forwarding bindings on port=" + port + ": current=" + remote + ", previous=" + prev);
        }
        SshdSocketAddress result = new SshdSocketAddress(bound.getHostString(), port);
        if (this.log.isDebugEnabled()) {
            this.log.debug("startLocalPortForwarding(" + local + " -> " + remote + "): " + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stopLocalPortForwarding(SshdSocketAddress local) throws IOException {
        SshdSocketAddress bound;
        ValidateUtils.checkNotNull(local, "Local address is null");
        Map<Integer, SshdSocketAddress> map = this.localToRemote;
        synchronized (map) {
            bound = this.localToRemote.remove(local.getPort());
        }
        if (bound != null && this.acceptor != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("stopLocalPortForwarding(" + local + ") unbind " + bound);
            }
            this.acceptor.unbind(bound.toInetSocketAddress());
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("stopLocalPortForwarding(" + local + ") no mapping/acceptor for " + bound);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SshdSocketAddress startRemotePortForwarding(SshdSocketAddress remote, SshdSocketAddress local) throws IOException {
        SshdSocketAddress prev;
        ValidateUtils.checkNotNull(local, "Local address is null");
        ValidateUtils.checkNotNull(remote, "Remote address is null");
        Buffer buffer = this.session.createBuffer((byte)80);
        buffer.putString("tcpip-forward");
        buffer.putBoolean(true);
        buffer.putString(remote.getHostName());
        buffer.putInt(remote.getPort());
        Buffer result = this.session.request(buffer);
        if (result == null) {
            throw new SshException("Tcpip forwarding request denied by server");
        }
        int port = remote.getPort() == 0 ? result.getInt() : remote.getPort();
        Map<Integer, SshdSocketAddress> map = this.remoteToLocal;
        synchronized (map) {
            prev = this.remoteToLocal.put(port, local);
        }
        if (prev != null) {
            throw new IOException("Multiple remote port forwarding bindings on port=" + port + ": current=" + remote + ", previous=" + prev);
        }
        SshdSocketAddress bound = new SshdSocketAddress(remote.getHostName(), port);
        if (this.log.isDebugEnabled()) {
            this.log.debug("startRemotePortForwarding(" + remote + " -> " + local + "): " + bound);
        }
        return bound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stopRemotePortForwarding(SshdSocketAddress remote) throws IOException {
        SshdSocketAddress bound;
        Map<Integer, SshdSocketAddress> map = this.remoteToLocal;
        synchronized (map) {
            bound = this.remoteToLocal.remove(remote.getPort());
        }
        if (bound != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("stopRemotePortForwarding(" + remote + ") cancel forwarding to " + bound);
            }
            Buffer buffer = this.session.createBuffer((byte)80);
            buffer.putString("cancel-tcpip-forward");
            buffer.putBoolean(false);
            buffer.putString(remote.getHostName());
            buffer.putInt(remote.getPort());
            this.session.writePacket(buffer);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("stopRemotePortForwarding(" + remote + ") no binding found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SshdSocketAddress startDynamicPortForwarding(SshdSocketAddress local) throws IOException {
        SocksProxy prev;
        ValidateUtils.checkNotNull(local, "Local address is null");
        ValidateUtils.checkTrue(local.getPort() >= 0, "Invalid local port: %s", (Object)local);
        if (this.isClosed()) {
            throw new IllegalStateException("TcpipForwarder is closed");
        }
        if (this.isClosing()) {
            throw new IllegalStateException("TcpipForwarder is closing");
        }
        SocksProxy socksProxy = new SocksProxy(this.service);
        InetSocketAddress bound = this.doBind(local, this.socksProxyIoHandlerFactory);
        int port = bound.getPort();
        Map<Integer, SocksProxy> map = this.dynamicLocal;
        synchronized (map) {
            prev = this.dynamicLocal.put(port, socksProxy);
        }
        if (prev != null) {
            throw new IOException("Multiple dynamic port mappings found for port=" + port + ": current=" + socksProxy + ", previous=" + prev);
        }
        SshdSocketAddress result = new SshdSocketAddress(bound.getHostString(), port);
        if (this.log.isDebugEnabled()) {
            this.log.debug("startDynamicPortForwarding(" + local + "): " + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stopDynamicPortForwarding(SshdSocketAddress local) throws IOException {
        Closeable obj;
        Map<Integer, SocksProxy> map = this.dynamicLocal;
        synchronized (map) {
            obj = this.dynamicLocal.remove(local.getPort());
        }
        if (obj != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("stopDynamicPortForwarding(" + local + ") unbinding");
            }
            obj.close(true);
            this.acceptor.unbind(local.toInetSocketAddress());
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("stopDynamicPortForwarding(" + local + ") no binding found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SshdSocketAddress getForwardedPort(int remotePort) {
        Map<Integer, SshdSocketAddress> map = this.remoteToLocal;
        synchronized (map) {
            return this.remoteToLocal.get(remotePort);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SshdSocketAddress localPortForwardingRequested(SshdSocketAddress local) throws IOException {
        boolean added;
        ValidateUtils.checkNotNull(local, "Local address is null");
        ValidateUtils.checkTrue(local.getPort() >= 0, "Invalid local port: %s", (Object)local);
        FactoryManager manager = this.session.getFactoryManager();
        ForwardingFilter filter = manager.getTcpipForwardingFilter();
        if (filter == null || !filter.canListen(local, this.session)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("localPortForwardingRequested(" + this.session + ")[" + local + "][haveFilter=" + (filter != null) + "] rejected");
            }
            throw new IOException("Rejected address: " + local);
        }
        InetSocketAddress bound = this.doBind(local, this.staticIoHandlerFactory);
        SshdSocketAddress result = new SshdSocketAddress(bound.getHostString(), bound.getPort());
        if (this.log.isDebugEnabled()) {
            this.log.debug("localPortForwardingRequested(" + local + "): " + result);
        }
        Set<LocalForwardingEntry> set = this.localForwards;
        synchronized (set) {
            added = this.localForwards.add(new LocalForwardingEntry(result.getHostName(), local.getHostName(), result.getPort()));
        }
        if (!added) {
            throw new IOException("Failed to add local port forwarding entry for " + local + " -> " + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void localPortForwardingCancelled(SshdSocketAddress local) throws IOException {
        LocalForwardingEntry entry;
        Set<LocalForwardingEntry> set = this.localForwards;
        synchronized (set) {
            entry = LocalForwardingEntry.findMatchingEntry(local.getHostName(), local.getPort(), this.localForwards);
            if (entry != null) {
                this.localForwards.remove(entry);
            }
        }
        if (entry != null && this.acceptor != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("localPortForwardingCancelled(" + local + ") unbind " + entry);
            }
            this.acceptor.unbind(entry.toInetSocketAddress());
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("localPortForwardingCancelled(" + local + ") no match/acceptor: " + entry);
        }
    }

    @Override
    protected synchronized Closeable getInnerCloseable() {
        return this.builder().parallel(this.dynamicLocal.values()).close(this.acceptor).build();
    }

    private InetSocketAddress doBind(SshdSocketAddress address, Factory<? extends IoHandler> handlerFactory) throws IOException {
        Set<SocketAddress> after;
        if (this.acceptor == null) {
            FactoryManager manager = this.session.getFactoryManager();
            IoServiceFactory factory = manager.getIoServiceFactory();
            IoHandler handler = handlerFactory.create();
            this.acceptor = factory.createAcceptor(handler);
        }
        Set<SocketAddress> before = this.acceptor.getBoundAddresses();
        try {
            InetSocketAddress bindAddress = address.toInetSocketAddress();
            this.acceptor.bind(bindAddress);
            after = this.acceptor.getBoundAddresses();
            if (GenericUtils.size(after) > 0) {
                after.removeAll(before);
            }
            if (GenericUtils.isEmpty(after)) {
                throw new IOException("Error binding to " + address + "[" + bindAddress + "]: no local addresses bound");
            }
            if (after.size() > 1) {
                throw new IOException("Multiple local addresses have been bound for " + address + "[" + bindAddress + "]");
            }
            return (InetSocketAddress)after.iterator().next();
        }
        catch (IOException bindErr) {
            after = this.acceptor.getBoundAddresses();
            if (GenericUtils.isEmpty(after)) {
                this.close();
            }
            throw bindErr;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.session + "]";
    }

    class StaticIoHandler
    implements IoHandler {
        StaticIoHandler() {
        }

        @Override
        public void sessionCreated(IoSession session) throws Exception {
            InetSocketAddress local = (InetSocketAddress)session.getLocalAddress();
            int localPort = local.getPort();
            SshdSocketAddress remote = (SshdSocketAddress)DefaultTcpipForwarder.this.localToRemote.get(localPort);
            final TcpipClientChannel channel = remote != null ? new TcpipClientChannel(TcpipClientChannel.Type.Direct, session, remote) : new TcpipClientChannel(TcpipClientChannel.Type.Forwarded, session, null);
            session.setAttribute(TcpipClientChannel.class, channel);
            DefaultTcpipForwarder.this.service.registerChannel(channel);
            channel.open().addListener(new SshFutureListener<OpenFuture>(){

                @Override
                public void operationComplete(OpenFuture future) {
                    Throwable t = future.getException();
                    if (t != null) {
                        DefaultTcpipForwarder.this.service.unregisterChannel(channel);
                        channel.close(false);
                    }
                }
            });
        }

        @Override
        public void sessionClosed(IoSession session) throws Exception {
            TcpipClientChannel channel = (TcpipClientChannel)session.getAttribute(TcpipClientChannel.class);
            if (channel != null) {
                DefaultTcpipForwarder.this.log.debug("IoSession {} closed, will now close the channel", (Object)session);
                channel.close(false);
            }
        }

        @Override
        public void messageReceived(IoSession session, Readable message) throws Exception {
            TcpipClientChannel channel = (TcpipClientChannel)session.getAttribute(TcpipClientChannel.class);
            ByteArrayBuffer buffer = new ByteArrayBuffer();
            buffer.putBuffer(message);
            channel.waitFor(130, Long.MAX_VALUE);
            OutputStream outputStream = channel.getInvertedIn();
            outputStream.write(((Buffer)buffer).array(), ((Buffer)buffer).rpos(), buffer.available());
            outputStream.flush();
        }

        @Override
        public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
            cause.printStackTrace();
            session.close(false);
        }
    }
}

