/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.file.virtualfs;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.file.root.RootedFileSystemProvider;
import org.apache.sshd.common.session.Session;

public class VirtualFileSystemFactory
implements FileSystemFactory {
    private String defaultHomeDir;
    private final Map<String, String> homeDirs = new ConcurrentHashMap<String, String>();

    public VirtualFileSystemFactory() {
    }

    public VirtualFileSystemFactory(String defaultHomeDir) {
        this.defaultHomeDir = defaultHomeDir;
    }

    public void setDefaultHomeDir(String defaultHomeDir) {
        this.defaultHomeDir = defaultHomeDir;
    }

    public String getDefaultHomeDir() {
        return this.defaultHomeDir;
    }

    public void setUserHomeDir(String userName, String userHomeDir) {
        this.homeDirs.put(userName, userHomeDir);
    }

    public String getUserHomeDir(String userName) {
        return this.homeDirs.get(userName);
    }

    protected String computeRootDir(String userName) {
        String homeDir = this.homeDirs.get(userName);
        if (homeDir == null) {
            homeDir = this.defaultHomeDir;
        }
        if (homeDir == null) {
            throw new IllegalStateException("No home directory for user " + userName);
        }
        return homeDir;
    }

    @Override
    public FileSystem createFileSystem(Session session) throws IOException {
        String dir = this.computeRootDir(session.getUsername());
        return new RootedFileSystemProvider().newFileSystem(Paths.get(dir, new String[0]), Collections.emptyMap());
    }
}

