/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.digest;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.digest.BaseDigest;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.digest.DigestFactory;
import org.apache.sshd.common.digest.DigestInformation;
import org.apache.sshd.common.util.GenericUtils;

public enum BuiltinDigests implements DigestInformation,
DigestFactory
{
    md5("md5", "MD5", 16),
    sha1("sha1", "SHA-1", 20),
    sha256("sha256", "SHA-256", 32),
    sha384("sha384", "SHA-384", 48),
    sha512("sha512", "SHA-512", 64);

    public static final Set<BuiltinDigests> VALUES;
    private final String algorithm;
    private final int blockSize;
    private final String factoryName;

    private BuiltinDigests(String factoryName, String algorithm, int blockSize) {
        this.factoryName = factoryName;
        this.algorithm = algorithm;
        this.blockSize = blockSize;
    }

    @Override
    public final String getName() {
        return this.factoryName;
    }

    @Override
    public final String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public final int getBlockSize() {
        return this.blockSize;
    }

    public final String toString() {
        return this.getName();
    }

    @Override
    public final Digest create() {
        return new BaseDigest(this.getAlgorithm(), this.getBlockSize());
    }

    public static BuiltinDigests fromString(String s) {
        if (GenericUtils.isEmpty(s)) {
            return null;
        }
        for (BuiltinDigests c : VALUES) {
            if (!s.equalsIgnoreCase(c.name())) continue;
            return c;
        }
        return null;
    }

    public static BuiltinDigests fromFactory(NamedFactory<Digest> factory) {
        if (factory == null) {
            return null;
        }
        return BuiltinDigests.fromFactoryName(factory.getName());
    }

    public static BuiltinDigests fromFactoryName(String name) {
        return NamedResource.Utils.findByName(name, String.CASE_INSENSITIVE_ORDER, VALUES);
    }

    static {
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(BuiltinDigests.class));
    }

    public static final class Constants {
        public static final String MD5 = "md5";
        public static final String SHA1 = "sha1";
        public static final String SHA256 = "sha256";
        public static final String SHA384 = "sha384";
        public static final String SHA512 = "sha512";
    }
}

