/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Collection;
import org.apache.sshd.common.config.keys.PublicKeyEntryDecoder;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.IoUtils;

public abstract class AbstractPublicKeyEntryDecoder<PUB extends PublicKey, PRV extends PrivateKey>
implements PublicKeyEntryDecoder<PUB, PRV> {
    private final Class<PUB> pubType;
    private final Class<PRV> prvType;
    private final Collection<String> names;

    protected AbstractPublicKeyEntryDecoder(Class<PUB> pubType, Class<PRV> prvType, Collection<String> names) {
        this.pubType = ValidateUtils.checkNotNull(pubType, "No public key type specified");
        this.prvType = ValidateUtils.checkNotNull(prvType, "No private key type specified");
        this.names = ValidateUtils.checkNotNullAndNotEmpty(names, "No type names provided", new Object[0]);
    }

    @Override
    public final Class<PUB> getPublicKeyType() {
        return this.pubType;
    }

    @Override
    public final Class<PRV> getPrivateKeyType() {
        return this.prvType;
    }

    @Override
    public KeyPair cloneKeyPair(KeyPair kp) throws GeneralSecurityException {
        if (kp == null) {
            return null;
        }
        PublicKey pubCloned = null;
        PublicKey pubOriginal = kp.getPublic();
        Class<PUB> pubExpected = this.getPublicKeyType();
        if (pubOriginal != null) {
            Class<?> orgType = pubOriginal.getClass();
            if (!pubExpected.isAssignableFrom(orgType)) {
                throw new InvalidKeyException("Mismatched public key types: expected=" + pubExpected.getSimpleName() + ", actual=" + orgType.getSimpleName());
            }
            pubCloned = this.clonePublicKey((PublicKey)pubExpected.cast(pubOriginal));
        }
        PrivateKey prvCloned = null;
        PrivateKey prvOriginal = kp.getPrivate();
        Class<PRV> prvExpected = this.getPrivateKeyType();
        if (prvOriginal != null) {
            Class<?> orgType = prvOriginal.getClass();
            if (!prvExpected.isAssignableFrom(orgType)) {
                throw new InvalidKeyException("Mismatched private key types: expected=" + prvExpected.getSimpleName() + ", actual=" + orgType.getSimpleName());
            }
            prvCloned = this.clonePrivateKey((PrivateKey)prvExpected.cast(prvOriginal));
        }
        return new KeyPair(pubCloned, prvCloned);
    }

    @Override
    public Collection<String> getSupportedTypeNames() {
        return this.names;
    }

    @Override
    public PUB decodePublicKey(byte ... keyData) throws IOException, GeneralSecurityException {
        return this.decodePublicKey(keyData, 0, GenericUtils.length(keyData));
    }

    @Override
    public PUB decodePublicKey(byte[] keyData, int offset, int length) throws IOException, GeneralSecurityException {
        if (length <= 0) {
            return null;
        }
        try (ByteArrayInputStream stream = new ByteArrayInputStream(keyData, offset, length);){
            PUB PUB = this.decodePublicKey(stream);
            return PUB;
        }
    }

    @Override
    public PUB decodePublicKey(InputStream keyData) throws IOException, GeneralSecurityException {
        String type = AbstractPublicKeyEntryDecoder.decodeString(keyData);
        if (GenericUtils.isEmpty(type)) {
            throw new StreamCorruptedException("Missing key type string");
        }
        Collection<String> supported = this.getSupportedTypeNames();
        if (GenericUtils.isEmpty(supported) || !supported.contains(type)) {
            throw new InvalidKeySpecException("Reported key type (" + type + ") not in supported list: " + supported);
        }
        return this.decodePublicKey(type, keyData);
    }

    public PUB generatePublicKey(KeySpec keySpec) throws GeneralSecurityException {
        KeyFactory factory = this.getKeyFactoryInstance();
        Class<PUB> keyType = this.getPublicKeyType();
        return (PUB)((PublicKey)keyType.cast(factory.generatePublic(keySpec)));
    }

    public PRV generatePrivateKey(KeySpec keySpec) throws GeneralSecurityException {
        KeyFactory factory = this.getKeyFactoryInstance();
        Class<PRV> keyType = this.getPrivateKeyType();
        return (PRV)((PrivateKey)keyType.cast(factory.generatePrivate(keySpec)));
    }

    public abstract PUB decodePublicKey(String var1, InputStream var2) throws IOException, GeneralSecurityException;

    @Override
    public KeyPair generateKeyPair(int keySize) throws GeneralSecurityException {
        KeyPairGenerator gen = this.getKeyPairGenerator();
        gen.initialize(keySize);
        return gen.generateKeyPair();
    }

    public String toString() {
        return this.getPublicKeyType().getSimpleName() + ": " + this.getSupportedTypeNames();
    }

    public static int encodeString(OutputStream s, String v) throws IOException {
        return AbstractPublicKeyEntryDecoder.encodeString(s, v, StandardCharsets.UTF_8);
    }

    public static int encodeString(OutputStream s, String v, String charset) throws IOException {
        return AbstractPublicKeyEntryDecoder.encodeString(s, v, Charset.forName(charset));
    }

    public static int encodeString(OutputStream s, String v, Charset cs) throws IOException {
        return AbstractPublicKeyEntryDecoder.writeRLEBytes(s, v.getBytes(cs));
    }

    public static int encodeBigInt(OutputStream s, BigInteger v) throws IOException {
        return AbstractPublicKeyEntryDecoder.writeRLEBytes(s, v.toByteArray());
    }

    public static int writeRLEBytes(OutputStream s, byte ... bytes) throws IOException {
        return AbstractPublicKeyEntryDecoder.writeRLEBytes(s, bytes, 0, bytes.length);
    }

    public static int writeRLEBytes(OutputStream s, byte[] bytes, int off, int len) throws IOException {
        byte[] lenBytes = AbstractPublicKeyEntryDecoder.encodeInt(s, len);
        s.write(bytes, off, len);
        return lenBytes.length + len;
    }

    public static byte[] encodeInt(OutputStream s, int v) throws IOException {
        byte[] bytes = new byte[]{(byte)(v >> 24 & 0xFF), (byte)(v >> 16 & 0xFF), (byte)(v >> 8 & 0xFF), (byte)(v & 0xFF)};
        s.write(bytes);
        return bytes;
    }

    public static String decodeString(InputStream s) throws IOException {
        return AbstractPublicKeyEntryDecoder.decodeString(s, StandardCharsets.UTF_8);
    }

    public static String decodeString(InputStream s, String charset) throws IOException {
        return AbstractPublicKeyEntryDecoder.decodeString(s, Charset.forName(charset));
    }

    public static String decodeString(InputStream s, Charset cs) throws IOException {
        byte[] bytes = AbstractPublicKeyEntryDecoder.readRLEBytes(s);
        return new String(bytes, cs);
    }

    public static BigInteger decodeBigInt(InputStream s) throws IOException {
        return new BigInteger(AbstractPublicKeyEntryDecoder.readRLEBytes(s));
    }

    public static byte[] readRLEBytes(InputStream s) throws IOException {
        int len = AbstractPublicKeyEntryDecoder.decodeInt(s);
        byte[] bytes = new byte[len];
        IoUtils.readFully(s, bytes);
        return bytes;
    }

    public static int decodeInt(InputStream s) throws IOException {
        byte[] bytes = new byte[]{0, 0, 0, 0};
        IoUtils.readFully(s, bytes);
        return (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
    }
}

