/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.FactoryManagerUtils;
import org.apache.sshd.common.channel.AbstractChannel;
import org.apache.sshd.common.channel.WindowClosedException;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class Window
extends AbstractLoggingBean {
    private final AbstractChannel channel;
    private final Object lock;
    private final String name;
    private int size;
    private int maxSize;
    private int packetSize;
    private boolean waiting;
    private boolean closed;
    private Map<String, ?> props = Collections.emptyMap();

    public Window(AbstractChannel channel, Object lock, boolean client, boolean local) {
        this.channel = ValidateUtils.checkNotNull(channel, "No channel provided");
        this.lock = lock != null ? lock : this;
        this.name = String.valueOf(channel) + ": " + (client ? "client" : "server") + " " + (local ? "local " : "remote") + " window";
    }

    public Map<String, ?> getProperties() {
        return this.props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.size;
        }
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getPacketSize() {
        return this.packetSize;
    }

    public void init(Session session) {
        this.init(session.getFactoryManager());
    }

    public void init(FactoryManager manager) {
        this.init(manager.getProperties());
    }

    public void init(Map<String, ?> props) {
        this.init(FactoryManagerUtils.getIntProperty(props, "window-size", 0x200000), FactoryManagerUtils.getIntProperty(props, "packet-size", 32768), props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(int size, int packetSize, Map<String, ?> props) {
        Object object = this.lock;
        synchronized (object) {
            this.size = size;
            this.maxSize = size;
            this.packetSize = packetSize;
            this.props = props;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expand(int window) {
        Object object = this.lock;
        synchronized (object) {
            this.size += window;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Increase " + this.name + " by " + window + " up to " + this.size);
            }
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consume(int len) {
        Object object = this.lock;
        synchronized (object) {
            this.size -= len;
            if (this.log.isTraceEnabled()) {
                this.log.trace("Consume " + this.name + " by " + len + " down to " + this.size);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeAndCheck(int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.size -= len;
            if (this.log.isTraceEnabled()) {
                this.log.trace("Consume " + this.name + " by " + len + " down to " + this.size);
            }
            this.check(this.maxSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(int maxFree) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.size < maxFree / 2) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Increase " + this.name + " by " + (maxFree - this.size) + " up to " + maxFree);
                }
                this.channel.sendWindowAdjust(maxFree - this.size);
                this.size = maxFree;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitAndConsume(int len) throws InterruptedException, WindowClosedException {
        Object object = this.lock;
        synchronized (object) {
            while (this.size < len && !this.closed) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Waiting for {} bytes on {}", (Object)len, (Object)this.name);
                }
                this.waiting = true;
                this.lock.wait();
            }
            if (this.waiting) {
                if (this.closed) {
                    this.log.debug("Window {} has been closed", (Object)this.name);
                } else {
                    this.log.debug("Space available for {}", (Object)this.name);
                }
                this.waiting = false;
            }
            if (this.closed) {
                throw new WindowClosedException(this.name);
            }
            this.size -= len;
            if (this.log.isTraceEnabled()) {
                this.log.trace("Consume " + this.name + " by " + len + " down to " + this.size);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitForSpace() throws InterruptedException, WindowClosedException {
        Object object = this.lock;
        synchronized (object) {
            while (this.size == 0 && !this.closed) {
                this.log.debug("Waiting for some space on {}", (Object)this.name);
                this.waiting = true;
                this.lock.wait();
            }
            if (this.waiting) {
                if (this.closed) {
                    this.log.debug("Window {} has been closed", (Object)this.name);
                } else {
                    this.log.debug("Space available for {}", (Object)this.name);
                }
                this.waiting = false;
            }
            if (this.closed) {
                throw new WindowClosedException(this.name);
            }
            return this.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyClosed() {
        Object object = this.lock;
        synchronized (object) {
            this.closed = true;
            if (this.waiting) {
                this.lock.notifyAll();
            }
        }
    }

    public String toString() {
        return this.name;
    }
}

