/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.Transformer;

public interface NamedResource {
    public static final Comparator<NamedResource> BY_NAME_COMPARATOR = new Comparator<NamedResource>(){

        @Override
        public int compare(NamedResource r1, NamedResource r2) {
            String n1 = r1.getName();
            String n2 = r2.getName();
            return String.CASE_INSENSITIVE_ORDER.compare(n1, n2);
        }
    };
    public static final Transformer<NamedResource, String> NAME_EXTRACTOR = new Transformer<NamedResource, String>(){

        @Override
        public String transform(NamedResource input) {
            if (input == null) {
                return null;
            }
            return input.getName();
        }
    };

    public String getName();

    public static final class Utils {
        private Utils() {
            throw new UnsupportedOperationException("No instance allowed");
        }

        public static List<String> getNameList(Collection<? extends NamedResource> resources) {
            if (GenericUtils.isEmpty(resources)) {
                return Collections.emptyList();
            }
            ArrayList<String> names = new ArrayList<String>(resources.size());
            for (NamedResource namedResource : resources) {
                names.add(namedResource.getName());
            }
            return names;
        }

        public static String getNames(Collection<? extends NamedResource> resources) {
            return GenericUtils.join(Utils.getNameList(resources), ',');
        }

        public static <R extends NamedResource> R removeByName(String name, Comparator<? super String> c, Collection<? extends R> resources) {
            R r = Utils.findByName(name, c, resources);
            if (r != null) {
                resources.remove(r);
            }
            return r;
        }

        public static <R extends NamedResource> R findByName(String name, Comparator<? super String> c, Collection<? extends R> resources) {
            if (GenericUtils.isEmpty(name) || GenericUtils.isEmpty(resources)) {
                return null;
            }
            for (NamedResource r : resources) {
                String n = r.getName();
                int nRes = c.compare(name, n);
                if (nRes != 0) continue;
                return (R)r;
            }
            return null;
        }
    }
}

