/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.subsystem.sftp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.sshd.client.channel.ChannelSubsystem;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.subsystem.sftp.AbstractSftpClient;
import org.apache.sshd.client.subsystem.sftp.SftpVersionSelector;
import org.apache.sshd.common.FactoryManagerUtils;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.subsystem.sftp.extensions.ParserUtils;
import org.apache.sshd.common.subsystem.sftp.extensions.VersionsParser;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;

public class DefaultSftpClient
extends AbstractSftpClient {
    private final ClientSession clientSession;
    private final ChannelSubsystem channel;
    private final Map<Integer, Buffer> messages = new HashMap<Integer, Buffer>();
    private final AtomicInteger cmdId = new AtomicInteger(100);
    private final Buffer receiveBuffer = new ByteArrayBuffer();
    private final byte[] workBuf = new byte[4];
    private boolean closing;
    private int version;
    private final Map<String, byte[]> extensions = new TreeMap<String, byte[]>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, byte[]> exposedExtensions = Collections.unmodifiableMap(this.extensions);

    public DefaultSftpClient(ClientSession clientSession) throws IOException {
        this.clientSession = ValidateUtils.checkNotNull(clientSession, "No client session", GenericUtils.EMPTY_OBJECT_ARRAY);
        this.channel = clientSession.createSubsystemChannel("sftp");
        this.channel.setOut(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                this.write(new byte[]{(byte)b}, 0, 1);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                DefaultSftpClient.this.data(b, off, len);
            }
        });
        this.channel.setErr(new ByteArrayOutputStream(127));
        this.channel.open().verify(FactoryManagerUtils.getLongProperty(clientSession, "sftp-channel-open-timeout", DEFAULT_CHANNEL_OPEN_TIMEOUT));
        this.channel.onClose(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Map map = DefaultSftpClient.this.messages;
                synchronized (map) {
                    DefaultSftpClient.this.closing = true;
                    DefaultSftpClient.this.messages.notifyAll();
                }
            }
        });
        this.init();
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public ClientSession getClientSession() {
        return this.clientSession;
    }

    @Override
    public Map<String, byte[]> getServerExtensions() {
        return this.exposedExtensions;
    }

    @Override
    public boolean isClosing() {
        return this.closing;
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        if (this.isOpen()) {
            this.channel.close(false);
        }
    }

    protected int data(byte[] buf, int start, int len) throws IOException {
        Buffer incoming = new ByteArrayBuffer(buf, start, len);
        if (this.receiveBuffer.available() > 0) {
            this.receiveBuffer.putBuffer(incoming);
            incoming = this.receiveBuffer;
        }
        int rpos = incoming.rpos();
        int count = 0;
        while (this.receive(incoming)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Processed " + count + " data messages");
            }
            ++count;
        }
        int read = incoming.rpos() - rpos;
        this.receiveBuffer.compact();
        if (this.receiveBuffer != incoming && incoming.available() > 0) {
            this.receiveBuffer.putBuffer(incoming);
        }
        return read;
    }

    protected boolean receive(Buffer incoming) throws IOException {
        int rpos = incoming.rpos();
        int wpos = incoming.wpos();
        this.clientSession.resetIdleTimeout();
        if (wpos - rpos > 4) {
            int length = incoming.getInt();
            if (length < 5) {
                throw new IOException("Illegal sftp packet length: " + length);
            }
            if (wpos - rpos >= length + 4) {
                incoming.rpos(rpos);
                incoming.wpos(rpos + 4 + length);
                this.process(incoming);
                incoming.rpos(rpos + 4 + length);
                incoming.wpos(wpos);
                return true;
            }
        }
        incoming.rpos(rpos);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(Buffer incoming) throws IOException {
        ByteArrayBuffer buffer = new ByteArrayBuffer(incoming.available());
        buffer.putBuffer(incoming);
        ((Buffer)buffer).rpos(5);
        int id = buffer.getInt();
        ((Buffer)buffer).rpos(0);
        Map<Integer, Buffer> map = this.messages;
        synchronized (map) {
            this.messages.put(id, buffer);
            this.messages.notifyAll();
        }
    }

    @Override
    public int send(int cmd, Buffer buffer) throws IOException {
        int id = this.cmdId.incrementAndGet();
        int len = buffer.available();
        if (this.log.isTraceEnabled()) {
            this.log.trace("send(cmd={}, len={}) id = {}", new Object[]{cmd, len, id});
        }
        OutputStream dos = this.channel.getInvertedIn();
        BufferUtils.writeInt(dos, 5 + buffer.available(), this.workBuf);
        dos.write(cmd & 0xFF);
        BufferUtils.writeInt(dos, id, this.workBuf);
        dos.write(buffer.array(), buffer.rpos(), len);
        dos.flush();
        return id;
    }

    @Override
    public Buffer receive(int id) throws IOException {
        Integer reqId = id;
        Map<Integer, Buffer> map = this.messages;
        synchronized (map) {
            int count = 1;
            while (true) {
                if (this.closing) {
                    throw new SshException("Channel has been closed");
                }
                Buffer buffer = this.messages.remove(reqId);
                if (buffer != null) {
                    return buffer;
                }
                try {
                    this.messages.wait();
                }
                catch (InterruptedException e) {
                    throw (IOException)new InterruptedIOException("Interrupted while waiting for messages at iteration #" + count).initCause(e);
                }
                ++count;
            }
        }
    }

    protected Buffer read() throws IOException {
        int readLen;
        InputStream dis = this.channel.getInvertedOut();
        int length = BufferUtils.readInt(dis, this.workBuf);
        if (length < 5) {
            throw new IllegalArgumentException("Bad length: " + length);
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer(length + 4);
        buffer.putInt(length);
        for (int nb = length; nb > 0; nb -= readLen) {
            readLen = dis.read(((Buffer)buffer).array(), ((Buffer)buffer).wpos(), nb);
            if (readLen < 0) {
                throw new IllegalArgumentException("Premature EOF while read " + length + " bytes - remaining=" + nb);
            }
            ((Buffer)buffer).wpos(((Buffer)buffer).wpos() + readLen);
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() throws IOException {
        Buffer buffer;
        OutputStream dos = this.channel.getInvertedIn();
        BufferUtils.writeInt(dos, 5, this.workBuf);
        dos.write(1);
        BufferUtils.writeInt(dos, 6, this.workBuf);
        dos.flush();
        Map<Integer, Buffer> map = this.messages;
        synchronized (map) {
            while (this.messages.isEmpty()) {
                try {
                    this.messages.wait();
                }
                catch (InterruptedException e) {
                    throw (IOException)new InterruptedIOException("Interruppted init()").initCause(e);
                }
            }
            buffer = this.messages.remove(this.messages.keySet().iterator().next());
        }
        int length = buffer.getInt();
        int type = buffer.getUByte();
        int id = buffer.getInt();
        if (type == 2) {
            if (id < 3) {
                throw new SshException("Unsupported sftp version " + id);
            }
            this.version = id;
            while (buffer.available() > 0) {
                String name = buffer.getString();
                byte[] data = buffer.getBytes();
                this.extensions.put(name, data);
            }
        } else if (type == 101) {
            int substatus = buffer.getInt();
            String msg = buffer.getString();
            String lang = buffer.getString();
            if (this.log.isTraceEnabled()) {
                this.log.trace("init(id={}) - status: {} [{}] {}", new Object[]{id, substatus, lang, msg});
            }
            this.throwStatusException(id, substatus, msg, lang);
        } else {
            throw new SshException("Unexpected SFTP packet received: type=" + type + ", id=" + id + ", length=" + length);
        }
    }

    public int negotiateVersion(SftpVersionSelector selector) throws IOException {
        int current = this.getVersion();
        SortedSet<Integer> available = GenericUtils.asSortedSet(Collections.singleton(current));
        Map<String, Object> parsed = this.getParsedServerExtensions();
        Set<String> extensions = ParserUtils.supportedExtensions(parsed);
        if (GenericUtils.size(extensions) > 0 && extensions.contains("version-select")) {
            Collection<String> reported;
            VersionsParser.Versions vers = GenericUtils.isEmpty(parsed) ? null : (VersionsParser.Versions)parsed.get("versions");
            Collection<String> collection = reported = vers == null ? null : vers.versions;
            if (GenericUtils.size(reported) > 0) {
                for (String v : reported) {
                    if (available.add(Integer.valueOf(v))) continue;
                }
            }
        }
        int selected = selector.selectVersion(current, new ArrayList<Integer>(available));
        if (this.log.isDebugEnabled()) {
            this.log.debug("negotiateVersion({}) {} -> {}", new Object[]{current, available, selected});
        }
        if (selected == current) {
            return current;
        }
        if (!available.contains(selected)) {
            throw new StreamCorruptedException("Selected version (" + selected + ") not part of available: " + available);
        }
        String verVal = String.valueOf(selected);
        ByteArrayBuffer buffer = new ByteArrayBuffer(4 + "version-select".length() + 4 + verVal.length());
        buffer.putString("version-select");
        buffer.putString(verVal);
        this.checkStatus(200, buffer);
        this.version = selected;
        return selected;
    }
}

