/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.session;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.auth.UserAuth;
import org.apache.sshd.client.auth.UserInteraction;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.future.DefaultAuthFuture;
import org.apache.sshd.client.session.ClientSessionImpl;
import org.apache.sshd.common.FactoryManagerUtils;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.Service;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.CloseableUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.Buffer;

public class ClientUserAuthService
extends CloseableUtils.AbstractCloseable
implements Service {
    private final AuthFuture authFuture;
    private final ClientSessionImpl session;
    private List<Object> identities;
    private String service;
    private List<NamedFactory<UserAuth>> authFactories;
    private List<String> clientMethods;
    private List<String> serverMethods;
    private UserAuth userAuth;
    private int currentMethod;

    public ClientUserAuthService(Session s) {
        if (!(s instanceof ClientSessionImpl)) {
            throw new IllegalStateException("Client side service used on server side");
        }
        this.session = (ClientSessionImpl)s;
        this.authFuture = new DefaultAuthFuture(this.session.getLock());
        ClientFactoryManager manager = this.session.getFactoryManager();
        this.authFactories = manager.getUserAuthFactories();
        this.clientMethods = new ArrayList<String>();
        String prefs = FactoryManagerUtils.getString(manager, "preferred-auths");
        if (!GenericUtils.isEmpty(prefs)) {
            for (String pref : prefs.split(",")) {
                NamedFactory<UserAuth> factory = NamedResource.Utils.findByName(pref, String.CASE_INSENSITIVE_ORDER, this.authFactories);
                if (factory != null) {
                    this.clientMethods.add(pref);
                    continue;
                }
                this.log.debug("Skip unknown prefered authentication method: {}", (Object)pref);
            }
        } else {
            for (NamedFactory<UserAuth> factory : this.authFactories) {
                this.clientMethods.add(factory.getName());
            }
        }
    }

    @Override
    public ClientSessionImpl getSession() {
        return this.session;
    }

    @Override
    public void start() {
    }

    public AuthFuture auth(List<Object> identities, String service) throws IOException {
        this.log.debug("Start authentication");
        this.identities = new ArrayList<Object>(identities);
        this.service = service;
        this.log.debug("Send SSH_MSG_USERAUTH_REQUEST for none");
        Buffer buffer = this.session.createBuffer((byte)50);
        buffer.putString(this.session.getUsername());
        buffer.putString(service);
        buffer.putString("none");
        this.session.writePacket(buffer);
        return this.authFuture;
    }

    @Override
    public void process(int cmd, Buffer buffer) throws Exception {
        if (this.authFuture.isSuccess()) {
            throw new IllegalStateException("UserAuth message delivered to authenticated client");
        }
        if (this.authFuture.isDone()) {
            this.log.debug("Ignoring random message");
        } else if (cmd == 53) {
            String welcome = buffer.getString();
            String lang = buffer.getString();
            this.log.debug("Welcome banner(lang={}): {}", (Object)lang, (Object)welcome);
            UserInteraction ui = this.session.getFactoryManager().getUserInteraction();
            if (ui != null) {
                ui.welcome(welcome);
            }
        } else {
            buffer.rpos(buffer.rpos() - 1);
            this.processUserAuth(buffer);
        }
    }

    private void processUserAuth(Buffer buffer) throws Exception {
        int cmd = buffer.getUByte();
        if (cmd == 52) {
            this.log.debug("SSH_MSG_USERAUTH_SUCCESS Succeeded with {}", (Object)this.userAuth);
            if (this.userAuth != null) {
                this.userAuth.destroy();
                this.userAuth = null;
            }
            this.session.setAuthenticated();
            this.session.switchToNextService();
            this.authFuture.setAuthed(true);
            return;
        }
        if (cmd == 51) {
            this.log.debug("Received SSH_MSG_USERAUTH_FAILURE");
            String mths = buffer.getString();
            boolean partial = buffer.getBoolean();
            if (partial || this.serverMethods == null) {
                this.serverMethods = Arrays.asList(mths.split(","));
                if (this.log.isDebugEnabled()) {
                    StringBuilder sb = new StringBuilder("Authentications that can continue: ");
                    for (int i = 0; i < this.serverMethods.size(); ++i) {
                        if (i > 0) {
                            sb.append(", ");
                        }
                        sb.append(this.serverMethods.get(i));
                    }
                    this.log.debug(sb.toString());
                }
                if (this.userAuth != null) {
                    this.userAuth.destroy();
                    this.userAuth = null;
                }
            }
            this.tryNext();
            return;
        }
        if (this.userAuth == null) {
            throw new IllegalStateException("Received unknown packet");
        }
        buffer.rpos(buffer.rpos() - 1);
        if (!this.userAuth.process(buffer)) {
            this.tryNext();
        }
    }

    private void tryNext() throws Exception {
        while (true) {
            if (this.userAuth == null) {
                this.currentMethod = 0;
            } else if (!this.userAuth.process(null)) {
                this.userAuth.destroy();
                ++this.currentMethod;
            } else {
                return;
            }
            while (this.currentMethod < this.clientMethods.size() && !this.serverMethods.contains(this.clientMethods.get(this.currentMethod))) {
                ++this.currentMethod;
            }
            if (this.currentMethod >= this.clientMethods.size()) {
                this.authFuture.setAuthed(false);
                return;
            }
            String method = this.clientMethods.get(this.currentMethod);
            this.userAuth = NamedFactory.Utils.create(this.authFactories, method);
            if (this.userAuth == null) {
                throw new UnsupportedOperationException("Failed to find a user-auth factory for method=" + method);
            }
            this.userAuth.init(this.session, this.service, this.identities);
        }
    }

    @Override
    protected void preClose() {
        super.preClose();
        if (!this.authFuture.isDone()) {
            this.authFuture.setException(new SshException("Session is closed"));
        }
    }
}

