/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.FileRegion;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import org.spark-project.guava.base.Preconditions;

class MessageWithHeader
extends AbstractReferenceCounted
implements FileRegion {
    private final ByteBuf header;
    private final int headerLength;
    private final Object body;
    private final long bodyLength;
    private long totalBytesTransferred;

    MessageWithHeader(ByteBuf header, Object body, long bodyLength) {
        Preconditions.checkArgument(body instanceof ByteBuf || body instanceof FileRegion, "Body must be a ByteBuf or a FileRegion.");
        this.header = header;
        this.headerLength = header.readableBytes();
        this.body = body;
        this.bodyLength = bodyLength;
    }

    public long count() {
        return (long)this.headerLength + this.bodyLength;
    }

    public long position() {
        return 0L;
    }

    public long transfered() {
        return this.totalBytesTransferred;
    }

    public long transferTo(WritableByteChannel target, long position) throws IOException {
        Preconditions.checkArgument(position == this.totalBytesTransferred, "Invalid position.");
        long writtenHeader = 0L;
        if (this.header.readableBytes() > 0) {
            writtenHeader = this.copyByteBuf(this.header, target);
            this.totalBytesTransferred += writtenHeader;
            if (this.header.readableBytes() > 0) {
                return writtenHeader;
            }
        }
        long writtenBody = 0L;
        if (this.body instanceof FileRegion) {
            writtenBody = ((FileRegion)this.body).transferTo(target, this.totalBytesTransferred - (long)this.headerLength);
        } else if (this.body instanceof ByteBuf) {
            writtenBody = this.copyByteBuf((ByteBuf)this.body, target);
        }
        this.totalBytesTransferred += writtenBody;
        return writtenHeader + writtenBody;
    }

    protected void deallocate() {
        this.header.release();
        ReferenceCountUtil.release((Object)this.body);
    }

    private int copyByteBuf(ByteBuf buf, WritableByteChannel target) throws IOException {
        int written = target.write(buf.nioBuffer());
        buf.skipBytes(written);
        return written;
    }
}

