/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.io;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.apache.spark.network.util.ByteArrayWritableChannel;
import org.apache.spark.storage.StorageUtils$;
import org.apache.spark.util.io.ChunkedByteBuffer$;
import org.apache.spark.util.io.ChunkedByteBufferInputStream;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]a!B\u0001\u0003\u0001\u0019a!!E\"ik:\\W\r\u001a\"zi\u0016\u0014UO\u001a4fe*\u00111\u0001B\u0001\u0003S>T!!\u0002\u0004\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sON\u0011\u0001!\u0004\t\u0003\u001dEi\u0011a\u0004\u0006\u0002!\u0005)1oY1mC&\u0011!c\u0004\u0002\u0007\u0003:L(+\u001a4\t\u0011Q\u0001!\u00111A\u0005\u0002Y\taa\u00195v].\u001c8\u0001A\u000b\u0002/A\u0019a\u0002\u0007\u000e\n\u0005ey!!B!se\u0006L\bCA\u000e!\u001b\u0005a\"BA\u000f\u001f\u0003\rq\u0017n\u001c\u0006\u0002?\u0005!!.\u0019<b\u0013\t\tCD\u0001\u0006CsR,')\u001e4gKJD\u0001b\t\u0001\u0003\u0002\u0004%\t\u0001J\u0001\u000bG\",hn[:`I\u0015\fHCA\u0013)!\tqa%\u0003\u0002(\u001f\t!QK\\5u\u0011\u001dI#%!AA\u0002]\t1\u0001\u001f\u00132\u0011!Y\u0003A!A!B\u00139\u0012aB2ik:\\7\u000f\t\u0005\u0006[\u0001!\tAL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005=\n\u0004C\u0001\u0019\u0001\u001b\u0005\u0011\u0001\"\u0002\u000b-\u0001\u00049\u0002BB\u001a\u0001A\u0003&A'\u0001\u0005eSN\u0004xn]3e!\tqQ'\u0003\u00027\u001f\t9!i\\8mK\u0006t\u0007b\u0002\u001d\u0001\u0005\u0004%\t!O\u0001\u0005g&TX-F\u0001;!\tq1(\u0003\u0002=\u001f\t!Aj\u001c8h\u0011\u0019q\u0004\u0001)A\u0005u\u0005)1/\u001b>fA!)Q\u0006\u0001C\u0001\u0001R\u0011q&\u0011\u0005\u0006\u0005~\u0002\rAG\u0001\u000bEf$XMQ;gM\u0016\u0014\b\"\u0002#\u0001\t\u0003)\u0015AC<sSR,g)\u001e7msR\u0011QE\u0012\u0005\u0006\u000f\u000e\u0003\r\u0001S\u0001\bG\"\fgN\\3m!\tIE*D\u0001K\u0015\tYE$\u0001\u0005dQ\u0006tg.\u001a7t\u0013\ti%JA\nXe&$\u0018M\u00197f\u0005f$Xm\u00115b]:,G\u000eC\u0003P\u0001\u0011\u0005\u0001+A\u0004u_:+G\u000f^=\u0016\u0003E\u0003\"A\u0015-\u000e\u0003MS!\u0001V+\u0002\r\t,hMZ3s\u0015\t1v+A\u0003oKR$\u0018PC\u0001\u0004\u0013\tI6KA\u0004CsR,')\u001e4\t\u000bm\u0003A\u0011\u0001/\u0002\u000fQ|\u0017I\u001d:bsV\tQ\fE\u0002\u000f1y\u0003\"AD0\n\u0005\u0001|!\u0001\u0002\"zi\u0016DQA\u0019\u0001\u0005\u0002\r\fA\u0002^8CsR,')\u001e4gKJ,\u0012A\u0007\u0005\u0006K\u0002!\tAZ\u0001\u000ei>Le\u000e];u'R\u0014X-Y7\u0015\u0005\u001dd\u0007C\u00015k\u001b\u0005I'BA\u0002\u001f\u0013\tY\u0017NA\u0006J]B,Ho\u0015;sK\u0006l\u0007bB7e!\u0003\u0005\r\u0001N\u0001\bI&\u001c\bo\\:f\u0011\u0015y\u0007\u0001\"\u0001q\u0003%9W\r^\"ik:\\7\u000fF\u0001\u0018\u0011\u0015\u0011\b\u0001\"\u0001t\u0003\u0011\u0019w\u000e]=\u0015\u0005=\"\b\"B;r\u0001\u00041\u0018!C1mY>\u001c\u0017\r^8s!\u0011qq/\u001f\u000e\n\u0005a|!!\u0003$v]\u000e$\u0018n\u001c82!\tq!0\u0003\u0002|\u001f\t\u0019\u0011J\u001c;\t\u000b5\u0004A\u0011A?\u0015\u0003\u0015B\u0001b \u0001\u0012\u0002\u0013\u0005\u0011\u0011A\u0001\u0018i>Le\u000e];u'R\u0014X-Y7%I\u00164\u0017-\u001e7uIE*\"!a\u0001+\u0007Q\n)a\u000b\u0002\u0002\bA!\u0011\u0011BA\n\u001b\t\tYA\u0003\u0003\u0002\u000e\u0005=\u0011!C;oG\",7m[3e\u0015\r\t\tbD\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u000b\u0003\u0017\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class ChunkedByteBuffer {
    private ByteBuffer[] chunks;
    private boolean disposed;
    private final long size;

    public ByteBuffer[] chunks() {
        return this.chunks;
    }

    public void chunks_$eq(ByteBuffer[] x$1) {
        this.chunks = x$1;
    }

    public long size() {
        return this.size;
    }

    public void writeFully(WritableByteChannel channel) {
        Predef$.MODULE$.refArrayOps((Object[])this.getChunks()).foreach((Function1)new Serializable(this, channel){
            public static final long serialVersionUID = 0L;
            private final WritableByteChannel channel$1;

            public final void apply(ByteBuffer bytes) {
                while (bytes.remaining() > 0) {
                    this.channel$1.write(bytes);
                }
            }
            {
                this.channel$1 = channel$1;
            }
        });
    }

    public ByteBuf toNetty() {
        return Unpooled.wrappedBuffer((ByteBuffer[])this.getChunks());
    }

    public byte[] toArray() {
        if (this.size() >= Integer.MAX_VALUE) {
            throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cannot call toArray because buffer size (", " bytes) exceeds maximum array size"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.size())})));
        }
        ByteArrayWritableChannel byteChannel = new ByteArrayWritableChannel((int)this.size());
        this.writeFully((WritableByteChannel)byteChannel);
        byteChannel.close();
        return byteChannel.getData();
    }

    public ByteBuffer toByteBuffer() {
        return this.chunks().length == 1 ? ((ByteBuffer)Predef$.MODULE$.refArrayOps((Object[])this.chunks()).head()).duplicate() : ByteBuffer.wrap(this.toArray());
    }

    public InputStream toInputStream(boolean dispose2) {
        return new ChunkedByteBufferInputStream(this, dispose2);
    }

    public boolean toInputStream$default$1() {
        return false;
    }

    public ByteBuffer[] getChunks() {
        return (ByteBuffer[])Predef$.MODULE$.refArrayOps((Object[])this.chunks()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ByteBuffer apply(ByteBuffer x$3) {
                return x$3.duplicate();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ByteBuffer.class)));
    }

    public ChunkedByteBuffer copy(Function1<Object, ByteBuffer> allocator) {
        ByteBuffer[] copiedChunks = (ByteBuffer[])Predef$.MODULE$.refArrayOps((Object[])this.getChunks()).map((Function1)new Serializable(this, allocator){
            public static final long serialVersionUID = 0L;
            private final Function1 allocator$1;

            /*
             * WARNING - void declaration
             */
            public final ByteBuffer apply(ByteBuffer chunk) {
                void var2_2;
                ByteBuffer newChunk = (ByteBuffer)this.allocator$1.apply((Object)BoxesRunTime.boxToInteger((int)chunk.limit()));
                newChunk.put(chunk);
                newChunk.flip();
                return var2_2;
            }
            {
                this.allocator$1 = allocator$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ByteBuffer.class)));
        return new ChunkedByteBuffer(copiedChunks);
    }

    public void dispose() {
        if (!this.disposed) {
            Predef$.MODULE$.refArrayOps((Object[])this.chunks()).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(ByteBuffer buffer) {
                    StorageUtils$.MODULE$.dispose(buffer);
                }
            });
            this.disposed = true;
        }
    }

    public ChunkedByteBuffer(ByteBuffer[] chunks) {
        this.chunks = chunks;
        Predef$.MODULE$.require(this.chunks() != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "chunks must not be null";
            }
        });
        Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])this.chunks()).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ByteBuffer x$1) {
                return x$1.position() == 0;
            }
        }), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "chunks' positions must be 0";
            }
        });
        this.disposed = false;
        this.size = BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])this.chunks()).map((Function1)new $anonfun$4(this), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public ChunkedByteBuffer(ByteBuffer byteBuffer) {
        this((ByteBuffer[])((Object[])new ByteBuffer[]{byteBuffer}));
    }
}

