/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.collection;

import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.memory.MemoryConsumer;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001Y4a!\u0001\u0002\u0002\u0002\u0019a!!C*qS2d\u0017M\u00197f\u0015\t\u0019A!\u0001\u0006d_2dWm\u0019;j_:T!!\u0002\u0004\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sOV\u0011QbJ\n\u0004\u00019!\u0002CA\b\u0013\u001b\u0005\u0001\"BA\t\u0007\u0003\u0019iW-\\8ss&\u00111\u0003\u0005\u0002\u000f\u001b\u0016lwN]=D_:\u001cX/\\3s!\t)\u0002$D\u0001\u0017\u0015\t9b!\u0001\u0005j]R,'O\\1m\u0013\tIbCA\u0004M_\u001e<\u0017N\\4\t\u0011m\u0001!\u0011!Q\u0001\nu\t\u0011\u0003^1tW6+Wn\u001c:z\u001b\u0006t\u0017mZ3s\u0007\u0001\u0001\"a\u0004\u0010\n\u0005}\u0001\"!\u0005+bg.lU-\\8ss6\u000bg.Y4fe\")\u0011\u0005\u0001C\u0001E\u00051A(\u001b8jiz\"\"aI\u001a\u0011\u0007\u0011\u0002Q%D\u0001\u0003!\t1s\u0005\u0004\u0001\u0005\u000b!\u0002!\u0019A\u0015\u0003\u0003\r\u000b\"A\u000b\u0019\u0011\u0005-rS\"\u0001\u0017\u000b\u00035\nQa]2bY\u0006L!a\f\u0017\u0003\u000f9{G\u000f[5oOB\u00111&M\u0005\u0003e1\u00121!\u00118z\u0011\u0015Y\u0002\u00051\u0001\u001e\u0011\u0015)\u0004A\"\u00057\u0003\u0015\u0019\b/\u001b7m)\t9$\b\u0005\u0002,q%\u0011\u0011\b\f\u0002\u0005+:LG\u000fC\u0003\u0004i\u0001\u0007Q\u0005C\u0003=\u0001\u0019EQ(\u0001\u0006g_J\u001cWm\u00159jY2$\u0012A\u0010\t\u0003W}J!\u0001\u0011\u0017\u0003\u000f\t{w\u000e\\3b]\")!\t\u0001C\t\u0007\u0006aQ\r\\3nK:$8OU3bIV\tA\t\u0005\u0002,\u000b&\u0011a\t\f\u0002\u0005\u0019>tw\rC\u0003I\u0001\u0011E\u0011*A\bbI\u0012,E.Z7f]R\u001c(+Z1e)\u00059\u0004BB&\u0001A\u0003%A)\u0001\fj]&$\u0018.\u00197NK6|'/\u001f+ie\u0016\u001c\bn\u001c7e\u0011\u0019i\u0005\u0001)A\u0005\t\u0006qb.^7FY\u0016lWM\u001c;t\r>\u00148-Z*qS2dG\u000b\u001b:fg\"|G\u000e\u001a\u0005\u0007\u001f\u0002\u0001\u000b\u0015\u0002#\u0002#5LX*Z7pef$\u0006N]3tQ>dG\r\u000b\u0002O#B\u00111FU\u0005\u0003'2\u0012\u0001B^8mCRLG.\u001a\u0005\u0007+\u0002\u0001\u000b\u0015\u0002#\u0002\u001b}+G.Z7f]R\u001c(+Z1e\u0011\u00199\u0006\u0001)Q\u0005\t\u0006\u0019r,\\3n_JL()\u001f;fgN\u0003\u0018\u000e\u001c7fI\"\u0012a+\u0015\u0005\n5\u0002\u0011\t\u0011!Q!\u0002m\u000bqg\u001c:hI\u0005\u0004\u0018m\u00195fIM\u0004\u0018M]6%kRLG\u000eJ2pY2,7\r^5p]\u0012\u001a\u0006/\u001b7mC\ndW\r\n\u0013`gBLG\u000e\\\"pk:$\bCA\u0016]\u0013\tiFFA\u0002J]RDQa\u0018\u0001\u0005\u0012\u0001\f!\"\\1zE\u0016\u001c\u0006/\u001b7m)\rq\u0014M\u0019\u0005\u0006\u0007y\u0003\r!\n\u0005\u0006Gz\u0003\r\u0001R\u0001\u000eGV\u0014(/\u001a8u\u001b\u0016lwN]=\t\u000bU\u0002A\u0011I3\u0015\u0007\u00113\u0007\u000eC\u0003hI\u0002\u0007A)\u0001\u0003tSj,\u0007\"B5e\u0001\u0004q\u0011a\u0002;sS\u001e<WM\u001d\u0005\u0006W\u0002!\taQ\u0001\u0013[\u0016lwN]=CsR,7o\u00159jY2,G\rC\u0003n\u0001\u0011\u0005\u0011*A\u0007sK2,\u0017m]3NK6|'/\u001f\u0005\u0006_\u0002!I\u0001]\u0001\fY><7\u000b]5mY\u0006<W\r\u0006\u00028c\")qM\u001ca\u0001\t\"\u0012an\u001d\t\u0003WQL!!\u001e\u0017\u0003\r%tG.\u001b8f\u0001")
public abstract class Spillable<C>
extends MemoryConsumer
implements Logging {
    private final TaskMemoryManager taskMemoryManager;
    private final long initialMemoryThreshold;
    private final long numElementsForceSpillThreshold;
    private volatile long myMemoryThreshold;
    private long _elementsRead;
    private volatile long _memoryBytesSpilled;
    public int org$apache$spark$util$collection$Spillable$$_spillCount;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    public abstract void spill(C var1);

    public abstract boolean forceSpill();

    public long elementsRead() {
        return this._elementsRead;
    }

    public void addElementsRead() {
        ++this._elementsRead;
    }

    public boolean maybeSpill(C collection, long currentMemory) {
        boolean shouldSpill = false;
        if (this.elementsRead() % 32L == 0L && currentMemory >= this.myMemoryThreshold) {
            long amountToRequest = 2L * currentMemory - this.myMemoryThreshold;
            long granted = this.acquireMemory(amountToRequest);
            this.myMemoryThreshold += granted;
            shouldSpill = currentMemory >= this.myMemoryThreshold;
        }
        boolean bl = shouldSpill = shouldSpill || this._elementsRead > this.numElementsForceSpillThreshold;
        if (shouldSpill) {
            ++this.org$apache$spark$util$collection$Spillable$$_spillCount;
            this.logSpillage(currentMemory);
            this.spill(collection);
            this._elementsRead = 0L;
            this._memoryBytesSpilled += currentMemory;
            this.releaseMemory();
        }
        return shouldSpill;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long spill(long size, MemoryConsumer trigger) {
        boolean isSpilled;
        MemoryConsumer memoryConsumer = trigger;
        Spillable spillable = this;
        if (memoryConsumer == null) {
            if (spillable == null) return 0L;
        } else if (memoryConsumer.equals(spillable)) return 0L;
        MemoryMode memoryMode = this.taskMemoryManager.getTungstenMemoryMode();
        MemoryMode memoryMode2 = MemoryMode.ON_HEAP;
        if (memoryMode == null) {
            if (memoryMode2 != null) {
                return 0L;
            }
        } else if (!((Object)((Object)memoryMode)).equals((Object)memoryMode2)) return 0L;
        if (!(isSpilled = this.forceSpill())) return 0L;
        long freeMemory = this.myMemoryThreshold - this.initialMemoryThreshold;
        this._memoryBytesSpilled += freeMemory;
        this.releaseMemory();
        long l = freeMemory;
        return l;
    }

    public long memoryBytesSpilled() {
        return this._memoryBytesSpilled;
    }

    public void releaseMemory() {
        this.freeMemory(this.myMemoryThreshold - this.initialMemoryThreshold);
        this.myMemoryThreshold = this.initialMemoryThreshold;
    }

    private void logSpillage(long size) {
        long threadId = Thread.currentThread().getId();
        this.logInfo((Function0<String>)new Serializable(this, size, threadId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Spillable $outer;
            private final long size$1;
            private final long threadId$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Thread %d spilling in-memory map of %s to disk (%d time%s so far)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.threadId$1), Utils$.MODULE$.bytesToString(this.size$1), BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$util$collection$Spillable$$_spillCount), this.$outer.org$apache$spark$util$collection$Spillable$$_spillCount > 1 ? "s" : ""}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.size$1 = size$1;
                this.threadId$1 = threadId$1;
            }
        });
    }

    public Spillable(TaskMemoryManager taskMemoryManager) {
        this.taskMemoryManager = taskMemoryManager;
        super(taskMemoryManager);
        Logging$class.$init$(this);
        this.initialMemoryThreshold = SparkEnv$.MODULE$.get().conf().getLong("spark.shuffle.spill.initialMemoryThreshold", 0x500000L);
        this.numElementsForceSpillThreshold = SparkEnv$.MODULE$.get().conf().getLong("spark.shuffle.spill.numElementsForceSpillThreshold", Long.MAX_VALUE);
        this.myMemoryThreshold = this.initialMemoryThreshold;
        this._elementsRead = 0L;
        this._memoryBytesSpilled = 0L;
        this.org$apache$spark$util$collection$Spillable$$_spillCount = 0;
    }
}

